%TASK: estimate roughness length from wave field height and wave length

%CALCULUS:-----------------------------------------------------------------

function z0 = estimatez0(z0,Hs,Lp,Aw,Bw)

% following Taylor and Yelland (2001)--------------------------------------
if numel(z0)==1
    z0   = nan(size(Hs));
else
    z0   = z0;
end
ir       = find(isnan(z0)==1 & isnan(Hs)==0 & isnan(Lp)==0);
z0(ir)   = Aw*Hs(ir).*(Hs(ir)./(Lp(ir))).^Bw;                            %m

