%TASK: estimates the water-side transfer velocity wind term dependent from 
%wind at 10m (U) or friction velocity (u_).

%CALCULUS:-----------------------------------------------------------------

function [kwind] = estimatekwind(U,u_,NSkwind)

%--------------------------------------------------------------------------

switch NSkwind   

    case 'Bea04' 
        kwind=(1+2.58*U);                                             %cm/h
           
    case 'Cea96'
        kwind=0.045+2.0277*U;                                         %cm/h
    
    case 'Jea87'
        kwind=1.57*10.^-2*u_*60*60;                                   %cm/h
    
    case 'L&M86'
        kwind=0.075*U.^2.25;                                          %cm/h
    
    case 'M&Y83'
        kwind=(34.1*10^-2*u_)*60*60;                                  %cm/h
        
    case 'MY83W'
        kwind=(144*10^-2*u_.^2.2)*60*60;                              %cm/h
        
    case 'McG01'
        kwind=3.3+0.026*U.^3;                                         %cm/h
        
    case 'Nea00'
        kwind=0.222*U.^2+0.333*U;                                     %cm/h
        
    case 'R&C01'
        kwind=1.91*exp(0.35*U);                                       %cm/h
        
    case 'Sea07'
        kwind=0.27*U.^2;                                              %cm/h
        
    case 'Wan92'
        kwind=0.31*U.^2;                                              %cm/h
        
    case 'W92en'
        kwind=b+0.31*U.^2;                                            %cm/h
        
    case 'WMG99'
        kwind=0.0283*U.^3;                                            %cm/h
        
    case 'Wea07'
        kwind=0.365*U.^2+0.46*U;                                      %cm/h
        
    case 'Zea03'
        kwind=61.79*u_.^1.22;                                         %cm/h
        
    case 'ZoJ03'
        kwind=101.4*u_.^1.88;                                         %cm/h
    case 'none.'
        kwind=zeros(size(U));
end
