%OBJECTIVES: estimates the water side-transfer velocity for given 
%temperature (T), salinity (S), wind (uz), water current (w) and depth (z).

%CALCULUS:-----------------------------------------------------------------

function [kw] = estimatekw(Tw,chemen,kwind,kbubble,kcurrent,Alfa)

%--------------------------------------------------------------------------

switch chemen                  %chemical enhancement from Wanninkhof (1992)
    case 'no.'
        b = 0;
    case 'yes'
        b = 2.5*(0.5246+0.016256.*Tw+0.00049946*Tw.^2); 
end

kw = (b+kwind+kbubble+kcurrent).*Alfa;                                %cm/h

% conversion from cm/h to m/s
kw=kw./(100*3600);                                                     %m/s
