%TASK: estimates the water-side transfer velocity bubble term dependent 
%from wind at 10m (uz) or friction velocity (u_), wind-wave frequency (fp),
%kinematic viscosity of air (Upsa) or of water (Upsw).

%CALCULUS:-----------------------------------------------------------------

function [kbubble,W] = estimatekbubble(R,u_,Hs,fp,kHpc,Upsa,Upsw,Scw,NSkbubble)

%--------------------------------------------------------------------------

switch NSkbubble
    case 'W05va'
        Rh      = u_.*Hs./Upsa;                                     %scalar
        W       = 4.02*10^-7*Rh.^0.96;                              %scalar
        kbubble = 850*W;                                              %cm/h
        
    case 'W05vw'
        Rh      = u_.*Hs./Upsw;                                     %scalar
        W       = 4.02*10^-7*Rh.^0.96;                              %scalar
        kbubble = 850*W;                                              %cm/h
        
    case 'Zhg06'
        Rb      = u_.^2./(fp.*Upsa);                                %scalar
        W       = 3.88*10^-7*Rb.^1.09;                              %scalar
        V       = 4900;
        e       = 14;
        n       = 1.2;
        Bunsen  = R*273.15*101.325.*kHcp;                           %scalar
        kbubble = W.*V./Bunsen.*(1+(e.*Bunsen.*Scw.^-0.5).^(-1/n)).^-n;%cm/h
        
    case 'ZRb03'
        Rb      = u_.^2./(fp.*Upsa);                                %scalar
        W       = codistributed(NaN);
        kbubble = 0.1315*Rb.^0.6322;                                  %cm/h
    case 'none.'
        W       = codistributed(NaN);
        kbubble = codistributed(zeros(size(u_)));
end
