%TASK: estimates the air-side transfer velocity ka (m/s)

%CALCULUS:-----------------------------------------------------------------

function ka = estimateka(psi_m,Sca,U,u_,z0,Karman,Mb,NSka)

%air transfer velocity (m/s)-----------------------------------------------
             
switch NSka
    case 'Joh10'
        i      = find(u_~=0);
        u10    = u_/Karman.*(log(10./z0)+psi_m);
        CD     = (u_./u10).^2;
        ka(i)  = 10^-3+(u10(i)./u_(i).^2+5./u_(i).*Sca(i).^(2/3)).^-1;
        i      = find(u_==0);
        ka(i) = 10^-3;
        
    case 'Dea91'
        ka = U./(770+45*Mb^(1/3));
        
    case 'Lis73'
        ka = 0.005+0.21*U./100;
        
    case 'M&Y83'
        ka = 10^-3+46.2*10^-3*u_.*Sca.^(-2/3);
        
    case 'Sea02'
        ka = Da.^0.5.*(0.98*U+1.26)./100;
        
    case 'Jef10'
        u10 = u_/Karman.*(log(10./z0)+psi_m);
        CD  = (u_./u10).^2;
        ka  = u_./(13.3*Sca.^(1/2)+CD.^(1/2)-5+log(Sca)./(2*Karman));
    case 'none '
        'Single layer transfer velocity does not use Ka scheme'
        ka  = nan(1);
end
