%TASK: estimates the Henry's constant in the Cair/Cliquid form

%CALCULUS------------------------------------------------------------------

function kH = estimatekH(P,S,Tkw,as,bs,kHcp,R,tds,Vb,Vm,NSkH)

switch NSkH
    case 'Joh10'
        %Water temperature on Henry's constant------------by Johnson (2010)

        %Henry's constant for CO2 in pure water at given temperature                         
        kHt=12.1866./(Tkw.*kHcp.*exp(tds*(1./Tkw-1/298.15)));       % scalar


        %Salinity on Henry's constant-----------------------by Johnson 2010

        % Conversion of Henry's law constant to kHcc=Csg/Csl form
        kHcc=0.0409/kHcp;                                          % scalar

        %Solubility dependent constant of proportionality between Ks and log(Vb)
        Theta=7.33532*10^-4+3.39615*10^-5*log(kHcc)-2.40888*10^-6*log(kHcc)^2 ...
              +1.57114*10^-7*log(kHcc)^3;                          % scalar

        % Empirical Setschenow constant for the specific gas;
        Ks=Theta*log(Vb);                                             % 1/S

        % Dimensionless gas-over-liquid form of Henry's law constant:
        % Kh=Csg/Csl, where (Csg = Concentration of solute in gas) and 
        % (Csl = Concentration of solute in liquid)
        kH=kHt.*10.^(Ks.*S);                                       % scalar
        
    case 'Sar13'
        f    = exp(101.32501*P.*(Vm-22.4136)./(R.*Tkw));
        pH2OP= exp(24.4543-67.4509*(100./Tkw)-4.8489*log(Tkw./100)-0.000544*S);
        beta = exp(as(1)+as(2)*100./Tkw+as(3)*log(Tkw./100)+as(4)*(Tkw./100).^2+...
               S.*(bs(1)+bs(2)*Tkw./100+bs(3)*(Tkw./100).^2));
        if as(1)==-160.7373 || as(1)==-165.8806
            kH   = 101.325./(R*Tkw.*beta.*f);
        elseif as(1)==-68.8862
            kH   = (1-pH2OP)*101.325.*Vm./(R*Tkw.*beta.*f);
        end
end
