%TASK: estimates the Schmidt number and kinematic viscosity of air

%CALCULUS:-----------------------------------------------------------------

function [Sca,Upsa] = estimateSca(P0,Ta0,Tka,Ma,Mb,Sv,Sd,Va,Vb)

%air temperature and pressure on Schmidt number of air (scalar)------------

% Diffusion coefficient of CO2 in air (cm^2/s) by Fuller et al (1966)
Mr=(Ma+Mb)/(Ma*Mb);
Da=(0.001*Tka.^1.75.*sqrt(Mr))./(P0.*(Va^(1/3)+Vb^(1/3))).^2;

%Dynamic viscosity of air (N.s/m^2)
Etaa=Sv(0+1)+Sv(1+1)*Ta0+Sv(2+1)*Ta0.^2+Sv(3+1)*Ta0.^3+Sv(4+1)*Ta0.^4;                     

%Air density (kg/m^3)
Rhoa=Sd(0+1)+Sd(1+1)*Ta0+Sd(2+1)*Ta0.^2+Sd(3+1)*Ta0.^3;                               

%Kinematic viscosity of air 
Upsa=Etaa./Rhoa;

%Schmidt number of air (scalar)with Upsa converted from m^2/s to cm^2/s
Sca=Upsa./Da.*100.*100;

