%TASK: estimate friction velocity (m/s) from Wind Log-Linear Profile with
% psi_m estimated from bulk Richardson number

%CALCULUS:-----------------------------------------------------------------

function Rib = estimateRib(P0,Ph,Tw,Tah,hrh,rL0,rLh,qh,U,hTP,g,NSrib,i)

%--------------------------------------------------------------------------
Rib = codistributed(nan(size(U)));
dz  = hTP(i);

%water-vapor saturation mixing ratio
esat0 = 0.61078.*exp(17.2694.*Tw(i)./(Tw(i)+273.15-35.86));
rsat0 = 0.622.*esat0./(101.32501.*P0(i)-esat0);
esath = 0.61078.*exp(17.2694.*Tah(i)./(Tah(i)+273.15-35.86));
rsath = 0.622.*esath./(101.32501.*Ph(i)-esath);

%sea-surface saturation specific humidity
q0  = rsat0./(1+rsat0);

%bulk Richardson number estimates
%potential temperature-------------------------------------
Tp0 = (Tw(i)+273.15).*(1000./(P0(i).*1013.25)).^0.284;
Tph = (Tah(i)+273.15).*(1000./(Ph(i).*1013.25)).^0.284;
%----------------------------------------------------------

switch NSrib

    case 'Stu88'
        %virtual potential temperature--------------------
        Tv0 = Tp0.*(1+0.61.*rsat0.*100-rL0(i));  %!!!! hr0 = 1 or 100?
        Tvh = Tph.*(1+0.61.*rsath.*hrh(i)-rLh(i));
        %-------------------------------------------------
        dTv    = Tvh-Tv0;
        Rib(i) = g.*dTv.*dz./(Tvh.*U(i).^2);

    case 'Lee97'
        dTp    = Tph-Tp0;
        Rib(i) = g.*dTp.*dz./(Tph.*U(i).^2);

    case 'G&F97'
        %virtual potential temperature-----
        Tv0 = Tp0.*(1+0.61.*q0);
        Tvh = Tph.*(1+0.61.*qh(i));
        %----------------------------------
        dTv    = Tvh-Tv0;
        Rib(i) = g.*dTv.*dz./(Tvh.*U(i).^2);
end

Rib = reshape(Rib,size(P0));
