%TASK: estimate friction velocity (m/s) from Wind Log-Linear Profile with
% psi_m estimated from bulk Richardson number

%CALCULUS:-----------------------------------------------------------------

function [psi_m,MO_L] = estimateMOS(z0,zu,Rib,Karman,NSmos)

%--------------------------------------------------------------------------

psi_m = codistributed(nan(size(z0)));
MO_L  = codistributed(nan(size(z0)));

switch NSmos

    case {'L97Bu','L97Dy','L97DG'}
        try
            iR   = find(isnan(z0)==0 & Rib<0);
            Rib_ = Rib(iR);
            zu_    = zu(iR);
            z0_    = z0(iR);
            dz_    = zu_-z0_;

            if strcmp(NSmos,'L97Bu')==1
                m_Lee = (0.05-0.11)/(10^4-10);
                b_Lee = 0.11-m_Lee*10;
                beta  = m_Lee*(zu_./z0_)+b_Lee;
                gamma = 15;
                R_m   = 0.85;
                zeta  = (zu_./dz_).*log(zu_./z0_).*(Rib_./R_m).* ...
                        1./(1-beta.*Rib_);
                L     = zu_./zeta;
                phi   = (1-gamma*zu_./L).^(1/4);
                phi0  = (1-gamma*(z0_./L)).^(1/4);
                psi   = -2*log((1+phi)./(1+phi0))...
                        -log((1+phi.^2)./(1+phi0.^2))...
                        +2*tan(phi).^-1+2*tan(phi0).^-1;

            elseif strcmp(NSmos,'L97Dy')==1
                m_Lee = (0.1-0.023)/(10^4-10);
                b_Lee = 0.023-m_Lee*10;
                beta  = m_Lee*(zu_./z0_)+b_Lee;
                gamma = 16;
                zeta  = (zu_./dz_).*log(zu_./z0_).*Rib_./(1-beta.*Rib_);
                L     = zu_./zeta;
                phi   = (1-gamma*zu_./L).^(1/4);
                phi0  = (1-gamma*(z0_./L)).^(1/4);
                psi   = -2*log((1+phi)./(1+phi0))...
                        -log((1+phi.^2)./(1+phi0.^2))...
                        +2*tan(phi).^-1+2*tan(phi0).^-1;

            elseif strcmp(NSmos,'L97DG')==1
                m_Lee = (0.08-0.01)/(10^4-10);
                b_Lee = 0.08-m_Lee*10;
                beta  = m_Lee*(zu_./z0_)+b_Lee;
                gamma = 16;
                zeta  = (zu_./dz_).*log(zu_./z0_).*Rib_./(1-beta.*Rib_);
                L     = zu_./zeta;
                phi   = (1-gamma*zu_./L).^(1/4);
                phi0  = (1-gamma*(z0_./L)).^(1/4);
                psi   = -2*log((1+phi)./(1+phi0))...
                        -log((1+phi.^2)./(1+phi0.^2))...
                        +2*tan(phi).^-1+2*tan(phi0).^-1;   
            end

            MO_L(iR)  = L;
            psi_m(iR) = psi;

        catch
            'no unstable conditions (Ri_b<0)'
        end

        try
            iR   = find(isnan(z0)==0 & Rib>=0 & Rib<0.2);
            Rib_ = Rib(iR);
            zu_  = zu(iR);
            z0_  = z0(iR);
            dz_  = zu_-z0_;

            if strcmp(NSmos,'L97Bu')==1
                beta = 4.7;
                R_m  = 0.74;
                zeta = (zu_./dz_).*log(zu_./z0_)./...
                       (2*beta./R_m.*(beta.*Rib_-1)).*...
                       (-2*beta./R_m.*Rib_+1-sqrt(1+4*beta.*(1-R_m)...
                       .*Rib_./(R_m.^2)));
                L    = zu_./zeta;
                psi  = beta.*dz_./L;

            elseif strcmp(NSmos,'L97Dy')==1 || ...
                                    strcmp(NSmos,'L97DG')==1
                beta = 5;
                zeta = (zu_./dz_).*log(zu_./z0_).*Rib_./(1-beta*Rib_);
                L    = zu_./zeta;
                psi  = beta.*dz_./L;
            end

            MO_L(iR)  = L;
            psi_m(iR) = psi;

        catch
            'no reasonably stable conditions (0<Ri_b<0.2)'
        end

        try
            iR     = find(isnan(z0)==0 & Rib>=0.2);
            [m,n]  = size(iR);
            Rib_   = Rib(iR);
            zu_    = zu(iR);
            z0_    = z0(iR);
            dz_    = zu_-z0_;
            zeta_a = (zu_./(dz_)).*log(10).* ...
                     (Rib_+13*Rib_.^2-15*Rib_.^3+3.3*Rib_.^4)./...
                     (1-0.6*Rib_.^2+0.1*Rib_.^4);
            zeta_b = (zu_./(dz_)).*log(10^4).* ...
                     (Rib_+5*Rib_.^2-7*Rib_.^3+2.1*Rib_.^4)./...
                     (1-0.6*Rib_.^2+0.1*Rib_.^4);
            xa_    = 10*ones(m,n);
            xb_    = 10^4*ones(m,n);
            m      = (zeta_b-zeta_a)./(xb_-xa_);
            zeta   = zeta_a+m.*(zu_./z0_-xa_);
            L      = zu_./zeta;
            phi    = 2/3*(zu_./L-5/0.35).^(-0.35*zu_./L);
            phi0   = 2/3*(z0_./L-5/0.35).^(-0.35*z0_./L);
            psi    = -real(-(zu_./L-z0_./L)-phi+phi0);

            MO_L(iR)  = L;
            psi_m(iR) = psi;

        catch
            'no extremely stable conditions (0.2<Ri_b)'
        end


    case 'Stu88'
        try
            iR    = find(isnan(z0)==0 & Rib<0);
            Rib_  = Rib(iR);
            zu_   = zu(iR);
            z0_   = z0(iR);
            dz_    = zu_-z0_;
            zeta  = Rib_;
            L     = zu_./zeta;
            gamma = 15;
            phi   = (1-gamma*zeta).^(1/4);            
            psi   = -2*log((1+phi)./2)-log((1+phi.^2)./2)...
                    +2*tan(phi).^-1-pi/2;

            MO_L(iR)  = L;
            psi_m(iR) = psi;

        catch
            'no unstable conditions (Ri_b<0)';
        end

        try
            iR    = find(isnan(z0)==0 & Rib>=0);
            Rib_  = Rib(iR);
            zu_   = zu(iR);
            z0_   = z0(iR);
            dz_    = zu_-z0_;
            zeta  = Rib_;
            L     = zu_./zeta;
            beta  = 4.7;
            psi   = beta.*zeta;
            
            MO_L(iR)  = L;
            psi_m(iR) = psi;

        catch
            'no stable conditions (0<Ri_b)'
        end

    case 'Lan04'
        try
            iR    = find(isnan(z0)==0 & Rig<0);
            Rig_  = Rig(iR);
            zu_   = zu(iR);
            z0_   = z0(iR);
            dz_    = zu_-z0_;
            beta  = 4.8;%!!!!
            gamma = 15;
            L     = dz_./log(zu_./z0_)*(1-5.*Rig)./Rig;
            phi   = (1-gamma.*zu_./L)^(1/4);
            phi0  = (1-gamma.*(z0_./L))^(1/4);
            psi   = -2*log((1+phi)./2)-2*tan(phi).^-1+pi/2;

            MO_L(iR)  = L;
            psi_m(iR) = psi;

        catch
            'no unstable conditions (Ri_b<0)'
        end

        try
            iR    = find(isnan(z0)==0 & Rib>=0);
            Rig_  = Rig(iR);
            zu_   = zu(iR);
            z0_   = z0(iR);
            dz_    = zu_-z0_;
            z0_   = z0(iR);
            beta  = 4.8;%!!!!
            L     = dz_./log(zu_./z0_).*(1-5*Rig)./Rig;
            psi   = beta.*dz_./L;

            MO_L(iR)  = L;
            psi_m(iR) = psi;

        catch
            'no stable conditions (0<Ri_b)'
        end
end

