                               %OBJECTIVES

%converts variables to the units more suited for the DDF

%--------------------------------------------------------------------------

                                %CALCULUS

%Conversion of air pressure units from atm to KiloPascal.
P0 = 101.32501.*P0;                                                    %KPa
Ph = 101.32501.*Ph;                                                    %KPa

%Conversion of current speed units.
if Units.w==2
   w = w.*100;                                                        %cm/s
elseif Units.w==3
   w = w.*10;                                                         %dm/s    
elseif Units.w==4
   w = w.*60;                                                        %m/min
elseif Units.w==5
   w = w.*60.*60./100;                                                %hm/h
elseif Units.w==6
   w = w.*60.*60./1000;                                               %km/h
end

%Conversion of depth units.
if Units.zw==1
   zw = zw.*10;                                                         %dm
elseif Units.zw==3
   zw = zw./10;                                                        %dam
elseif Units.zw==4
   zw = zw./100;                                                        %hm
end

%Conversion of significant wave height units.
if Units.Hs==1
   Hs = Hs*100;                                                         %cm
elseif Units.Hs==2
   Hs = Hs*10;                                                          %dm
end

%Conversion of peak wave length units.
if Units.Lp==2
   Lp = Lp./10;                                                        %dam
elseif Units.Lp==3
   Lp = Lp./100;                                                        %hm
end

%Conversion of peak wave period units.
if Units.Wp==2
   Wp = Wp./10;                                                        %10s
end

%Conversion of air TP measurement height (hTP) units
if Units.hTP==2
   hTP = hTP./10;                                                      %dam
elseif Units.hTP==3
   hTP = hTP./100;                                                      %hm
end

%Conversion of wind speed units.
if Units.U==2
   U = U.*60.*60./1000;                                               %km/h
end

%Conversion of roughness length units.
if Units.z0==1
    z0 = z0.*10000;                                                  %mm/10
elseif Units.z0==3
    z0 = z0.*100;                                                       %cm
elseif Units.z0==4
    z0 = z0.*10;                                                        %dm
end

%Conversion of friction velocity units.
if Units.u_==2
   u_ = u_.*10;                                                       %dm/s
elseif Units.u_==3
   u_ = u_.*60.*60./1000;                                             %km/h
end
