                               %OBJECTIVES

%Executes the decomposition of the difference between fluxes (DDF) into its
%several components

%--------------------------------------------------------------------------
                                %OPTIONS

%line for reference situation data
refline  = 1;

%Start parallel processing 'yes' or 'no.'
StartMP  = 'yes';

%Number of cores used
poolsize = 2;

%End parallel processing after calculus 'yes' or 'no.'
EndMP    = 'yes';
%--------------------------------------------------------------------------

                                %CALCULUS

matlabpool(poolsize)                                

run FluxNumericalOptions
run DDFNumericalOptions
run Constants

%alternative situation (xb)
run variables

Cw(refline)    = [];
Cwppm(refline) = [];
Tw(refline)    = [];
Tkw            = 273.15+Tw;
S(refline)     = [];
w(refline)     = [];
zw(refline)    = [];
Wp(refline)    = [];
Hs(refline)    = [];
Lp(refline)    = [];
Ca(refline)    = [];
Cappm(refline) = [];
Ta0(refline)   = [];
Tcool          = zeros(size(Ta0));
Twarm          = zeros(size(Ta0));
i              = find(isnan(Ta0)==1);
Ta0(i)         = Tw(i)+Twarm(i)+Tcool(i);
Tah(refline)   = [];
P0(refline)    = [];
Ph(refline)    = [];
hr0(refline)   = [];
hrh(refline)   = [];
q0(refline)    = [];
qh(refline)    = [];
rL0(refline)   = [];
rLh(refline)   = [];
hTP(refline)   = [];
U(refline)     = [];
zu(refline)    = [];
z0(refline)    = [];
vhf(refline)   = [];
psi_m(refline) = [];
u_(refline)    = [];

run GasUnitConverter
run kHExe
clear i kHcc kHcp kHt Ks Pascal Theta

run kaExe
clear beta CD dTp Etaa gamma hi hr_ i iR ir M L m n P_ phi phi0
clear psi q_ Rib_ rL_ si Tka_ Tp Upsa ustar U_ zTP
clear zu_ z0_
clear -regexp '^dz|Lee$|x\w|^esat|^rsat|^zeta'

run kwExe
clear a b Dw i j Sc0 Sc35 S_ Tkw Upsw V v msi msj 
clear Wi Ww
clear -regexp ^Eta|^Rhow

run FluxExe
Fb=Fw;

if sum(sum(isfinite(Cappm)))==numel(Cappm)
    Ca = Cappm;
end

if sum(sum(isfinite(Cwppm)))==numel(Cwppm)
    Cw = Cwppm;
end

run UnitConverter

[mx,nx]        = size(Tw);
h              = nan(2,26,mx,nx);
h(2,1,:,:)     = Cw;
h(2,2,:,:)     = Tw;
h(2,3,:,:)     = S;
h(2,4,:,:)     = w;
h(2,5,:,:)     = zw;
h(2,6,:,:)     = Wp;
h(2,7,:,:)     = Hs;
h(2,8,:,:)     = Lp;
h(2,9,:,:)     = Ca;
h(2,10,:,:)    = Ta0;
h(2,11,:,:)    = Tah;
h(2,12,:,:)    = P0;
h(2,13,:,:)    = Ph;
h(2,14,:,:)    = hr0;
h(2,15,:,:)    = hrh;
h(2,16,:,:)    = q0;
h(2,17,:,:)    = qh;
h(2,18,:,:)    = rL0;
h(2,19,:,:)    = rLh;
h(2,20,:,:)    = hTP;
h(2,21,:,:)    = U;
h(2,22,:,:)    = zu;
h(2,23,:,:)    = z0;
h(2,24,:,:)    = vhf;
h(2,25,:,:)    = psi_m;
h(2,26,:,:)    = u_;

%reference situation (xa)
run variables

Cw     = Cw(refline,:);
Cwppm  = Cwppm(refline,:);
Tw     = Tw(refline,:);
Tkw    = 273.15+Tw;
S      = S(refline,:);
w      = w(refline,:);
zw     = zw(refline,:);
Wp     = Wp(refline,:);
Hs     = Hs(refline,:);
Lp     = Lp(refline,:);
Ca     = Ca(refline,:);
Cappm  = Cappm(refline,:);
Ta0    = Ta0(refline,:);
Tcool  = zeros(size(Ta0));
Twarm  = zeros(size(Ta0));
i      = find(isnan(Ta0)==1);
Ta0(i) = Tw(i)+Twarm(i)+Tcool(i);
Tah    = Tah(refline,:);
P0     = P0(refline,:);
Ph     = Ph(refline,:);
hr0    = hr0(refline,:);
hrh    = hrh(refline,:);
q0     = q0(refline,:);
qh     = qh(refline,:);
rL0    = rL0(refline,:);
rLh    = rLh(refline,:);
hTP    = hTP(refline,:);
U      = U(refline,:);
zu     = zu(refline,:);
z0     = z0(refline,:);
vhf    = vhf(refline,:);
psi    = psi_m(refline,:);
u_     = u_(refline,:);

run GasUnitConverter
run kHExe
clear i kHcc kHcp kHt Ks Pascal Theta

run kaExe
clear beta CD dTp Etaa gamma hi hr_ i iR ir Karman M L m n P_ phi phi0
clear psi q_ Rib_ rL_ si Tka_ Tp Upsa ustar U_ zTP
clear zu_ z0_
clear -regexp '^dz|Lee$|x\w|^esat|^rsat|^zeta'

run kwExe
clear a b Dw i j Sc0 Sc35 S_ Tkw Upsw V v msi msj 
clear Wi Ww
clear -regexp ^Eta|^Rhow

run FluxExe
Fa=nan(mx,nx);
for j=1:nx
    Fa(:,j)=Fw;
end

if sum(sum(isfinite(Cappm)))==numel(Cappm)
    Ca = Cappm;
end

if sum(sum(isfinite(Cwppm)))==numel(Cwppm)
    Cw = Cwppm;
end

run UnitConverter
for i=1:nx
    h(1,1,:,i)  = Cw(refline,i)*ones(mx,1);
    h(1,2,:,i)  = Tw(refline,i)*ones(mx,1);
    h(1,3,:,i)  = S(refline,i)*ones(mx,1);
    h(1,4,:,i)  = w(refline,i)*ones(mx,1);
    h(1,5,:,i)  = zw(refline,i)*ones(mx,1);
    h(1,6,:,i)  = Wp(refline,i)*ones(mx,1);
    h(1,7,:,i)  = Hs(refline,i)*ones(mx,1);
    h(1,8,:,i)  = Lp(refline,i)*ones(mx,1);
    h(1,9,:,i)  = Ca(refline,i)*ones(mx,1);
    h(1,10,:,i) = Ta0(refline,i)*ones(mx,1);
    h(1,11,:,i) = Tah(refline,i)*ones(mx,1);
    h(1,12,:,i) = P0(refline,i)*ones(mx,1);
    h(1,13,:,i) = Ph(refline,i)*ones(mx,1);
    h(1,14,:,i) = hr0(refline,i)*ones(mx,1);
    h(1,15,:,i) = hrh(refline,i)*ones(mx,1);
    h(1,16,:,i) = q0(refline,i)*ones(mx,1);
    h(1,17,:,i) = qh(refline,i)*ones(mx,1);
    h(1,18,:,i) = rL0(refline,i)*ones(mx,1);
    h(1,19,:,i) = rLh(refline,i)*ones(mx,1);
    h(1,20,:,i) = hTP(refline,i)*ones(mx,1);
    h(1,21,:,i) = U(refline,i)*ones(mx,1);
    h(1,22,:,i) = zu(refline,i)*ones(mx,1);
    h(1,23,:,i) = z0(refline,i)*ones(mx,1);
    h(1,24,:,i) = vhf(refline,i)*ones(mx,1);
    h(1,25,:,i) = psi_m(refline,i)*ones(mx,1);
    h(1,26,:,i) = u_(refline,i)*ones(mx,1);
end

hmax = max(max(h,[],3));
hmin = min(min(h,[],3));

%differences in the flux and in the environmental variables
dF = Fb-Fa;
h  = squeeze(h(2,:,:,:)-h(1,:,:,:))';

clear i j mx refline                                                 %local
clear Ca Cw Hs hr0 hrh hTP kH ka kw kwCurrent kwWind Lp MO_L P0     %global
clear Pascal Ph Rib rL0 rLh q0 qh S Ta0 Tah Tcool Tka Tw Twarm      %global
clear U u_ vhf Wp w zu zw z0                                        %global
clear -regexp '^F|^K|^psi'                                          %global                                                          

h(isnan(h))=0;

%Estimation of loose delta(i)
i=find(isnan(delta)==1);
delta(i)=abs((hmax(i)-hmin(i))./stepn(i));

%Direction of the estimation of the partial derivatives (+ or -)
%delta_ = nan(size(h));
%parfor i=1:size(h,1)
%    delta_(i,:)=h(i,:)./abs(h(i,:)).*delta;
%end
%[m,n]               = size(delta_);
%delta_(h==0)        = 1;
%delta_(isnan(h))    = 0;
%forward_            = zeros(m,n);
%forward_(delta_>=0) = 1;
%backward_           = zeros(m,n);
%backward_(delta_<0) = 1;

clear i m n

%Array with CO2 flux estimates
ti    = cputime;
y     = zeros(stepn+ones(size(stepn)));
ysize = size(y);
ynum  = numel(y)
s     = nan(1,26);

for ij=1:ynum
    [s(1),s(2),s(3),s(4),s(5),s(6),s(7),s(8),s(9),s(10),s(11),s(12), ...
     s(13),s(14),s(15),s(16),s(17),s(18),s(19),s(20),s(21),s(22),s(23), ...
     s(24),s(25),s(26)] = ind2sub(ysize,ij);
    
    hplus = hmin+(s-1).*delta;
    
    Cw  = hplus(1);                                                   %/1000;
    Tw  = hplus(2);
    Tkw = 273.15+Tw;
    S   = hplus(3);

    if Units.w==1
        w = hplus(4);
    elseif Units.w==2
        w = hplus(4)/100;
    elseif Units.w==3
        w = hplus(4)/10;
    elseif Units.w==4
        w = hplus(4)/60;
    elseif Units.w==5
        w = hplus(4)/3600;
    elseif Units.w==6
        w = hplus(4)/3600;
    end

    if Units.zw==1
        zw = hplus(5)/10;
    elseif Units.zw==2
        zw = hplus(5);
    elseif Units.zw==3
        zw = hplus(5)*10;
    elseif Units.zw==4
        zw = hplus(5)*100;
    end
    
    if Units.Wp==1
        Wp = hplus(6);
    elseif Units.Wp==2
        Wp = hplus(6)*10;
    elseif Units.Wp==3
        Wp = hplus(6)*100;
    end
    
    if Units.Hs==1
        Hs = hplus(7)/100;
    elseif Units.Hs==2
        Hs = hplus(7)/10;
    elseif Units.Hs==3
        Hs = hplus(7);
    end

    if Units.Lp==1
        Lp = hplus(8);
    elseif Units.Lp==2
        Lp = hplus(8)*10;
    elseif Units.Lp==3
        Lp = hplus(8)*100;
    end
    
    Ca     = hplus(9);                           %/1000;
    Ta0    = hplus(10);
    Tka    = Ta0+273.15;
    Tah    = hplus(11);
    P0     = hplus(12)/101.32501;
    Ph     = hplus(13)/101.32501;
    hr0    = hplus(14);
    hrh    = hplus(15);
    q0     = hplus(16);
    qh     = hplus(17);
    rl0    = hplus(18);
    rLh    = hplus(19);
    
    if Units.Lp==1
        hTP = hplus(20);
    elseif Units.Lp==2
        hTP = hplus(20)*10;
    elseif Units.Lp==3
        hTP = hplus(20)*100;
    end
    
    if Units.U==1
        U = hplus(21);
    elseif Units.U==2
        U = hplus(21)*1000/3600;
    end
    
    zu = hplus(22);
    
    if Units.z0==1
        z0 = hplus(23)/10000;
    elseif Units.z0==2
        z0 = hplus(23)/1000;
    elseif Units.z0==3
        z0 = hplus(23)/100;
    elseif Units.z0==4
        z0 = hplus(23)/10;
    end
    
    vhf   = hplus(24);
    psi_m = hplus(25);
    
    if Units.u_==1
        u_= hplus(26);
    elseif Units.u_==2
        u_= hplus(26)*10;
    elseif Units.u_==3
        u_= hplus(26)*1000/3600;
    end

    if isnan(Cappm)==0
       Pascal = P0*101325.01;
       Ca     = Ca.*Pascal./(10^6*R*Tka);
    end

    if isnan(Cwppm)==0
        run kHExe
        kHcp = 12.1884./(Tka.*kH);
        Cw   = Cw.*kHcp.*P0*10^-3;
    end
    
    run kaExe
    run kHExe
    run kwExe
    run FluxExe
    y(ij) = Fw;
end

dt1=cputime-ti
clear Aw Bw ans c cp dt1 Fw g i ir j nx Omega Pascal phiw psi_m tds ti w
clear -regexp '^a|^b|^C|^Et|^hr|^k|^M|^ms|^q|^Rh|^r|^S|^s|^T|^U|^V|^v|^W|^z'

%1. To estimate the Delta array
ti=cputime;
hyperD=ones(ynum,1);

parfor ij=1:ynum

    [m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11,m12,m13,m14,m15,m16,m17,m18,m19...
     m20,m21,m22,m23,m24,m25,m26]=ind2sub(ysize,ij);
        
    m=[m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 m11 m12 m13 m14 m15 m16 m17 m18 ...
        m19 m20 m21 m22 m23 m24 m25 m26];
    
    msum=sum(m);
    mprod=prod(m);
    d=zeros(1,mprod);
    ii=1:mprod;
    
    [j1,j2,j3,j4,j5,j6,j7,j8,j9,j10,j11,j12,j13,j14,j15,j16,j17,j18,j19...
     j20,j21,j22,j23,j24,j25,j26]=ind2sub(m,ii);
 
    j=[j1 j2 j3 j4 j5 j6 j7 j8 j9 j10 j11 j12 j13 j14 j15 j16 j17 j18 ...
       j19 j20 j21 j22 j23 j24 j25 j26];

    %1.1 To estimate each Delta (each hyperD: it is the sum of each d array)
    msum=kron(msum,ones(1,mprod));
    jsum=sum(j);
    m=kron(m,ones(1,mprod));
    %1.1.1 To estimate Newton's polynomial
    polyNewton=factorial(m-1)./(factorial(j-1).*factorial(m-1-(j-1)));
    %1.1.2 To set formula for forward or backward estimation
    %fo=kron(forward_j,ones(1,mprod));
    %ba=kron(backward_j,ones(1,mprod));
    %j_=j.*fo+m.*ba-j.*ba+ba;
    %1.1.3 To convert the y indexes from 26D to 1D
    %ii=sub2ind(ysize,j_(1,:),j_(2,:),j_(3,:),j_(4,:),j_(5,:),...
     %j_(6,:),j_(7,:),j_(8,:),j_(9,:),j_(10,:),j_(11,:),j_(12,:),...
     %j_(13,:),j_(14,:),j_(15,:),j_(16,:),j_(17,:));
    %d=(-1).^((msum-17)-(jsum-17)).*prod(polyNewton,1).*y(ii);
    %hyperD(i1)=sum(d);
end

matlabpool close
%---------------------------------------------------------------------
%hyperD=reshape(hyperD,ysize);
dt2=cputime-ti
clear A ba d d_ fo k polyNewton
clear -regexp 'J$|^j|^m'

%Estimating the iK array
ti=cputime;
for var=1:nvar

k=dfdx_at_k(var);

if h(var)>=0   %iK coefficients vector estimated forward

    iK=...
[1 k (k^2-k)/factorial(2) (k^3-3*k^2+2*k)/factorial(3) ...
(k^4-6*k^3+11*k^2-6*k)/factorial(4) (k^5-10*k^4+35*k^3-50*k^2+24*k)/factorial(5);

0 1  (2*k-1)/factorial(2) (3*k^2-6*k+2)/factorial(3) ...
(4*k^3-18*k^2+22*k-6)/factorial(4) (5*k^4-40*k^3+105*k^2-100*k+24)/factorial(5);

0 0 1 (6*k-6)/factorial(3) (12*k^2-36*k+22)/factorial(4) ...
(20*k^3-120*k^2+210*k-100)/factorial(5);

0 0 0 1 (24*k-36)/factorial(4) (60*k^2-240*k+210)/factorial(5);

0 0 0 0 1 (120*k-240)/factorial(5);

0 0 0 0 0 1];

elseif h(var)<0 %iK coefficients vector estimated backward

    iK=...
[1 -k (k^2-k)/factorial(2) -(k^3-3*k^2+2*k)/factorial(3) ...
(k^4-6*k^3+11*k^2-6*k)/factorial(4) -(k^5-10*k^4+35*k^3-50*k^2+24*k)/factorial(5);

0 -1  (2*k-1)/factorial(2) -(3*k^2-6*k+2)/factorial(3) ...
(4*k^3-18*k^2+22*k-6)/factorial(4) -(5*k^4-40*k^3+105*k^2-100*k+24)/factorial(5);

0 0 1 -(6*k-6)/factorial(3) (12*k^2-36*k+22)/factorial(4) ...
-(20*k^3-120*k^2+210*k-100)/factorial(5);

0 0 0 -1 (24*k-36)/factorial(4) -(60*k^2-240*k+210)/factorial(5);

0 0 0 0 1 -(120*k-240)/factorial(5);

0 0 0 0 0 -1];    
end

delta_c=delta_b(var).^(0:theta(var));

for i_iK=0:theta(var)
    iK_array(var).derivatives(i_iK+1)=...
                 {iK(i_iK+1,1:n(var)+1)./delta_c(i_iK+1)};
end  
end

clear delta_ dfdx_at_k iK i_iK k variable y

%Finalizing numerical estimates of partial derivatives by doing the
%element-wise product of the D array with the K array
Theta=theta+ones(size(theta));
for j=1:prod(Theta)
[m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11,m12,m13,m14,m15,m16,m17]=...
    ind2sub(Theta,j);

m(1)=m1; m(2)=m2; m(3)=m3; m(4)=m4; m(5)=m5; m(6)=m6;  m(7)=m7;
m(8)=m8; m(9)=m9; m(10)=m10; m(11)=m11; m(12)=m12; m(13)=m13;
m(14)=m14; m(15)=m15; m(16)=m16; m(17)=m17;

for var=1:nvar

    if var==1
        hyperK=...
        cell2mat(iK_array(var).derivatives(m(var)))';

    elseif var>1
        auxB=...
         cell2mat(iK_array(var).derivatives(m(var)));

        for i_B=1:size(auxB,2)
            auxC(i_B).field=auxB(i_B).*hyperK;
        end
        auxC=auxC(1:i_B);
        hyperK=cat(var,auxC.field);
    end
end

difdxi(m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11,m12,m13,m14,m15,m16,m17)=...
sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(...
                           sum(hyperD.*hyperK)))))))))))))))));

end

clear i_B Theta
clear -regexp '^aux|^iK|^i\d|^m|^N|^hyper'

%Estimating the coefficients for the terms with h and factorials.
%This algorithm is 14x faster than using function 'ndgrid' proceeded 
%by the element-wise multiplication of the 16 provisional arrays
for var=1:nvar
if var==1
    hyperH=(h(1).^(0:theta(1))./factorial(0:theta(1)))';

elseif var>1
    auxB=(h(var).^(0:theta(var))...
                               ./factorial(0:theta(var)));

    for i_B=1:size(auxB,2)
        auxC(i_B).field=(auxB(i_B).*hyperH);
    end
    auxC=auxC(1:i_B);
    hyperH=cat(var,auxC.field);
end
end

%Finalizing the Taylor expansion, estimating its sum and the error
TaylorArray=hyperH.*difdxi;
TaylorArray(1)=0;
error1_absolute(t,site)=Fxb(t,site)-Fxa(t)-...
sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(...
                              sum(TaylorArray)))))))))))))))));
error1_relative(t,site)=...
                  error1_absolute(t,site)/(Fxb(t,site)-Fxa(t));

clear difdxi i_B theta
clear -regexp '^aux|^hyper'

%Partition of multivariate terms among variables       
size(TaylorArray);
for var=1:nvar
try
    h2(var)={[0 ones(1,ans(var)-1)]};
catch
    h2(var)={0};
end
end

[H1,H2,H3,H4,H5,H6,H7,H8,H9,H10,H11,H12,H13,H14,H15,H16,H17] = ...
ndgrid(cell2mat(h2(1)),cell2mat(h2(2)),cell2mat(h2(3)),...
    cell2mat(h2(4)),cell2mat(h2(5)),cell2mat(h2(6)),...
    cell2mat(h2(7)),cell2mat(h2(8)),cell2mat(h2(9)),...
    cell2mat(h2(10)),cell2mat(h2(11)),cell2mat(h2(12)),...
    cell2mat(h2(13)),cell2mat(h2(14)),cell2mat(h2(15)),...
    cell2mat(h2(16)),cell2mat(h2(17)));

sumH=H1+H2+H3+H4+H5+H6+H7+H8+H9+H10+H11+H12+H13+H14+H15+H16+H17;
i=find(sumH==0);
sumH(i)=1;

partition(1).field  = H1./sumH;
partition(2).field  = H2./sumH;
partition(3).field  = H3./sumH;
partition(4).field  = H4./sumH;
partition(5).field  = H5./sumH;
partition(6).field  = H6./sumH;
partition(7).field  = H7./sumH;
partition(8).field  = H8./sumH;
partition(9).field  = H9./sumH;
partition(10).field = H10./sumH;
partition(11).field = H11./sumH;
partition(12).field = H12./sumH;
partition(13).field = H13./sumH;
partition(14).field = H14./sumH;
partition(15).field = H15./sumH;
partition(16).field = H16./sumH;
partition(17).field = H17./sumH;

clear ans i sumH h2
clear -regexp '^H\d'                                         %local

for var=1:nvar
DDF(var,t,site)=...
sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(sum(...
    sum(sum(partition(var).field.*TaylorArray)))))))))))))))));
end

clear partition var

error2_absolute(t,site)=Fxb(t,site)-Fxa(t)-sum(DDF(:,t,site),1);
error2_relative(t,site)=...
                  error2_absolute(t,site)/(Fxb(t,site)-Fxa(t));
dt3=cputime-ti

        
clear('-regexp', '^A|^C|^Dw|^Dr|^E|^F|^Hs|^K|^L|^M|^P|^R|^S|^T|^U|^V|^W')
clear('-regexp', '^a|^b|^d|^for|^h|^i|^k|^m|m$|^n|^p|ppm$|^r|site$|^t|^u|^v|^w|^z')
clear Bw c cp Da epsilon esat fTS g Hxy j loose Omega
        
