%% Authors: R. Raj, N.A.S. Hamm, C. van der Tol, and A. Stein
%% Affiliation: ITC, University of Twente, The Netherlands
%% Date: 22 August 2016
%% Version: 1 

%% The reader is referred to Vrugt (2016) for the details of each keyword, such as "DREAMPar.N", and "DREAMPar.T", used below.  

%% Problem settings defined by user
DREAMPar.d = 9;                          % Dimension of the problem 
DREAMPar.N = 10;                         % Number of Markov chains
DREAMPar.T = 15000;                      % Number of generations (iterations)
DREAMPar.lik = 13;                       % Likelihood function

%% Provide information: parameter space and initial sampling
Par_info.initial = 'prior';              % Sample from prior distributions of BIOME-BGC parameters
Par_info.boundhandling = 'fold';         % Explicit boundary handling

%%Define prior probability density functions of:(1)BIOME-BGC parameters (LFRT, FRC:LC, CNleaf, Wint, FLNR, SD), which are included in calibration. See Table 1 of the main text for more details about the parameters.   
%%                                     (2) parameters "a" and "b" of measurement error model (see "Meas_info.Sigma" below)
%%                                     (3) parameter "phi(φ)" of likelihood function of type 13 (For more detail, see Section 3.3.2 of the main text and Vrugt (2016)).  
%%name                 LFRT                    FRC:LC                   C:Nleaf               Wint                   FLNR                  SD          |     a              b               phi
Par_info.prior = {'unifpdf(0.196, 0.5)', 'unifpdf(0.78 ,2.16)', 'normpdf(26.731,3.731)','normpdf(0.04,0.02)', 'betapdf(25.67,756.28)', 'unifpdf(0.4,2)', 'unifpdf(0,1)','unifpdf(0,1)','unifpdf(-1,1)'};                    

%%name          LFRT   FRC:LC  C:Nleaf    Wint    FLNR    SD  |  a  b   phi 
Par_info.min = [0.196   0.78     14       0.01    0.013   0.4    0  0   -1   ];   % Lower bound of each parameter
Par_info.max = [0.5     2.16     32       0.09    0.044   2.0    1  1    1   ];   % Upper bound of each parameter
%% Note: (1) Lower and upper bound of BIOME-BGC parameters are based on the reasonable choice of the realistic range for Douglas-fir tree species at the study site. 
%%       (2) Lower and upper bound of parameters a, b, and phi are based on the suggestion of Vrugt (2016).

%% Define name of the function (.m file) for posterior exploration.
Func_name = 'BIOME-BGCrunScript';

%% Define the flux tower GPP data
load TowerGPP.txt; Meas_info.Y = TowerGPP(:,1); 
%% Define measurement error model
Meas_info.Sigma = inline('a*Y + b'); 
 
%% Optional settings
options.parallel = 'yes';               % Run each chain on a different core
options.IO = 'yes';                     % Input-output writing of model files (only for parallel!)
options.modout = 'yes';                 % Return model (function) simulations of samples (yes/no)?

%% Run the DREAM algorithm
[chain,output,fx] = DREAM(Func_name,DREAMPar,Par_info,Meas_info,options);

%%% Reference:
%%% Vrugt, J. A., 2016. Markov chain Monte Carlo simulation using the DREAM software package: Theory, concepts, and MATLAB implementation. Environmental Modelling & Software 75, 273–316.