%the program producing 1000000 random vector B, computing Rv, MDA, and drawing
%figure 3
% --------------------------------------------------------------------------------
clear
clc
close all
% --------------------------------------------------------------------------------
n=30;
% Import a 30-dimensional random vector: data(30,2)
load('vectorA.mat')

nsample=1000000;
% --------------------------------------------------------------------------------
cordat(1:nsample)=0;
coooo(1:nsample)=0;
angl(1:nsample)=0;
% --------------------------------------------------------------------------------
for jj=1:nsample
randa=unifrnd(0,180.,1,30); 
resdata=data;
for ii=1:n
    resdata(ii,:)=rotangle(data(ii,:),randa(ii));
end
    dede=sqrt(sum(data.*data,2));
    coo=corrcoef(dede,randa);   % correlation coefficient between vector length and the included angle between the two vectors
    coooo(jj)=coo(1,2);
    cordat(jj)=Rv(data,resdata); % vector similarity coefficient between vecotr A and vector B
    
    LA=sqrt(sum(sum(data.*data))/n);
    LB=sqrt(sum(sum(resdata.*resdata))/n);
    for  kk=1:n
        angl1(kk)=acosd(sum(data(kk,:).*resdata(kk,:))/norm(data(kk,:))/norm(resdata(kk,:)));
    end
    angl(jj)=mean(angl1);  % mean difference of angles between two vector fields
end  
% ------------------------------------------------------------------------------
save unif0420.mat
figure(1)
colormap(jet)
scatter(angl(1:end),cordat(1:end),4,coooo(1:end))
xlabel('MDA','FontWeight','Bold','FontSize',16)
ylabel('Rv','FontWeight','Bold','FontSize',16)
set(gca,'xgrid','on')
set(gca,'ygrid','on')
set(gca,'FontSize',12) 
colorbar
