! Copyright (c) 2013,  Los Alamos National Security, LLC (LANS)
! and the University Corporation for Atmospheric Research (UCAR).
!
! Unless noted otherwise source code is licensed under the BSD license.
! Additional copyright and license information can be found in the LICENSE file
! distributed with this code, or at http://mpas-dev.github.com/license.html
!
program mpas

   use mpas_subdriver

   implicit none

! DH* MARK
#ifdef BLUEGENE_MEMCHECK
   write(stdoutUnit, *) ' ** memusage before mpas_init **'
   call memusage()
#endif
   call print_date_and_time(' Entering mpas_init ')
! *DH ENDMARK
   call mpas_init()
! DH* MARK
#ifdef BLUEGENE_MEMCHECK
   write(stdoutUnit, *) ' ** memusage before mpas_run **'
   call memusage()
#endif
   call print_date_and_time(' Entering mpas_run ')
! *DH ENDMARK
   call mpas_run() 
! DH* MARK
#ifdef BLUEGENE_MEMCHECK
   write(stdoutUnit, *) ' ** memusage before mpas_finalize **'
   call memusage()
#endif
   call print_date_and_time(' Entering mpas_finalize ')
! *DH ENDMARK
   call mpas_finalize()
! DH* MARK
   call print_date_and_time(' Finished model integration')
#ifdef BLUEGENE_MEMCHECK
   write(stdoutUnit, *) ' ** memusage after mpas_finalize **'
   call memusage()
#endif
! *DH ENDMARK
   stop

! DH* MARK
contains

    subroutine print_date_and_time(textstring)
        implicit none
        character(len=*), intent(in) :: textstring
        real (kind=RKIND) :: cputime
        call cpu_time(cputime)
        write(stderrUnit,*) trim(textstring), ' at ', cputime
    end subroutine print_date_and_time
    ! *DH ENDMARK

end program mpas
