!     ######################
      MODULE MODD_PARAM_LIMA
!     ######################
!
!!****  *MODD_PARAM_LIMA* - declaration of the control parameters
!!                               for use in the LIMA scheme.
!!
!!    PURPOSE
!!    -------
!!      The purpose of this declarative module is to declare the microphysical
!!    constants. This includes the descriptive parameters for the raindrop 
!!    and the parameters relevant of the dimensional distributions.
!!
!!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    AUTHOR
!!    ------
!!	J.-P. Pinty  *Laboratoire d'Aerologie*
!!      S.    Berthet    * Laboratoire d'Aerologie*
!!      B.    Vié        * Laboratoire d'Aerologie*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original             ??/??/13 
!!
!-------------------------------------------------------------------------------
!
IMPLICIT NONE
!
LOGICAL, SAVE :: LLIMA_DIAG             ! Compute diagnostics for concentration /m3
!
!*       1.   COLD SCHEME
!             -----------
!
! 1.1 Cold scheme configuration
!
LOGICAL, SAVE :: LCOLD                  ! TRUE to enable the cold scheme
LOGICAL, SAVE :: LNUCL                  ! TRUE to enable ice nucleation
LOGICAL, SAVE :: LSEDI                  ! TRUE to enable pristine ice sedimentation
LOGICAL, SAVE :: LHHONI                 ! TRUE to enable freezing of haze particules
LOGICAL, SAVE :: LSNOW                  ! TRUE to enable snow and graupel
LOGICAL, SAVE :: LHAIL                  ! TRUE to enable hail
LOGICAL, SAVE :: LMEYERS                ! TRUE to use Meyers nucleation
!
! 1.2 IFN initialisation
!
INTEGER, SAVE          :: NMOD_IFN      ! Number of IFN modes
REAL, SAVE             :: CIFN1         ! Ref. concentration of IFN mode 1 (#/L)
REAL, SAVE             :: CIFN2         ! Ref. concentration of IFN mode 2 (#/L)
LOGICAL, SAVE          :: IFN_HOM       ! True for z-homogeneous IFN concentrations
CHARACTER(LEN=8), SAVE :: IFN_SPECIES   ! Internal mixing species definitions
CHARACTER(LEN=8), SAVE :: INT_MIXING    ! Internal mixing type selection (pure DM1 ...)
INTEGER, SAVE          :: NMOD_IMM      ! Number of CCN modes acting by immersion
INTEGER, SAVE          :: IND_SPECIE    ! CCN acting by immersion are considered pure
                                        ! IFN of either DM = 1, BC = 2 or O = 3
INTEGER, DIMENSION(:), SAVE, ALLOCATABLE :: NIMM        ! Link between CCN and IMM modes
INTEGER, DIMENSION(:), SAVE, ALLOCATABLE :: NINDICE_CCN_IMM ! ??????????
INTEGER, SAVE                            :: NSPECIE     ! Internal mixing number of species
REAL, DIMENSION(:),    SAVE, ALLOCATABLE :: XMDIAM_IFN  ! Mean diameter of IFN modes
REAL, DIMENSION(:),    SAVE, ALLOCATABLE :: XSIGMA_IFN  ! Sigma of IFN modes
REAL, DIMENSION(:),    SAVE, ALLOCATABLE :: XRHO_IFN    ! Density of IFN modes 
REAL, DIMENSION(:,:),  SAVE, ALLOCATABLE :: XFRAC       ! Composition of each IFN mode
REAL, DIMENSION(:),    SAVE, ALLOCATABLE :: XFRAC_REF   ! AP compostion in Phillips 08
REAL, DIMENSION(:),    SAVE, ALLOCATABLE :: IFN_CONC    ! ??????????? 
!
! 1.3 Ice characteristics
!
CHARACTER(LEN=4), SAVE :: CPRISTINE_ICE_LIMA ! Pristine type PLAT, COLU or BURO
CHARACTER(LEN=4), SAVE :: CHEVRIMED_ICE_LIMA ! Heavily rimed type GRAU or HAIL
REAL,SAVE              :: XALPHAI,XNUI,    & ! Pristine ice   distribution parameters
	                  XALPHAS,XNUS,    & ! Snow/aggregate distribution parameters
	                  XALPHAG,XNUG       ! Graupel        distribution parameters
!
! 1.4 Phillips (2013) nucleation parameterization
!
INTEGER, SAVE          :: NPHILLIPS     ! =8 for Phillips08, =13 for Phillips13
!
REAL, DIMENSION(4), SAVE   :: XT0       ! Threshold of T in H_X for X={DM1,DM2,BC,O} [K]
REAL, DIMENSION(4), SAVE   :: XDT0      ! Range in T for transition of H_X near XT0 [K]
REAL, DIMENSION(4), SAVE   :: XDSI0     ! Range in Si for transition of H_X near XSI0
REAL,               SAVE   :: XSW0      ! Threshold of Sw in H_X 
REAL,               SAVE   :: XRHO_CFDC ! Air density at which CFDC data were reported [kg m**3]
REAL, DIMENSION(4), SAVE   :: XH        ! Fraction<<1 of aerosol for X={DM,BC,O}
REAL, DIMENSION(4), SAVE   :: XAREA1    ! Total surface of all aerosols in group X with
                            ! diameters between 0.1 and 1 µm, for X={DM1,DM2,BC,O} [m**2 kg**-1]
REAL,               SAVE   :: XGAMMA    ! Factor boosting IN concentration due to 
                                        ! bulk-liquid modes
!
REAL, DIMENSION(4), SAVE   :: XTX1      ! Threshold of T in Xi for X={DM1,DM2,BC,O} [K]
REAL, DIMENSION(4), SAVE   :: XTX2      ! Threshold of T in Xi for X={DM1,DM2,BC,O} [K]
!
REAL,DIMENSION(:), SAVE, ALLOCATABLE :: ZABSCISS, ZWEIGHT ! Gauss quadrature method 
INTEGER,           SAVE              :: NDIAM             ! Gauss quadrature accuracy 
!
! 1.5 Meyers (1992) nucleation parameterization
!
REAL,SAVE :: XFACTNUC_DEP,XFACTNUC_CON  ! Amplification factor for IN conc.
                                        !   DEP refers to DEPosition mode
                                        !   CON refers to CONtact    mode
!
!-------------------------------------------------------------------------------
!
!
!*       2.   WARM SCHEME
!             -----------
!
! 2.1 Warm scheme configuration
!
LOGICAL, SAVE :: LWARM         ! TRUE to enable the warm scheme
LOGICAL, SAVE :: LACTI         ! TRUE to enable CCN activation
LOGICAL, SAVE :: LRAIN         ! TRUE to enable the formation of rain
LOGICAL, SAVE :: LSEDC         ! TRUE to enable the droplet sedimentation
LOGICAL, SAVE :: LACTIT        ! TRUE to enable the usage of dT/dt in CCN activation
LOGICAL, SAVE :: LBOUND        ! TRUE to enable the continuously replenishing
                               ! aerosol concentrations through the open
                               ! lateral boundaries -> boundaries.f90
!
! 2.2 CCN initialisation
!
INTEGER,         SAVE                 :: NMOD_CCN      ! Number of CCN modes
REAL,            SAVE                 :: CCCN1         ! CCN mode 1 conc.  (#/cm3)
REAL,            SAVE                 :: CCCN2         ! CCN mode 2 conc.  (#/cm3)
REAL,            SAVE                 :: CCCN3         ! CCN mode 3 conc.  (#/cm3)
REAL,            SAVE                 :: CCCN4         ! CCN mode 4 conc.  (#/cm3)
LOGICAL,         SAVE                 :: CCN_HOM       ! True for z-homogeneous CCN concentrations
CHARACTER(LEN=8),SAVE                 :: CCN_MODES     ! CCN modes characteristics (Jungfraujoch ...)
REAL, DIMENSION(:), SAVE, ALLOCATABLE :: XR_MEAN_CCN,   & ! Mean radius of CCN modes
                                         XLOGSIG_CCN,   & ! Log of geometric dispersion of the CCN modes
                                         XRHO_CCN         ! Density of the CCN modes
REAL, DIMENSION(:), SAVE, ALLOCATABLE :: CCN_CONC         ! Ref. concentration ???????????????
REAL, DIMENSION(:), SAVE, ALLOCATABLE :: XKHEN_MULTI,   & ! Parameters defining the CCN activation
                                         XMUHEN_MULTI,  & ! spectra for a multimodal aerosol distribution
                                         XBETAHEN_MULTI   ! 
REAL, DIMENSION(:,:,:)  ,SAVE, ALLOCATABLE :: XCONC_CCN_TOT    !* Total aerosol number concentration
REAL, DIMENSION(:),      SAVE, ALLOCATABLE :: XLIMIT_FACTOR    !* compute CHEN ????????????
!
! 2.3 Water particles characteristics
!
REAL,SAVE     :: XALPHAR,XNUR,       & ! Raindrop       distribution parameters
                 XALPHAC,XNUC          ! Cloud droplet  distribution parameters
!
! 2.4 CCN activation
!
CHARACTER(LEN=3),SAVE :: HPARAM_CCN = 'CPB'   ! Parameterization of the CCN activation
CHARACTER(LEN=3),SAVE :: HINI_CCN             ! Initialization type of CCN activation
CHARACTER(LEN=1),SAVE :: HTYPE_CCN            ! 'M' or 'C' standard type of CCN
REAL,SAVE             :: XFSOLUB_CCN,       & ! Fractionnal solubility of the CCN
                         XACTEMP_CCN,       & ! Expected temperature of CCN activation
                         XAERDIFF, XAERHEIGHT ! For the vertical gradient of aerosol distribution
!
!-------------------------------------------------------------------------------
!
!
!*       3.   BELOW CLOUD SCAVENGING
!             ----------------------
!
LOGICAL, SAVE :: LSCAV           ! TRUE for aerosol scavenging by precipitations 
LOGICAL, SAVE :: LAERO_MASS      ! TRUE to compute the total aerosol mass scavenging rate 
!
INTEGER       :: NDIAMR = 20     ! Max Number of droplet for quadrature method  
INTEGER       :: NDIAMP = 20     ! Max Number of aerosol particle for quadrature method  
!
REAL, SAVE    :: XT0SCAV = 293.15  ! [K]
REAL, SAVE    :: XTREF = 273.15    ! [K]
REAL, SAVE    :: XNDO = 8.*1.0E6   ! [/m**4]
!
!-------------------------------------------------------------------------------
!
!
!*       4.   ATMOSPHERIC & OTHER PARAMETERS
!             ------------------------------
!
REAL, SAVE    :: XMUA0     = 1.711E-05  ![Pa.s] Air Viscosity at T=273.15K
REAL, SAVE    :: XT_SUTH_A = 110.4      ![K] Sutherland Temperature for Air
REAL, SAVE    :: XMFPA0    = 6.6E-08    ![m] Mean Free Path of Air under standard conditions
!
REAL, SAVE    :: XVISCW = 1.0E-3        ![Pa.s] water viscosity at 20°C
REAL, SAVE    :: XRHO00 = 1.292         !rho on the floor    [Kg/m**3]
!
REAL,SAVE :: XCEXVT                    ! air density fall speed correction
!
REAL,DIMENSION(:),SAVE,ALLOCATABLE :: XRTMIN ! Min values of the mixing ratios
REAL,DIMENSION(:),SAVE,ALLOCATABLE :: XCTMIN ! Min values of the drop concentrations
!
REAL,DIMENSION(:,:,:,:),SAVE,ALLOCATABLE :: LIMA_BOUND ! 
!
END MODULE MODD_PARAM_LIMA
