!######################################
 MODULE MODI_INIT_AEROSOL_CONCENTRATION
!######################################
!
INTERFACE INIT_AEROSOL_CONCENTRATION
   SUBROUTINE INIT_AEROSOL_CONCENTRATION(PRHODREF, PSVT, PSVM, PZZ)
!
     REAL, DIMENSION(:,:,:),   INTENT(IN)    :: PRHODREF !Air Density [kg/m**3]
     REAL, DIMENSION(:,:,:,:), INTENT(INOUT) :: PSVT     !Particles Concentration [/m**3]
     REAL, DIMENSION(:,:,:,:), INTENT(INOUT) :: PSVM
     REAL, DIMENSION(:,:,:),   INTENT(IN)    :: PZZ      ! Height (z)
!
   END SUBROUTINE INIT_AEROSOL_CONCENTRATION
END INTERFACE INIT_AEROSOL_CONCENTRATION
!
END MODULE MODI_INIT_AEROSOL_CONCENTRATION
!
!     ################################################################
      SUBROUTINE INIT_AEROSOL_CONCENTRATION(PRHODREF, PSVT, PSVM, PZZ)
!     ################################################################

!!

!!    PURPOSE
!!    -------
!!    Define the aerosol distributions
!! 
!!
!!      MODD_BLANK :
!!      CDUMMY2 : CCN ou IFN pour le panache
!!      NDUMMY1 : hauteur base du panache
!!      NDUMMY2 : hauteur sommet du panache
!!      XDUMMY8 : Concentration du panache (N/cm3 pour des CCN, N/L pour des IFN)
!!
!!
!!    AUTHOR
!!    ------
!!      J.-P. Pinty      * Laboratoire d'Aerologie*
!!      S.    Berthet    * Laboratoire d'Aerologie*
!!      B.    Vié        * Laboratoire d'Aerologie*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original             ??/??/13 
!!
!!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_NSV
USE MODD_PARAM_n,    ONLY : CCLOUD
USE MODD_PARAM_LIMA, ONLY : LWARM, LACTI, NMOD_CCN, LSCAV, LAERO_MASS,      &
                            CCN_CONC, CCCN1, CCCN2, CCCN3, CCCN4, CCN_HOM,  &
                            LCOLD, LNUCL, NMOD_IFN, LMEYERS,                &
                            IFN_CONC, CIFN1, CIFN2, IFN_HOM, LBOUND, LIMA_BOUND
USE MODD_PARAMETERS, ONLY : JPVEXT
USE MODD_BLANK,      ONLY : CDUMMY2, NDUMMY1, NDUMMY2, XDUMMY8
USE MODD_GET_n, ONLY : CGETCLOUD
!
IMPLICIT NONE
!
REAL, DIMENSION(:,:,:),   INTENT(IN)    :: PRHODREF !Air Density [kg/m**3]
REAL, DIMENSION(:,:,:,:), INTENT(INOUT) :: PSVT     !Particles Concentration    
                                                    ![particles/kg of dry air]
REAL, DIMENSION(:,:,:,:), INTENT(INOUT) :: PSVM     !Particles Concentration    
                                                    ![particles/kg of dry air]
REAL, DIMENSION(:,:,:),   INTENT(IN)    :: PZZ      ! Height (z)
!
! Local variables
INTEGER                                 :: JMOD_IFN
INTEGER                                 :: JSV, JINIT
INTEGER                                 :: IKB, IKE
!
REAL, DIMENSION(SIZE(PSVT,1),SIZE(PSVT,2),SIZE(PSVT,3),SIZE(PSVT,4)) :: TMPT, TMPM
!
!-------------------------------------------------------------------------------
!
!
!*initialization of N_FREE_CCN/N_ACTIVATED_CCN et N_FREE_IN/N_ACTIVATED_IN
!
! Sauvegarde des champs lus
TMPM(:,:,:,:)=PSVM(:,:,:,:)
TMPT(:,:,:,:)=PSVT(:,:,:,:)
!
IF ( LWARM .AND. LACTI ) THEN
!
   DO JSV = NSV_LIMA_CCN_FREE, NSV_LIMA_CCN_ACTI+NMOD_CCN-1         
      PSVT(:,:,:,JSV) = 0.0
      PSVM(:,:,:,JSV) = 0.0
   ENDDO
   IKB = 1+JPVEXT
   IKE = SIZE(PSVT,3)-JPVEXT
!
!
! Initialisation des concentrations en CCN
!
   IF ( .NOT. ALLOCATED(CCN_CONC)) THEN
      ALLOCATE(CCN_CONC(4))
   END IF
   CCN_CONC(:)=0.
   CCN_CONC(1)=CCCN1
   CCN_CONC(2)=CCCN2
   CCN_CONC(3)=CCCN3
   IF (NMOD_CCN .GE. 4 ) CCN_CONC(4)=CCCN4
!
   IF (CCN_HOM) THEN
   ! concentration homogène (en nombre par m3) sur la verticale
      DO JSV = 1, NMOD_CCN
         PSVT(:,:,IKB:IKE,NSV_LIMA_CCN_FREE+JSV-1) = &
              CCN_CONC(JSV)*1.0E6 / PRHODREF(:,:,IKB:IKE)
      END DO
   ELSE
   ! concentration décroissante selon z
      DO JSV = 1, NMOD_CCN
         WHERE (PZZ(:,:,:) .LE. 1000.) 
            PSVT(:,:,:,NSV_LIMA_CCN_FREE+JSV-1) = CCN_CONC(JSV)*1.0E6 / PRHODREF(:,:,:)
         ELSEWHERE (PZZ(:,:,:) .LE. 10000.)
            PSVT(:,:,:,NSV_LIMA_CCN_FREE+JSV-1) = CCN_CONC(JSV)*1.0E6 &
                 / PRHODREF(:,:,:) * EXP(-LOG(CCN_CONC(JSV)/0.01)*PZZ(:,:,:)/10000.)
         ELSEWHERE
            PSVT(:,:,:,NSV_LIMA_CCN_FREE+JSV-1) = 0.01*1.0E6 / PRHODREF(:,:,:)
         ENDWHERE
      END DO
   ENDIF
!
END IF ! LWARM AND LACTI
!
!
! Initialisation des concentrations en IFN
!
!
IF ( LCOLD .AND. LNUCL .AND. (.NOT. LMEYERS) ) THEN
!
   DO JSV = NSV_LIMA_IFN_FREE, NSV_LIMA_IFN_NUCL+NMOD_IFN-1         
      PSVT(:,:,:,JSV) = 0.0
      PSVM(:,:,:,JSV) = 0.0
   ENDDO
   IKB = 1+JPVEXT
   IKE = SIZE(PSVT,3)-JPVEXT
!
!
   IF ( .NOT. ALLOCATED(IFN_CONC)) THEN
      ALLOCATE(IFN_CONC(NMOD_IFN))
   END IF
   IFN_CONC(:)=0.
   IFN_CONC(1)=CIFN1
   IF (NMOD_IFN .GE. 2 ) IFN_CONC(2)=CIFN2
   !
   IF (IFN_HOM) THEN
      ! concentration homogène (en nombre par m3) sur la verticale
      DO JSV = 1, NMOD_IFN
         PSVT(:,:,IKB:IKE,NSV_LIMA_IFN_FREE+JSV-1) = &
              IFN_CONC(JSV)*1.0E3 / PRHODREF(:,:,IKB:IKE)
      END DO
   ELSE
      ! concentration décroissante selon z
      DO JSV = 1, NMOD_IFN
         WHERE (PZZ(:,:,:) .LE. 1000.) 
            PSVT(:,:,:,NSV_LIMA_IFN_FREE+JSV-1) = IFN_CONC(JSV)*1.0E3 / PRHODREF(:,:,:)
         ELSEWHERE (PZZ(:,:,:) .LE. 10000.)
            PSVT(:,:,:,NSV_LIMA_IFN_FREE+JSV-1) = IFN_CONC(JSV)*1.0E3 &
                 / PRHODREF(:,:,:) * EXP(-LOG(IFN_CONC(JSV)/1.)*PZZ(:,:,:)/10000.)
         ELSEWHERE
            PSVT(:,:,:,NSV_LIMA_IFN_FREE+JSV-1) = 1*1.0E3 / PRHODREF(:,:,:)
         ENDWHERE
      END DO
   ENDIF
END IF ! LCOLD AND LNUCL AND NOT LMEYERS
!
!
! Cas d'un panache de "pollution", concentration homogène dans le panache :
!
SELECT CASE (CDUMMY2)
CASE ('CCN')
   PSVT(:,:,:,NSV_LIMA_CCN_FREE+NMOD_CCN-1)=0.
   WHERE ( (PZZ(:,:,:) .GE. NDUMMY1) .AND. (PZZ(:,:,:) .LE. NDUMMY2) ) &
        PSVT(:,:,:,NSV_LIMA_CCN_FREE+NMOD_CCN-1)=XDUMMY8*1.0E6 / PRHODREF(:,:,:)
!
CASE ('IFN')
   PSVT(:,:,:,NSV_LIMA_IFN_FREE+NMOD_IFN-1)=0.
   WHERE ( (PZZ(:,:,:) .GE. NDUMMY1) .AND. (PZZ(:,:,:) .LE. NDUMMY2) ) &
        PSVT(:,:,:,NSV_LIMA_IFN_FREE+NMOD_IFN-1)=XDUMMY8*1.0E3 / PRHODREF(:,:,:)
!
END SELECT
!
!
IF ( LWARM .AND. LACTI ) THEN
   DO JSV = NSV_LIMA_CCN_FREE, NSV_LIMA_CCN_ACTI+NMOD_CCN-1
      PSVM(:,:,:,JSV) = PSVT(:,:,:,JSV)
   ENDDO
END IF
IF ( LCOLD .AND. LNUCL .AND. (.NOT. LMEYERS) ) THEN
   DO JSV = NSV_LIMA_IFN_FREE, NSV_LIMA_IFN_NUCL+NMOD_IFN-1
      PSVM(:,:,:,JSV) = PSVT(:,:,:,JSV)
   ENDDO
END IF
! 
!
! Si champs lus (restart), on garde les valeurs du fichier précédent
!
IF (CGETCLOUD == 'READ') THEN 
   PSVT(:,:,:,:)=TMPT(:,:,:,:)
   PSVM(:,:,:,:)=TMPM(:,:,:,:)
END IF
!
! Boundaries
!
IF ( LBOUND ) THEN
   IF ( .NOT. ALLOCATED(LIMA_BOUND)) THEN
      ALLOCATE( LIMA_BOUND(SIZE(PSVT,1),SIZE(PSVT,2),SIZE(PSVT,3),SIZE(PSVT,4)) )
   END IF
   LIMA_BOUND(:,:,:,:)=PSVT(:,:,:,:)
END IF
! 
END SUBROUTINE INIT_AEROSOL_CONCENTRATION
