!-----------------------------------------------------------------
!--------------- special set of characters for RCS information
!-----------------------------------------------------------------
! $Source: /home/cvsroot/MNH-VX-Y-Z/src/MNH/initial_guess.f90,v $ $Revision: 1.2.2.2.2.2.2.2 $ $Date: 2011/09/16 07:53:23 $
!-----------------------------------------------------------------
!-----------------------------------------------------------------
!-----------------------------------------------------------------
!     #########################
      MODULE MODI_INITIAL_GUESS
!     #########################
!
INTERFACE
!
      SUBROUTINE INITIAL_GUESS ( KRR, KSV, KTCOUNT,PRHODJ, PRHODREF, KMI,       &
                         PUM, PVM, PWM, PTHM, PRM, PTKEM, PSVM,                 &
                         PTSTEP, PTSTEP_MET, PTSTEP_SV,                         &
                         PRUS, PRVS, PRWS, PRTHS, PRRS, PRTKES, PRSVS,          &
                         HMET_ADV_SCHEME,HSV_ADV_SCHEME, HUVW_ADV_SCHEME,       &
                         PUT, PVT, PWT, PTHT, PRT, PTKET, PSVT )
!
INTEGER,                  INTENT(IN)  :: KRR     ! Number of moist variables
INTEGER,                  INTENT(IN)  :: KSV     ! Number of Scalar Variables
INTEGER,                  INTENT(IN)  :: KTCOUNT ! Temporal loop COUNTer
                                                 ! (=1 at the segment beginning)
INTEGER,                  INTENT(IN)  :: KMI     ! Model index
!
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PRHODJ         ! (Rho) dry * Jacobian
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PRHODREF       !
!
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PUM, PVM, PWM  ! variables at t-dt
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PTHM, PTKEM
REAL, DIMENSION(:,:,:,:), INTENT(IN)  :: PRM, PSVM      
!
REAL,                     INTENT(IN)  :: PTSTEP !  Double timestep except for
                                                !  cold start (single)
REAL,                     INTENT(IN)  :: PTSTEP_MET !  Effective time step for
                                                ! meteorological scalar variables 
                                                ! (depending on advection scheme)
REAL,                     INTENT(IN)  :: PTSTEP_SV !  Effective time step for
                                                ! tracer scalar variables 
                                                ! (depending on advection scheme)
!
REAL, DIMENSION(:,:,:),   INTENT(OUT) :: PRUS, PRVS, PRWS         ! Source
REAL, DIMENSION(:,:,:),   INTENT(OUT) :: PRTHS, PRTKES
REAL, DIMENSION(:,:,:,:), INTENT(OUT) :: PRRS, PRSVS              !  terms
!
! scalar meteorological advection scheme used
CHARACTER(LEN=6),         INTENT(IN)  :: HMET_ADV_SCHEME 
! scalar tracer advection scheme used
CHARACTER(LEN=6),         INTENT(IN)  :: HSV_ADV_SCHEME 
! advection scheme for momentum
CHARACTER(LEN=6),         INTENT(IN)  :: HUVW_ADV_SCHEME 
!
! variables at time t (needed for PPM schemes)
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PUT, PVT, PWT
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PTHT, PTKET
REAL, DIMENSION(:,:,:,:), INTENT(IN)  :: PRT, PSVT
!
END SUBROUTINE INITIAL_GUESS
!
END INTERFACE
!
END MODULE MODI_INITIAL_GUESS 
!
!
!
!     #########################################################################
      SUBROUTINE INITIAL_GUESS ( KRR, KSV, KTCOUNT,PRHODJ,  PRHODREF, KMI,      &
                         PUM, PVM, PWM, PTHM, PRM, PTKEM, PSVM,                 &
                         PTSTEP, PTSTEP_MET, PTSTEP_SV,                         &
                         PRUS, PRVS, PRWS, PRTHS, PRRS, PRTKES, PRSVS,          &
                         HMET_ADV_SCHEME,HSV_ADV_SCHEME, HUVW_ADV_SCHEME,       &
                         PUT, PVT, PWT, PTHT, PRT, PTKET, PSVT )
!     #########################################################################
!
!!****  *INITIAL_GUESS * - routine to initialize the source terms
!!
!!    PURPOSE
!!    -------
!!      The purpose of this routine is to integrate the prognostic variables
!!    at t-dt into their respective source terms.
!!
!!**  METHOD
!!    ------
!!      The fields at t-dt divided by 2*TSTEP (1*TSTEP for the first time step
!!    in case of START configuration) are initializing the source term arrays.
!!      The different sources terms are initialized for the budget computations.
!!     
!!
!!    EXTERNAL
!!    --------
!!      MXM,MYM,MZM : Mean Shuman operators in the x,y,z directions
!!      BUDGET      : Stores the different budget components
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!      Module MODD_CONF   : contains configuration variable 
!!           CCONF :  Configuration of models
!!    MODULE MODD_BUDGET:
!!         NBUMOD       : model in which budget is calculated
!!         CBUTYPE      : type of desired budget
!!                          'CART' for cartesian box configuration
!!                          'MASK' for budget zone defined by a mask 
!!                          'NONE'  ' for no budget
!!         LBU_BEG      : logical for budget begnning
!!                       .TRUE. = budget begining
!!                       .FALSE. = no budget begining
!!         NBUPROCCTR   : process counter used for each budget variable
!!         Switches for budgets activations:
!!         
!!         LBU_RU       : logical for budget of RU (wind component along x)
!!                        .TRUE. = budget of RU         
!!                        .FALSE. = no budget of RU 
!!         LBU_RV       : logical for budget of RV (wind component along y)
!!                        .TRUE. = budget of RV         
!!                        .FALSE. = no budget of RV 
!!         LBU_RW        : logical for budget of RW (wind component along z)
!!                        .TRUE. = budget of RW         
!!                        .FALSE. = no budget of RW 
!!         LBU_RTH      : logical for budget of RTH (potential temperature)
!!                        .TRUE. = budget of RTH        
!!                        .FALSE. = no budget of RTH
!!         LBU_RTKE     : logical for budget of RTKE (turbulent kinetic energy)
!!                        .TRUE. = budget of RTKE       
!!                        .FALSE. = no budget of RTKE
!!         LBU_RRV      : logical for budget of RRV (water vapor)
!!                        .TRUE. = budget of RRV 
!!                        .FALSE. = no budget of RRV 
!!         LBU_RRC      : logical for budget of RRC (cloud water)
!!                        .TRUE. = budget of RRC 
!!                        .FALSE. = no budget of RRC 
!!         LBU_RRR      : logical for budget of RRR (rain water)
!!                        .TRUE. = budget of RRR 
!!                        .FALSE. = no budget of RRR 
!!         LBU_RRI      : logical for budget of RRI (ice)
!!                        .TRUE. = budget of RRI 
!!                        .FALSE. = no budget of RRI 
!!         LBU_RRS      : logical for budget of RRS (snow)
!!                        .TRUE. = budget of RRS 
!!                        .FALSE. = no budget of RRS 
!!         LBU_RRG      : logical for budget of RRG (graupel)
!!                        .TRUE. = budget of RRG 
!!                        .FALSE. = no budget of RRG 
!!         LBU_RRH      : logical for budget of RRH (hail)
!!                        .TRUE. = budget of RRH 
!!                        .FALSE. = no budget of RRH 
!!         LBU_RSV      : logical for budget of RSVx (scalar variable)
!!                        .TRUE. = budget of RSVx 
!!                        .FALSE. = no budget of RSVx
!!
!!    REFERENCE
!!    ---------
!!      Book2 of documentation ( routine INITIAL_GUESS )
!!
!!    AUTHOR
!!    ------
!!  	J.-P. Pinty      * Laboratoire d'Aerologie*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    21/07/94 
!!                  20/03/95 (J.Stein) : remove R from the historical variables
!!                  01/04/95 (Ph. Hereil J. Nicolau) add the budget computation
!!                  16/10/95 (J. Stein)     change the budget calls 
!!                  19/12/96 (J.-P. Pinty)  update the budget calls 
!!                  06/11/02 (V. Masson)    update the budget calls 
!!                  20/05/06                Remove KEPS
!!                  10/09    (C.Lac)        FIT for variables advected with PPM
!!
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_CONF 
USE MODD_GRID_n
USE MODD_BUDGET
USE MODD_NSV, ONLY : NSV_LIMA_BEG, NSV_LIMA_END
!
USE MODI_SHUMAN
USE MODI_BUDGET
!
IMPLICIT NONE
!
!*       0.1   Declarations of dummy arguments :
!
INTEGER,                  INTENT(IN)  :: KRR     ! Number of moist variables
INTEGER,                  INTENT(IN)  :: KSV     ! Number of Scalar Variables
INTEGER,                  INTENT(IN)  :: KTCOUNT ! Temporal loop COUNTer
                                                 ! (=1 at the segment beginning)
INTEGER,                  INTENT(IN)  :: KMI     ! Model index
!
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PRHODJ         ! (Rho) dry * Jacobian
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PRHODREF       ! (Rho) dry * Jacobian
!
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PUM, PVM, PWM  ! Variables at t-dt 
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PTHM, PTKEM
REAL, DIMENSION(:,:,:,:), INTENT(IN)  :: PRM, PSVM      
!
REAL,                     INTENT(IN)  :: PTSTEP !  Double timestep except for
                                                !  cold start (single)
REAL,                     INTENT(IN)  :: PTSTEP_MET !  Effective time step for
                                                ! meteorological scalar variables 
                                                ! (depending on advection scheme)
REAL,                     INTENT(IN)  :: PTSTEP_SV !  Effective time step for
                                                ! tracer scalar variables 
                                                ! (depending on advection scheme)
!
REAL, DIMENSION(:,:,:),   INTENT(OUT) :: PRUS, PRVS, PRWS         ! Source
REAL, DIMENSION(:,:,:),   INTENT(OUT) :: PRTHS, PRTKES
REAL, DIMENSION(:,:,:,:), INTENT(OUT) :: PRRS, PRSVS  !  terms
!
! scalar meteorological advection scheme used
CHARACTER(LEN=6),         INTENT(IN)  :: HMET_ADV_SCHEME 
! scalar tracer advection scheme used
CHARACTER(LEN=6),         INTENT(IN)  :: HSV_ADV_SCHEME 
! advection scheme for momentum
CHARACTER(LEN=6),         INTENT(IN)  :: HUVW_ADV_SCHEME 
!
! variables at time t (needed for PPM schemes)
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PUT, PVT, PWT
REAL, DIMENSION(:,:,:),   INTENT(IN)  :: PTHT, PTKET
REAL, DIMENSION(:,:,:,:), INTENT(IN)  :: PRT, PSVT
!
!*       0.2   declarations of local variables
!
INTEGER                               :: JRR, JSV
INTEGER                               :: IKU
REAL                                  :: ZINVTSTEP,ZINVTSTEP_MET,ZINVTSTEP_SV
!
!-------------------------------------------------------------------------------
!
IKU=SIZE(XZHAT)
!*       1.     COMPUTES THE INVERSE OF THE APPLICABLE TIMESTEP
!   	        -----------------------------------------------
!
ZINVTSTEP = 1./PTSTEP                          
ZINVTSTEP_MET = 1./PTSTEP_MET         
ZINVTSTEP_SV = 1./PTSTEP_SV          
!
!
!*       2.     COMPUTES THE FIRST SOURCE TERMS
!   	        -------------------------------
! 
! *** momentum
PRUS(:,:,:)   = PUM(:,:,:)  * ZINVTSTEP * MXM (PRHODJ)
PRVS(:,:,:)   = PVM(:,:,:)  * ZINVTSTEP * MYM (PRHODJ)
PRWS(:,:,:)   = PWM(:,:,:)  * ZINVTSTEP * MZM (1,IKU,1,PRHODJ)
!
! *** meteorological variables
IF (HMET_ADV_SCHEME(1:3) == 'PPM') THEN
!
   PRTHS(:,:,:) = PTHT(:,:,:) * ZINVTSTEP_MET * PRHODJ(:,:,:)
!
   IF (SIZE(PTKEM,1) /= 0) THEN 
      PRTKES(:,:,:) = PTKET(:,:,:) * ZINVTSTEP_MET * PRHODJ(:,:,:)
   END IF
!
! Case with KRR moist variables 
   DO JRR=1,KRR
      PRRS(:,:,:,JRR) = PRT(:,:,:,JRR) * ZINVTSTEP_MET * PRHODJ(:,:,:) 
   END DO
!
ELSE ! other advection schemes
!
  PRTHS(:,:,:) = PTHM(:,:,:) * ZINVTSTEP_MET * PRHODJ(:,:,:)
!
  IF (SIZE(PTKEM,1) /= 0) THEN 
    PRTKES(:,:,:) = PTKEM(:,:,:) * ZINVTSTEP_MET * PRHODJ(:,:,:)
  END IF
!
! Case with KRR moist variables 
  DO JRR=1,KRR
    PRRS(:,:,:,JRR) = PRM(:,:,:,JRR) * ZINVTSTEP_MET * PRHODJ(:,:,:) 
  END DO
!
END IF
!
! *** passive tracers
IF ( (HSV_ADV_SCHEME(1:3) == 'PPM') .OR. (HSV_ADV_SCHEME == '4TH_RK')) THEN
!
! Case with KSV Scalar Variables
   DO JSV=1,KSV
      PRSVS(:,:,:,JSV) = PSVT(:,:,:,JSV) * ZINVTSTEP_SV * PRHODJ(:,:,:)
   END DO
!
ELSE ! other advection schemes
!
   DO JSV=1,KSV
     PRSVS(:,:,:,JSV) = PSVM(:,:,:,JSV) * ZINVTSTEP_SV * PRHODJ(:,:,:)
   END DO
!
END IF
!
!
IF (LBU_ENABLE) THEN
  IF (LBU_BEG) THEN
    NBUPROCCTR(:)=1
    NBUCTR_ACTV(:)=1
!
    IF (LBUDGET_U)   CALL BUDGET (PRUS,1,'INIF_BU_RU')
    IF (LBUDGET_V)   CALL BUDGET (PRVS,2,'INIF_BU_RV')
    IF (LBUDGET_W)   CALL BUDGET (PRWS,3,'INIF_BU_RW')
    IF (LBUDGET_TH)  CALL BUDGET (PRTHS,4,'INIF_BU_RTH')
    IF (LBUDGET_TKE) CALL BUDGET (PRTKES,5,'INIF_BU_RTKE')
    IF (LBUDGET_RV)  CALL BUDGET (PRRS(:,:,:,1),6,'INIF_BU_RRV')
    IF (LBUDGET_RC)  CALL BUDGET (PRRS(:,:,:,2),7,'INIF_BU_RRC')
    IF (LBUDGET_RR)  CALL BUDGET (PRRS(:,:,:,3),8,'INIF_BU_RRR')
    IF (LBUDGET_RI)  CALL BUDGET (PRRS(:,:,:,4),9,'INIF_BU_RRI')
    IF (LBUDGET_RS)  CALL BUDGET (PRRS(:,:,:,5),10,'INIF_BU_RRS')
    IF (LBUDGET_RG)  CALL BUDGET (PRRS(:,:,:,6),11,'INIF_BU_RRG')
    IF (LBUDGET_RH)  CALL BUDGET (PRRS(:,:,:,7),12,'INIF_BU_RRH')
    IF (LBUDGET_SV) THEN
       DO JSV=1,KSV
          IF ( JSV.GE.NSV_LIMA_BEG .AND. JSV.LE.NSV_LIMA_END ) THEN
             CALL BUDGET (PRSVS(:,:,:,JSV)*PRHODREF,JSV+12,'INIF_BU_RSV')
          ELSE
             CALL BUDGET (PRSVS(:,:,:,JSV),JSV+12,'INIF_BU_RSV')
          END IF
       END DO
    END IF
!
    NBUPROCCTR(:)=2
    NBUCTR_ACTV(:)=2
!
    IF (LBUDGET_U)   CALL BUDGET (PRUS,1,'ENDF_BU_RU')
    IF (LBUDGET_V)   CALL BUDGET (PRVS,2,'ENDF_BU_RV')
    IF (LBUDGET_W)   CALL BUDGET (PRWS,3,'ENDF_BU_RW')
    IF (LBUDGET_TH)  CALL BUDGET (PRTHS,4,'ENDF_BU_RTH')
    IF (LBUDGET_TKE) CALL BUDGET (PRTKES,5,'ENDF_BU_RTKE')
    IF (LBUDGET_RV)  CALL BUDGET (PRRS(:,:,:,1),6,'ENDF_BU_RRV')
    IF (LBUDGET_RC)  CALL BUDGET (PRRS(:,:,:,2),7,'ENDF_BU_RRC')
    IF (LBUDGET_RR)  CALL BUDGET (PRRS(:,:,:,3),8,'ENDF_BU_RRR')
    IF (LBUDGET_RI)  CALL BUDGET (PRRS(:,:,:,4),9,'ENDF_BU_RRI')
    IF (LBUDGET_RS)  CALL BUDGET (PRRS(:,:,:,5),10,'ENDF_BU_RRS')
    IF (LBUDGET_RG)  CALL BUDGET (PRRS(:,:,:,6),11,'ENDF_BU_RRG')
    IF (LBUDGET_RH)  CALL BUDGET (PRRS(:,:,:,7),12,'ENDF_BU_RRH')
    IF (LBUDGET_SV) THEN
       DO JSV=1,KSV
          IF ( JSV.GE.NSV_LIMA_BEG .AND. JSV.LE.NSV_LIMA_END ) THEN
             CALL BUDGET (PRSVS(:,:,:,JSV)*PRHODREF,JSV+12,'ENDF_BU_RSV')
          ELSE
             CALL BUDGET (PRSVS(:,:,:,JSV),JSV+12,'ENDF_BU_RSV')
          END IF
       END DO
    END IF
!
    LBU_BEG=.FALSE.
  END IF    
!
  NBUPROCCTR(:)=4
  NBUCTR_ACTV(:)=4
!
!  stores the Asselin source term
!
  IF (LBUDGET_U)   CALL BUDGET (PRUS,1,'ASSE_BU_RU')
  IF (LBUDGET_V)   CALL BUDGET (PRVS,2,'ASSE_BU_RV')
  IF (LBUDGET_W)   CALL BUDGET (PRWS,3,'ASSE_BU_RW')
  IF (LBUDGET_TH)  CALL BUDGET (PRTHS,4,'ASSE_BU_RTH')
  IF (LBUDGET_TKE) CALL BUDGET (PRTKES,5,'ASSE_BU_RTKE')
  IF (LBUDGET_RV)  CALL BUDGET (PRRS(:,:,:,1),6,'ASSE_BU_RRV')
  IF (LBUDGET_RC)  CALL BUDGET (PRRS(:,:,:,2),7,'ASSE_BU_RRC')
  IF (LBUDGET_RR)  CALL BUDGET (PRRS(:,:,:,3),8,'ASSE_BU_RRR')
  IF (LBUDGET_RI)  CALL BUDGET (PRRS(:,:,:,4),9,'ASSE_BU_RRI')
  IF (LBUDGET_RS)  CALL BUDGET (PRRS(:,:,:,5),10,'ASSE_BU_RRS')
  IF (LBUDGET_RG)  CALL BUDGET (PRRS(:,:,:,6),11,'ASSE_BU_RRG')
  IF (LBUDGET_RH)  CALL BUDGET (PRRS(:,:,:,7),12,'ASSE_BU_RRH')
  DO JSV=1,KSV
    IF (LBUDGET_SV)  CALL BUDGET (PRSVS(:,:,:,JSV),JSV+12,'ASSE_BU_RSV')
  END DO
END IF
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE INITIAL_GUESS
