      real, allocatable :: alon(:,:),alat(:,:),dx(:,:),dy(:,:)
      real, allocatable :: h(:,:),et(:,:),ua(:,:),va(:,:)
      real, allocatable :: z(:),zz(:)
      real, allocatable :: u(:,:,:),v(:,:,:),t(:,:,:),s(:,:,:)
      real, allocatable :: w(:,:,:)
      character outname*16,monc*2,dayc*2,yrc*2
      character dir*44,outnamef*71


      outname(1:4)='OUTP'
      outname(11:16) = '.18UTC'

      open(10,file='filedate')
         read(10,'(3(1x,a2))') monc,dayc,yrc
      close(10)
      outname(5:6)=dayc
      outname(7:8)=monc
      outname(9:10)=yrc

      dir='/data/ocean2/AEG30_OPERATIONAL_VERSION2/AEG/'
      outnamef=dir//outname(5:10)//'_OCE/'//outname

      open(30,file=outnamef,form='unformatted',status='old')
      DO KREPEA=1,15
      READ(30)
      END DO
      READ(30) IM,JM,KB


      allocate(alon(im,jm))
      allocate(alat(im,jm))
      allocate(dx(im,jm))
      allocate(dy(im,jm))
      allocate(h(im,jm))
      allocate(z(kb))
      allocate(zz(kb))
      allocate(et(im,jm))
      allocate(ua(im,jm))
      allocate(va(im,jm))
      allocate(u(im,jm,kb))
      allocate(v(im,jm,kb))
      allocate(t(im,jm,kb))
      allocate(s(im,jm,kb))
      allocate(w(im,jm,kb))

      READ(30) H,ALAT,ALON,DX,DY
      READ(30) Z,ZZ
      READ(30) TIME,ET,UA,VA,U,V,T,S,W

      close(30)

      do i = 1,im
       do j = 1,jm
       if (h(i,j).eq.1.) then
        u(i,j,1) = 1.e5
        v(i,j,1) = 1.e5
       end if
       end do
      end do

      DUCLO = ALON(2,1)-ALON(1,1)
      DUCLA = ALAT(1,2) - ALAT(1,1)
      UCLO = ALAT(1,1)
      UCLH = ALAT(1,JM)
      UCLW = ALON(1,1)
      UCLE = ALON(IM,1)

      IU02= 22
      open(iu02,file='../data_nest2/currcat.dat')
      WRITE (IU02, '(6F10.5,1x,I3,1x,I3)')
     1    UCLO, UCLH, UCLW, UCLE, DUCLO, DUCLA,JM, IM

      DO 2001 J=1,JM   
         WRITE(IU02,'(8E9.3)') (U(I,J,1),I=1,IM)
 2001 CONTINUE

      DO 2002 J=1,JM
         WRITE(IU02,'(8E9.3)') (V(I,J,1),I=1,IM)
 2002 CONTINUE

      close(IU02)


       STOP
       END
