c Univ. of Athens - Ocean Group - G.Korres 07/03/2001
c ---- ihour_s : starting hour for WAM model integration (usually 18 UTC)
c                (it can vary between 00 --> 23 UTC)

c ---- integ_hours: total hours to integrate WAM model (usually 66 hours)
c        parameter (ihour_s = 3 , integ_hours = 6)
         parameter (ihour_s = 18, integ_hours = 66)

c ---- iday_start = 0 : start from present day
c ---- iday_start = -1 : start from previous day
         parameter (iday_start = -1)


c ---- arrange plots frequency (ex. ihours_plots =3 issues plots every 3h)
c ---- plots start at present day 00:00 + ihours_plots
         parameter (ihours_plots = 3)


c---------------------------------------------------------------------------
         character date_s*10 , date_e*10,sysdate*9
         character*80 rest_dir1 , rest_dir2 ,words,rest_dir3
         character date_s_plus1h*10,rest*10,windname*10
         character date_s_plus6h*10
         character  a1*1 , c2*2 , mon*3 ,st_name*14,b2*2,a2*2,d2*2
         character*13 file_mat(100),mathelp
         logical empty

c for 'Thu Mar  2  2000'   date_s='0003021800'

       call system("date '+ %m %d %y%n' > filedate")

         open(10, file='filedate')

         read(10,'(3(1x,i2))') mon_c,iday_c,iyr_c

c --- read global wht min-max values
         open(67,file='wave_minmax',status='old')
         read(67,'(2f8.1)') wmin,wmax
         read(67,'(2f8.1)') swmin,swmax
         close(67)
c ---- present date is iday_c mon_c iyr_c

c ---- the WAM model integration starts on previous date if iday_start=-1
         iyr_s = iyr_c
         mon_s = mon_c
         iday_s = iday_c
         call calend(iyr_s,mon_s,iday_s,iday_start)
         call writename(c2,mon_s)
         date_s(3:4) = c2
         rest(5:6) = c2
         st_name(9:10)=c2
         windname(4:5) = c2
         call writename(c2,iday_s)
         date_s(5:6) = c2
         rest(7:8) = c2
         st_name(11:12)=c2
         windname(1:2) = c2
         call writename(c2,iyr_s)
         date_s(1:2) = c2
         windname(9:10) = c2
         st_name(13:14)=c2
         windname(7:8) ='20'
         call writename(c2,ihour_s)
         date_s(7:8) = c2
         rest(9:10) = c2
         date_s(9:10) ='00'

         st_name(1:8)='stations'
         rest(1:4) = 'REST'
         windname(3:3)='/'
         windname(6:6)='/'


         date_s_plus1h = date_s
         call writename(c2,ihour_s+1)
         date_s_plus1h(7:8) = c2
         if (ihour_s+1.eq.24) then
         date_s_plus1h(7:8) = '00'
         iyr_ss = iyr_s
         mon_ss = mon_s
         iday_ss = iday_s
         call calend(iyr_ss,mon_ss,iday_ss,1)
         call writename(c2,mon_ss)
         date_s_plus1h(3:4) = c2
         call writename(c2,iday_ss)
         date_s_plus1h(5:6) = c2
         call writename(c2,iyr_ss)
         date_s_plus1h(1:2) = c2
         end if

c --- date_s_plus6h
         date_s_plus6h = date_s
         call writename(c2,ihour_s+ihours_plots)
         date_s_plus6h(7:8) = c2
         if (ihour_s+ihours_plots.eq.24) then
         date_s_plus6h(7:8) = '00'
         iyr_sss = iyr_s
         mon_sss = mon_s
         iday_sss = iday_s
         call calend(iyr_sss,mon_sss,iday_sss,1)
         call writename(c2,mon_sss)
         date_s_plus6h(3:4) = c2
         call writename(c2,iday_sss)
         date_s_plus6h(5:6) = c2
         call writename(c2,iyr_sss)
         date_s_plus6h(1:2) = c2
         end if



c ---- end date

c --- now arrange things for matlab graphs
         ihours_prev_day = 24 - ihour_s
         num_mat_files = (integ_hours-abs(iday_start)*ihours_prev_day)
     %    /ihours_plots 
         

         iyr_ss1 = iyr_s
         mon_ss1 = mon_s
         iday_ss1 = iday_s
         iplot_hour = ihour_s + ihours_plots
         iday_index = abs(iday_start)
         call calend(iyr_ss1,mon_ss1,iday_ss1,iday_index)
c        if (iday_start.ne.0) iplot_hour = 0
         if (iday_start.ne.0) iplot_hour = ihours_plots


         do k = 1,num_mat_files

         if (iplot_hour.ge.24) then
         iplot_hour = iplot_hour - 24
         iday_index = 1                 
         call calend(iyr_ss1,mon_ss1,iday_ss1,iday_index)
         end if
         call writename(c2,mon_ss1)
         call writename(b2,iday_ss1)
         call writename(a2,iyr_ss1)
         call writename(d2,iplot_hour)
         mathelp(1:1)='W'
         mathelp(10:13)='.DAT'
         
         mathelp(2:3)=a2
         mathelp(4:5)=c2
         mathelp(6:7)=b2
         mathelp(8:9)=d2  

         file_mat(k) = mathelp
         iplot_hour = iplot_hour + ihours_plots
         end do

       
         call write_mat(file_mat,num_mat_files,
     1             wmax,wmin,ihours_plots)
c        call write_mat_sw(file_mat,num_mat_files,swmax,swmin)
c -----------------------------------------------------

         int_days = integ_hours/24
         left_hours = integ_hours - int_days*24
         int_days1 = (left_hours+ihour_s)/24
         ihour_e = left_hours+ihour_s - int_days1*24
         int_days = int_days + int_days1

         iyr_e = iyr_s
         mon_e = mon_s
         iday_e = iday_s
         call calend(iyr_e,mon_e,iday_e,int_days)
         call writename(c2,mon_e)
         date_e(3:4) = c2
         call writename(c2,iday_e)
         date_e(5:6) = c2
         call writename(c2,iyr_e)
         date_e(1:2) = c2
         call writename(c2,ihour_e)
         date_e(7:8) = c2
         date_e(9:10) ='00'


c ----------------------------------------------


         
         stop
         end

         subroutine translate(aux,ii)
         character aux*1, c_lib(0:9)*1
         data c_lib/'','1','2','3','4','5',
     1  '6','7','8','9'/

         do k = 0,9
         if (aux.eq.c_lib(k)) then
         ii = k
         goto 10
         end if
         end do
 10      continue
         return
         end

         subroutine writename(date,ii)
         character date*2

         write(date,'(i2)') ii
         if (ii.lt.10) date(1:1) = '0'
         return
         end

         subroutine calend(iyr,mon,iday,ich)
      dimension m_days_o(12),m_days_lp(12),m_days(12)
      dimension month_sum(12)
      integer year_days,days
      data m_days_o/31,28,31,30,31,30,31,31,30,31,30,31/
      data m_days_lp/31,29,31,30,31,30,31,31,30,31,30,31/

      year_days = 365
      if (mod(iyr,4).eq.0) year_days = 366


      do k = 1,12
      m_days(k) = m_days_o(k)
      end do
      if (year_days.eq.366) then
       do k = 1,12
       m_days(k) = m_days_lp(k)
       end do
      end if


c ---- find julian date

       jul_day = 0
       do k = 1,mon-1
        jul_day = jul_day + m_days(k)
       end do
        jul_day = jul_day + iday


c ---- now change present day by ich

        jul_day = jul_day + ich 

c --- check if previous year
        if (jul_day.le.0) then
        iyr = iyr - 1
        if (iyr.eq.-1) iyr = 99
        year_days = 365
        if (mod(iyr,4).eq.0) year_days = 366
        jul_day = jul_day + year_days
        end if

c --- check if next year
        if (jul_day.gt.year_days) then
        iyr = iyr + 1
        jul_day = jul_day - year_days
        year_days = 365
        if (mod(iyr,4).eq.0) year_days = 366
        end if

c --- redefine month days
      do k = 1,12
      m_days(k) = m_days_o(k)
      end do
      if (year_days.eq.366) then
       do k = 1,12
       m_days(k) = m_days_lp(k)
       end do
      end if


c --- redefine month
        month_sum(1) = m_days(1)
        do k = 2,12
        month_sum(k) = m_days(k) + month_sum(k-1)
        end do

        mon = 1
        do k = 2,12
        if (month_sum(k-1).lt.jul_day.and.month_sum(k).ge.jul_day) then
        mon = k
        end if
        end do

        
c ---- redefine day

       days = 0
       do k = 1,mon-1
       days = days + m_days(k)
       end do
       iday = jul_day - days

       return
       end




         subroutine write_mat(file_mat,ind,wmax,wmin,incr)
         character*13 file_mat(100), mathelp
         character*80 words,word,conv,words1
         character matfiles10*10,matfiles11*11,a1*1,a2*2
         character twodigits(11)*2,peter*80
         data twodigits/'00','03','06','12','18','30','36','42','48',
     1    '54','60'/


         
         itwodig = 0  
         open(42,file='../../store/run_waves2_orig')
         open(43,file='run_waves2')
         read(42,'(a80)') word
         write(43,'(a80)') word

         do 100 k = 1,ind
         mathelp = file_mat(k)
         open(32,file='../../store/wavesmat1_orig',status='old')

         if (k.lt.10) then
         matfiles10(1:7)='waves2_'
         matfiles10(9:10)='.m'
         call writename1(a1,k)
         matfiles10(8:8)=a1
         open(33,file=matfiles10)

         word(1:7)='matmak<'
         word(8:17)=matfiles10
         word(18:25)='>out.mat'
         write(43,'(a25)') word


         else
         matfiles11(1:7)='waves2_'
         matfiles11(10:11)='.m'
         call writename(a2,k)
         matfiles11(8:9)=a2
         open(33,file=matfiles11)

         word(1:7)='matmak<'
         word(8:18)=matfiles11
         word(19:26)='>out.mat'
         write(43,'(a26)') word


         endif

	 conv(1:17)='  convert        '
	 conv(18:25)=mathelp(2:9)
	 conv(26:29)='.ps '
	 conv(30:30)=''
	 conv(31:38)=mathelp(2:9)
	 conv(39:42)='.jpg'
         write(43,'(a42)') conv

         write(peter,'(22x,i2)') itwodig
         if (itwodig.lt.10) peter(23:23)='0'
         peter(18:22)='wavem'
         peter(25:28)='.jpg'
         peter(1:4)=' cp '
         peter(5:12)=mathelp(2:9)
         peter(13:17)='.jpg '
         write(43,'(a28)') peter(1:28)
         itwodig = itwodig + incr




         read(32,'(a27)') words(1:27)
         words(12:24)=file_mat(k)
         write(33,'(a27)') words(1:27)
         do ll = 2,35
         read(32,'(a80)') words
         write(33,'(a80)') words
         end do
         read(32,'(a80)') words1
         write(words,'(16x,f4.1,1x,f4.1)') wmin,wmax 
         words(1:16) = words1(1:16)
         words(26:28)=']);'
         write(33,'(a80)') words
         do ll = 37,43
         read(32,'(a80)') words
         write(33,'(a80)') words
         end do

         read(32,'(a80)') words
         words(8:9)=mathelp(6:7)
         words(11:12)=mathelp(4:5)
         words(14:15)=mathelp(2:3)
         words(17:18)=mathelp(8:9)
         write(33,'(a80)') words

        
         read(32,'(a80)') words
         write(33,'(a80)') words
         read(32,'(a80)') words
         words(14:21)=mathelp(2:9)
         write(33,'(a80)') words


         close(32)
         close(33)

 100     continue

         do ll = 1,40
         read(42,fmt=400,end=200) word
         write(43,fmt=400) word
         end do


 200     continue

 400     format(a80)
         return
         end
         subroutine writename1(date,ii)
         character date*1

         write(date,'(i1)') ii
         return
         end


         subroutine write_mat_sw(file_mat,ind,wmax,wmin)
         character*13 file_mat(100), mathelp
         character*80 words,word,conv,words1
         character matfiles10*11,matfiles11*12,a1*1,a2*2

         
         open(42,file='../../store/run_waves22_orig')
         open(43,file='run_waves22')
         read(42,'(a80)') word
         write(43,'(a80)') word

         do 100 k = 1,ind
         mathelp = file_mat(k)
         open(32,file='../../store/wavesmat22_orig',status='old')

         if (k.lt.10) then
         matfiles10(1:8)='waves22_'
         matfiles10(10:11)='.m'
         call writename1(a1,k)
         matfiles10(9:9)=a1
         open(33,file=matfiles10)

         word(1:7)='matmak<'
         word(8:18)=matfiles10
         word(19:26)='>out.mat'
         write(43,'(a26)') word


         else
         matfiles11(1:8)='waves22_'
         matfiles11(11:12)='.m'
         call writename(a2,k)
         matfiles11(9:10)=a2
         open(33,file=matfiles11)

         word(1:7)='matmak<'
         word(8:19)=matfiles11
         word(20:27)='>out.mat'
         write(43,'(a27)') word


         endif

	 conv(1:17)='  convert        '
         conv(18:18)='s'
	 conv(19:26)=mathelp(2:9)
	 conv(27:30)='.ps '
	 conv(31:31)=''
	 conv(32:32)='s'
	 conv(33:40)=mathelp(2:9)
	 conv(41:44)='.jpg'
         write(43,'(a44)') conv



         read(32,'(a27)') words(1:27)
         words(12:24)=file_mat(k)
         write(33,'(a27)') words(1:27)
         do ll = 2,35
         read(32,'(a80)') words
         write(33,'(a80)') words
         end do
         read(32,'(a80)') words1
         write(words,'(16x,f4.1,1x,f4.1)') wmin,wmax
         words(1:16) = words1(1:16)
         words(26:28)=']);'
         write(33,'(a80)') words
         do ll = 37,43
         read(32,'(a80)') words
         write(33,'(a80)') words
         end do




         read(32,'(a80)') words
         words(8:9)=mathelp(6:7)
         words(11:12)=mathelp(4:5)
         words(14:15)=mathelp(2:3)
         words(17:18)=mathelp(8:9)
         write(33,'(a80)') words

        
         read(32,'(a80)') words
         write(33,'(a80)') words
         read(32,'(a80)') words
         words(15:22)=mathelp(2:9)
         write(33,'(a80)') words


         close(32)
         close(33)

 100     continue

         do ll = 1,40
         read(42,fmt=400,end=200) word
         write(43,fmt=400) word
         end do


 200     continue

 400     format(a80)
         return
         end
