C     UNIV. OF ATHENS - OCEAN GROUP - G.KORRES 07/03/2001
      SUBROUTINE OUTGRD (IIDATE, IUOUT, TITL, CONST, NX, NY,
     1                  ARRAY, AMOWEP, AMOSOP, AMOEAP, AMONOP)

C
C
C*    PURPOSE.
C     --------
C
C          OUTPUT OF AN Matrix in GRD format for contour
C                drouwing by SURFER program
C
C
C**   INTERFACE.
C     ---------
C
C       *CALL* *OUTGRD (IIDATE, IUOUT, NGX, NGY, TITL, CONST,
C                      ARRAY, AMOWEP, AMOSOP, AMOEAP, AMONOP)*
C          *IIDATE*    CHAR*12   DATE (YYMMDDHHMMSS).
C          *IUOUT*    INTEGER   OUTPUT UNIT.
C          *NGX*      INTEGER   FIRST DIMENSION  USED.
C          *NGY*      INTEGER   SECOND DIMENSION USED.
C          *TITL*     CHARACTER HEADER TO BE PRINTED.
C          *CONST*    REAL      SCALING FACTOR.
C          *ARRAY*    REAL      ARRAY TO BE PRINTED.
C          *AMOWEP*   REAL      MOST WESTERN LONGITUDE (DEGREE).
C          *AMOSOP*   REAL      MOST SOUTHERN LATITUDE (DEGREE).
C          *AMOEAP*   REAL      MOST EASTERN LONGITUDE (DEGREE).
C          *AMONOP*   REAL      MOST NORTHERN LATITUDE (DEGREE).
C
C     METHOD.
C     -------
C     Write file in GRD ASCII format (see the SURFER User guide)
C       --- *** ---
C       DSAA
C       Nx   Ny
C       Xmin  Xmax
C       Ymin  Ymax
C       Zmin  Zmax
C
C       A TWO DIMENSIONAL ARRAY IS PRINTED BY ROWS, begining from
C       most souther row.
C       10 values PER file srting.
C       The value 1.70141E+38 is used for blank nouds of the
C       matrix
C
C     EXTERNALS.
C     ----------
C
C       NONE.
C
C     REFERENCE.
C     ----------
C
C       NONE.
C
C ----------------------------------------------------------------------
C
      INCLUDE 'pgrid.h'
C
      DIMENSION  ARRAY(NGX,NGY), ARW(NGX,NGY)
      CHARACTER TITL*100
      CHARACTER*13 OUT_NAME
      CHARACTER*12 IIDATE
      REAL BLANKVAL
      REAL MINAR
      REAL MAXAR
C
C ----------------------------------------------------------------------
C
C
C
C*    1.1 OPEN GRD OUT FILE
C
      MINAR=999999.0
      MAXAR=-999999.0
      BLANKVAL=1.70141E+38
      OUT_NAME(1:1) = TITL(1:1)
      OUT_NAME(2:9) = IIDATE(1:8) 
      OUT_NAME(10:13) = '.GRD'
      OPEN(IUOUT,FILE=OUT_NAME,STATUS='NEW',FORM='FORMATTED'
     1   ,IOSTAT=IERRCODE)
      IF(IERRCODE.GT.0) THEN
	 WRITE (IU06,*) ' *********************************************'
	 WRITE (IU06,*) ' *                                           *'
       WRITE (IU06,*) ' *      FATAL  ERROR IN SUB. OUTGRD          *'
	 WRITE (IU06,*) ' *      ===========================          *'
	 WRITE (IU06,*) ' *                                           *'
       WRITE (IU06,*) ' * CAN NOT OPEN: ', OUT_NAME
       WRITE (IU06,*) ' * PROGRAM WILL BE ABORTED                   *'
	 WRITE (IU06,*) ' *********************************************'
	 CALL ABORT
      ENDIF


C*    1. INITIALIZATION
C     -----------------
C
      DO 100 J=1,NY
      DO 100 I=1,NX
         IF (ABS(ARRAY(I,J)) .LT. 999999) THEN
                ARW(I,J)=CONST*ARRAY(I,J)
                IF (MINAR .GT. ARW(I,J)) MINAR=ARW(I,J)
                IF (MAXAR .LT. ARW(I,J)) MAXAR=ARW(I,J)
         ELSE
                ARW(I,J)=BLANKVAL
         ENDIF
 100  CONTINUE
C
C*   2. WRITING
C
      WRITE(IUOUT,'(''DSAA'')')
      WRITE(IUOUT,*) NX, NY
      WRITE(IUOUT,*) AMOWEP, AMOEAP
      WRITE(IUOUT,*) AMOSOP,AMONOP
      WRITE(IUOUT,*) MINAR, MAXAR


      DO 200 K=1,NY
        J=NY-K+1
      WRITE(IUOUT,300)(ARW(I,J),I=1,NX)
      WRITE(IUOUT,'(/)')
 200  CONTINUE
      CLOSE (UNIT=IUOUT, STATUS='KEEP')

 300  FORMAT(10G15.8)

      RETURN
      END
C   ***************************************************

      SUBROUTINE OUTDIR (IIDATE, IUOUT, TITL, CONST, NX, NY,
     1       WHT, ARRAY, WPER,
     2 SW_HT,SW_DIR,SW_PER,AMOWEP, AMOSOP, AMOEAP, AMONOP,ITIMES)

C
C
C*    PURPOSE.
C     --------
C
C          OUTPUT OF AN Matrix in GRD format for contour
C                drouwing by SURFER program
C
C
C**   INTERFACE.
C     ---------
C
C       *CALL* *OUTGRD (IIDATE, IUOUT, NGX, NGY, TITL, CONST,
C                      ARRAY, AMOWEP, AMOSOP, AMOEAP, AMONOP)*
C          *IIDATE*    CHAR*10   DATE (YYMMDDHHMM).
C          *IUOUT*    INTEGER   OUTPUT UNIT.
C          *NGX*      INTEGER   FIRST DIMENSION  USED.
C          *NGY*      INTEGER   SECOND DIMENSION USED.
C          *TITL*     CHARACTER HEADER TO BE PRINTED.
C          *CONST*    REAL      SCALING FACTOR.
C          *ARRAY*    REAL      ARRAY TO BE PRINTED.
C          *AMOWEP*   REAL      MOST WESTERN LONGITUDE (DEGREE).
C          *AMOSOP*   REAL      MOST SOUTHERN LATITUDE (DEGREE).
C          *AMOEAP*   REAL      MOST EASTERN LONGITUDE (DEGREE).
C          *AMONOP*   REAL      MOST NORTHERN LATITUDE (DEGREE).
C
C     METHOD.
C     -------
C     Write file in GRD ASCII format (see the SURFER User guide)
C       --- *** ---
C       DSAA
C       Nx   Ny
C       Xmin  Xmax
C       Ymin  Ymax
C       Zmin  Zmax
C
C       A TWO DIMENSIONAL ARRAY IS PRINTED BY ROWS, begining from
C       most souther row.
C       10 values PER file srting.
C       The value 1.70141E+38 is used for blank nouds of the
C       matrix
C
C     EXTERNALS.
C     ----------
C
C       NONE.
C
C     REFERENCE.
C     ----------
C
C       NONE.
C
C ----------------------------------------------------------------------
C
      INCLUDE 'pgrid.h'
C
      DIMENSION  ARRAY(NGX,NGY), WHT(NGX,NGY),UCO(NGX,NGY),VCO(NGX,NGY)
      DIMENSION  WPER(NGX,NGY),WPPER(NGX,NGY)
      DIMENSION  SW_HT(NGX,NGY),SW_DIR(NGX,NGY),SW_PER(NGX,NGY)
      DIMENSION UCO_S(NGX,NGY),VCO_S(NGX,NGY)
      DIMENSION ALAT(NGY),ALON(NGX)
      CHARACTER TITL*100
      CHARACTER*13 OUT_NAME,OUT_NAME1
      CHARACTER*12 IIDATE
      REAL BLANKVAL
      REAL MINAR
      REAL MAXAR
      SAVE WHMAX,WHMIN,PERMAX,PERMIN,SHMIN,SHMAX,SW_PERMAX,SW_PERMIN
      DATA IUOUT1/48/
C
C ----------------------------------------------------------------------
C
C
      IF (ITIMES.EQ.1) THEN
      WHMAX = -1.e6
      WHMIN = 1.e6
      SHMAX = -1.e6
      SHMIN = 1.e6
      PERMAX = -1.e6
      PERMIN = 1.e6
      SW_PERMAX = -1.e6
      SW_PERMIN = 1.e6
      ENDIF
C
C*    1.1 OPEN GRD OUT FILE
C
      OUT_NAME(1:1) = TITL(1:1)
      OUT_NAME1(1:1) = TITL(1:1)
      OUT_NAME(2:9) = IIDATE(1:8)
      OUT_NAME1(2:9) = IIDATE(1:8)
      OUT_NAME(10:13) = '.DAT'
      OUT_NAME1(10:13) = '.WWW'
      OPEN(IUOUT,FILE=OUT_NAME,FORM='FORMATTED'
     1   ,IOSTAT=IERRCODE)
c     OPEN(IUOUT1,FILE=OUT_NAME1,FORM='FORMATTED'
c    1   ,IOSTAT=IERRCODE)
      IF(IERRCODE.GT.0) THEN
         WRITE (IU06,*) ' *********************************************'

         WRITE (IU06,*) ' *                                           *'
         WRITE (IU06,*) ' *      FATAL  ERROR IN SUB. OUTGRD          *'
         WRITE (IU06,*) ' *      ===========================          *'
         WRITE (IU06,*) ' *                                           *'
         WRITE (IU06,*) ' * CAN NOT OPEN: ', OUT_NAME
         WRITE (IU06,*) ' * PROGRAM WILL BE ABORTED                   *'
         WRITE (IU06,*) ' *********************************************'
         CALL ABORT
      ENDIF


C*    1. INITIALIZATION
C     -----------------
C

      DY = (AMONOP-AMOSOP)/(NY-1)
      DX = (AMOEAP-AMOWEP)/(NX-1)
      DO 100 J=1,NY
      DO 100 I=1,NX
         alat(j) = amosop + (j-1)*dy
         alon(i) = amowep + (i-1)*dx
         IF (ABS(ARRAY(I,J)) .EQ. 999999) array(i,j)=1.e35
         IF (ABS(WHT(I,J)) .EQ. 999999) wht(i,j)=1.e35
         IF (ABS(WPER(I,J)) .EQ. 999999) wper(i,j)=1.e35
         IF (ABS(WPPER(I,J)) .EQ. 999999) wpper(i,j)=1.e35
         IF (ABS(SW_HT(I,J)) .EQ. 999999) sw_ht(i,j)=1.e35
         IF (ABS(SW_DIR(I,J)) .EQ. 999999) sw_dir(i,j)=1.e35
         IF (ABS(SW_PER(I,J)) .EQ. 999999) sw_per(i,j)=1.e35
 100  CONTINUE

        do 70 j = 1,ny
        do 70 i = 1,nx
         uco(i,j) = 1.e35
         vco(i,j) = 1.e35
         uco_s(i,j) = 1.e35
         vco_s(i,j) = 1.e35
70      continue

        pi = 3.1415927
        do 80 j = 1,ny
        do 80 i = 1,nx
c --- for vectors denoting height
          if (array(i,j).eq.1.e35) goto 80
c         uco(i,j) = sin(array(i,j)*pi/180.)*wht(i,j)
c         vco(i,j) = cos(array(i,j)*pi/180.)*wht(i,j)
c --- for equal vectors
          uco(i,j) = sin(array(i,j)*pi/180.)
          vco(i,j) = cos(array(i,j)*pi/180.)
80      continue
        do 81 j = 1,ny
        do 81 i = 1,nx
c --- for vectors denoting height
          if (sw_dir(i,j).eq.1.e35) goto 81
c         uco_s(i,j) = sin(sw_dir(i,j)*pi/180.)*sw_ht(i,j)
c         vco_s(i,j) = cos(sw_dir(i,j)*pi/180.)*sw_ht(i,j)
c --- for equal vectors
          uco_s(i,j) = sin(sw_dir(i,j)*pi/180.)
          vco_s(i,j) = cos(sw_dir(i,j)*pi/180.)
81      continue
          

          do i = 1,nx
          do j = 1,ny
           if (wht(i,j).ne.1.e35) then
            if (wht(i,j).gt.whmax) whmax=wht(i,j)
            if (wht(i,j).lt.whmin) whmin=wht(i,j)
            if (wper(i,j).gt.permax) permax=wper(i,j)
            if (wper(i,j).lt.permin) permin=wper(i,j)
           end if
           end do
           end do
          do i = 1,nx
          do j = 1,ny
           if (sw_ht(i,j).ne.1.e35) then
            if (sw_ht(i,j).gt.shmax) shmax=sw_ht(i,j)
            if (sw_ht(i,j).lt.shmin) shmin=sw_ht(i,j)
            if (sw_per(i,j).gt.sw_permax) sw_permax=sw_per(i,j)
            if (sw_per(i,j).lt.sw_permin) sw_permin=sw_per(i,j)
           end if
           end do
           end do



           open(29,file='wave_minmax')
           write(29,'(2f8.1)') whmin,whmax 
           write(29,'(2f8.1)') shmin,shmax 
           write(29,'(2f8.1)') permin,permax 
           write(29,'(2f8.1)') sw_permin,sw_permax 
           close(29)


          write(iuout,300) ((wht(i,ny-j+1),i=1,nx),j=1,ny)
          write(iuout,300) ((uco(i,ny-j+1),i=1,nx),j=1,ny)
          write(iuout,300) ((vco(i,ny-j+1),i=1,nx),j=1,ny)
          write(iuout,300) ((wper(i,ny-j+1),i=1,nx),j=1,ny)
          write(iuout,300) ((array(i,ny-j+1),i=1,nx),j=1,ny)
c -- swell
          write(iuout,300) ((sw_ht(i,ny-j+1),i=1,nx),j=1,ny)
          write(iuout,300) ((uco_s(i,ny-j+1),i=1,nx),j=1,ny)
          write(iuout,300) ((vco_s(i,ny-j+1),i=1,nx),j=1,ny)
          write(iuout,300) ((sw_per(i,ny-j+1),i=1,nx),j=1,ny)

c         do j = 1,ny
c         do i = 1,nx
c  if (wht(i,ny-j+1).ne.1.e35) then
c  write(iuout1,555) wht(i,ny-j+1),360.-array(i,ny-j+1),
c    &    wper(i,ny-j+1),alon(i),alat(j)
c  end if
c  end do
c  end do

C
      CLOSE (UNIT=IUOUT, STATUS='KEEP')
      CLOSE (UNIT=IUOUT1)

 300  FORMAT(8e10.3)
 350  FORMAT(8e12.6)
 555  FORMAT(5f12.5)

      RETURN
      END


c ---------------------------------------------------------------

      FUNCTION IECF_len(y_char)
c
c  Calculate the 'length' of a character string.
c
c  The 'length' is the character-position of the last character in the
c  string which is neither 'BLANK', nor 'NULL'.
c
      CHARACTER*(*) y_char
      CHARACTER*1   null
c
      null = char(0)
      lgth = len(y_char)
c
      DO 10 i = lgth , 1 , -1
      IF ((y_char(i:i) .NE. ' ') .AND. (y_char(i:i) .NE. null)) goto 20
   10 CONTINUE
      i = 0
c
   20 CONTINUE
      IECF_len = i
c
      RETURN
      END
      SUBROUTINE INCDATE (DATE, ISHIFT)

C ----------------------------------------------------------------------
C
C**** *INCDATE* - TO UPDATE DATE TIME GROUP
C
C     L. BERTOTTI, P.JANSSEN.
C
C     H. GUNTHER   ECMWF  NOVEMBER 1989    NEGATIVE INCREMENTS.
C
C*    PURPOSE.
C     --------
C
C       UPDATING DATE TIME GROUP.
C
C**   INTERFACE.
C     ----------
C
C       *CALL* *INCDATE (IIDATE,ISHIFT)*
C         *IIDATE*  INTEGER - DATE TIME GROUP (YYMMDDHHMM)
C         *ISHIFT* INTEGER - TIME INCREMENT IN SECONDS, WHERE
C                            ABS (ISHIFT) HAS TO BE LESS THEN 1 YEAR
C
C     METHOD.
C     -------
C
C       NONE.
C
C     EXTERNALS.
C     ----------
C
C       NONE.
C
C     REFERENCES.
C     -----------
C
C       NONE.
C
C ----------------------------------------------------------------------
C
      CHARACTER*12 DATE
      DIMENSION MON(12)
C
      DATA MON /31,28,31,30,31,30,31,31,30,31,30,31/
C
C ----------------------------------------------------------------------
C
C*    1.0 SPLITE DATE TIME GROUP INTO MINUTE, HOUR, DAY, MONTH, YEAR.
C         -----------------------------------------------------------
C
 1000 CONTINUE
      READ(DATE,5) IYEAR,MONTH,IDAY,IHOUR,MINUT,ISEC
      IF (MOD(IYEAR,4).EQ.0) THEN
         MON(2) = 29
      ELSE
         MON(2) = 28
      ENDIF

C
C ----------------------------------------------------------------------
C
C*    2.0 ADD SECONDS AND UPDATE DATE AND TIME.
C         -------------------------------------
      ISEC=ISEC+MOD(ISHIFT,60)
      IF (ISEC.GE.60) THEN
        MINUT = MINUT+ISEC/60
        ISEC = ISEC-(ISEC/60)*60
      ELSE IF (ISEC.LT.0) THEN
        MINUT = MINUT +(ISEC-59)/60
        ISEC = ISEC-((ISEC-59)/60)*60
      END IF

C
 2000 CONTINUE
      MINUT=MINUT+ISHIFT/60
C
C     2.1 POSITIVE SHIFT GREATER THAN 1 MINUTE.
C
      IF (MINUT.GE.60) THEN
         IHOUR = IHOUR + MINUT/60
         MINUT = MINUT - (MINUT/60)*60
         IF (IHOUR.GE.24) THEN
            IDAY = IDAY + IHOUR/24
            IHOUR = IHOUR - (IHOUR/24)*24
            IF (IDAY.GT.MON(MONTH)) THEN
 1300          CONTINUE
               IDAY=IDAY-MON(MONTH)
               MONTH=MONTH+1
               IF(MONTH.EQ.13) THEN
                  MONTH = 1
                  IYEAR=MOD(IYEAR+1,100)
                  IF (MOD(IYEAR,4).EQ.0) THEN
                     MON(2)=29
                  ELSE
                     MON(2)=28
                  ENDIF
               END IF
               IF(IDAY.GT.MON(MONTH)) GO TO 1300
            END IF
         END IF
      ELSE IF (MINUT.LT.0) THEN
C
C     2.2 NEGATIVE SHIFT.
C
         IHOUR = IHOUR + (MINUT-59)/60
         MINUT = MINUT - ((MINUT-59)/60)*60
         IF (IHOUR.LT.0) THEN
            IDAY = IDAY + (IHOUR-23)/24
            IHOUR = IHOUR - ((IHOUR-23)/24)*24
            IF (IDAY.LT.1) THEN
 1400          CONTINUE
               MONTH=MONTH-1
               IF(MONTH.EQ.0) THEN
                  MONTH = 12
                  IYEAR=MOD(IYEAR+99,100)
                  IF (MOD(IYEAR,4).EQ.0) THEN
                     MON(2)=29
                  ELSE
                     MON(2)=28
                  ENDIF
               END IF
               IDAY=IDAY+MON(MONTH)
               IF(IDAY.LT.1) GO TO 1400
            END IF
         END IF
      END IF
C
C ----------------------------------------------------------------------
C
C*    3.0 COMPOSE NEW DATE TIME GROUP.
C         ----------------------------
C
 3000 CONTINUE
      WRITE(DATE,5) IYEAR,MONTH,IDAY,IHOUR,MINUT,ISEC
C
    5 FORMAT(6I2.2)
C
      RETURN
      END
      SUBROUTINE INGRID (IU06, IUNIT, IUNITS,IIDATE, NX, NY,
     1                   AMOWEP, AMOSOP, AMOEAP, AMONOP,
     2                   WAVEHT, WAVEDIR, WAVEMFR, WINDSPD,
     3                   WINDDIR, WAVEPFR, CDG, TAUWG, 
     4  SW_HT,SW_DIR,SW_PER,FFLAG, IEOF)

C ----------------------------------------------------------------------
C
C**** *INGRID* - READS WAVE MODEL OUTPUT FILE OF INTEGRATED DATA
C
C     H. GUNTHER          ECMWF             DECEMBER 1989
C
C*    PURPOSE.
C     --------
C
C       POST PROCESSING ROUTINE FOR WAVE MODEL.
C
C**   INTERFACE.
C     ----------
C
C       *CALL INGRID (IU06, IUNIT, IIDATE, NX, NY,
C                     AMOWEP, AMOSOP, AMOEAP, AMONOP,
C                     WAVEHT, WAVEDIR, WAVEMFR, WINDSPD,
C                     WINDDIR, WAVEPFR, CDG, TAUWG, FFLAG, IEOF)*
C
C         *IU06*    - LOGICAL UNIT PRINTER OUTPUT.
C         *IUNIT*   - LOGICAL UNIT FOR INPUT FROM WAVE MODEL.
C         *IIDATE*   - DATE TIME OF FIELDS READ IN (YYMMDDHHMM).
C         *NX*      - NUMBER OF GRID POINTS IN X (FIRST DIMENSION).
C         *NY*      - NUMBER OF GRID POINTS IN Y (SECOND DIMENSION).
C         *AMOWEP*  - MOST WESTERN LONGITUDE IN GRID (DEGREE).
C         *AMOSOP*  - MOST SOUTHETN LATITUDE IN GRID (DEGREE).
C         *AMOEAP*  - MOST EASTERN LONGITUDE IN GRID (DEGREE).
C         *AMONOP*  - MOST NORTHERN LATITUDE IN GRID (DEGREE).
C         *WAVEHT*  - MEAN WAVE HEIGHT (METRES).
C         *WAVEDIR* - MEAN WAVE DIRECTION (DEGREE CLOCKWISE FROM NORTH).
C         *WAVEMFR* - MEAN FREQUENCY (HERTZ).
C         *WINDSPD* - FRICTION VELOCITY (METRE/SECOND).
C         *WINDDIR* - WIND DIRECTION (DEGREE CLOCKWISE FROM NORTH).
C         *WAVEPFR* - WAVE PEAK FREQUENCY (HERTZ).
C         *CDG*     - DRAG COEFFICIENT.
C         *TAUWG*   - NORMALISED WAVE STRESS (%).
C         *FFLAG    - DATA FLAG.
C         *IEOF*    - END OF FILE INDICATOR.
C
C     METHOD.
C     -------
C
C       UNFORMATED READ.
C
C     EXTERNALS.
C     ----------
C
C       *ABORT*     - TERMINATES PROCESSING.
C
C ----------------------------------------------------------------------
C
      INCLUDE 'pgrid.h'
C
      CHARACTER*12 IIDATE
      LOGICAL IEOF, FFLAG(8),FFLAGS(4)
      DIMENSION WAVEHT(NGX,NGY), WAVEDIR(NGX,NGY), WAVEMFR(NGX,NGY)
      DIMENSION WINDSPD(NGX,NGY), WINDDIR(NGX,NGY), WAVEPFR(NGX,NGY)
      DIMENSION CDG(NGX,NGY), TAUWG(NGX,NGY)
      DIMENSION SW_HT(NGX,NGY), SW_DIR(NGX,NGY), SW_PER(NGX,NGY)
      DIMENSION WINDSEA_DIR(NGX,NGY)
C
C ----------------------------------------------------------------------
C
C*    1. DATA HEADER FROM WAVE MODEL OUTPUT (SUB. OUTGRID)
C        -------------------------------------------------
C
C*    1.1 READ DATA HEADER
C         ----------------
C
      READ(IUNITS,END=4000) IIDATE, DNGX, DNGY,
     1                      AMOWEP, AMOSOP, AMOEAP, AMONOP
c ---- READ SWELL DATA
      READ(IUNITS,END=4000) (FFLAGS(J),J=1,4)
c swell sign. height
      READ(IUNITS,END=4000) SW_HT
c swell direction
      READ(IUNITS,END=4000) SW_DIR
c wind sea direction
      READ(IUNITS,END=4000) WINDSEA_DIR
c swell frequency
      READ(IUNITS,END=4000) SW_PER

 4000  CONTINUE

      READ(IUNIT, END=3000) IIDATE, DNGX, DNGY,
     1                      AMOWEP, AMOSOP, AMOEAP, AMONOP


C
C*    1.2 CONVERT DATE AND NUMBER OF POINTS TO INTEGER
C         --------------------------------------------
C
      NX= NINT(DNGX)
      NY= NINT(DNGY)
C
C     1.3 CHECK ON DIMENSION
C         ------------------
      IF (NX.GT.NGX .OR. NY.GT.NGY) THEN
	 WRITE(IU06,*) ' ********************************************'
	 WRITE(IU06,*) ' *                                          *'
	 WRITE(IU06,*) ' *        FATAL ERROR SUB. INGRID           *'
	 WRITE(IU06,*) ' *        =======================           *'
	 WRITE(IU06,*) ' *                                          *'
	 WRITE(IU06,*) ' *  GRID DIMENSIONS DO NOT MATCH.           *'
	 WRITE(IU06,*) ' *  DIMENSIONS IN      ARE  NGX = ', NGX
	 WRITE(IU06,*) ' *                          NGY = ', NGY
	 WRITE(IU06,*) ' *  DIMENSIONS REQUIRED ARE NX = ', NX
	 WRITE(IU06,*) ' *                          NY = ', NY
	 WRITE(IU06,*) ' *                                          *'
	 WRITE(IU06,*) ' *  PROGRAM WILL ABORT.                     *'
	 WRITE(IU06,*) ' ********************************************'
	 CALL ABORT
      END IF
C
C ----------------------------------------------------------------------
C
C*    2. DATA FROM WAVE MODEL OUTPUT (SUB OUTGRID).
C        ------------------------------------------
c---------------------------------------------------

      READ(IUNIT, END=3000) (FFLAG(J),J=1,8)
      IF (FFLAG(1))
     1   READ(IUNIT, END=3000) ((WAVEHT(I,K) ,I=1,NX),K=1,NY)
      IF (FFLAG(2))
     1   READ(IUNIT, END=3000) ((WAVEDIR(I,K),I=1,NX),K=1,NY)
      IF (FFLAG(3))
     1   READ(IUNIT, END=3000) ((WAVEMFR(I,K),I=1,NX),K=1,NY)
      IF (FFLAG(4))
     1   READ(IUNIT, END=3000) ((WINDSPD(I,K),I=1,NX),K=1,NY)
      IF (FFLAG(5))
     1   READ(IUNIT, END=3000) ((WINDDIR(I,K),I=1,NX),K=1,NY)
      IF (FFLAG(6))
     1   READ(IUNIT, END=3000) ((WAVEPFR(I,K),I=1,NX),K=1,NY)
      IF (FFLAG(7))
     1   READ(IUNIT, END=3000) ((CDG(I,K),I=1,NX),K=1,NY)
      IF (FFLAG(8))
     1   READ(IUNIT, END=3000) ((TAUWG(I,K),I=1,NX),K=1,NY)
C
C ----------------------------------------------------------------------
C
C*    3. END OF FILE
C        -----------
C
      IEOF = .FALSE.
      RETURN

 3000 CONTINUE
      IEOF = .TRUE.

      RETURN
      END
      SUBROUTINE OPENFIL (IU06, IUNIT, IUNITS,IIDATE, FILEID, STAT,
     1                    USERID, RUNID, PATH, IFAIL)

C -------------------------------------------------------------------
C
C**** *OPENFIL* - OPENS A FILE ( UNICOS VERSION ).
C
C     RENATE PORTZ     MPI HAMBURG   JULY 1990
C     HEINZ GUNTHER    GKSS/ECMWF    MARCH 1991  MODIFIED FOR CYCLE_4.
C
C*    PURPOSE.
C     --------
C
C       OPENS A FILE WITH VARIABLE FILE NAME.
C
C**   INTERFACE.
C     ----------
C
C       *CALL* *OPENFIL (IU06, IUNIT, IIDATE, FILEID, STAT,
C                        USERID, RUNID, PATH, IFAIL)
C         *IU06*    -   PRINTER OUTPUT UNIT.
C         *IUNIT*   -   LOGCIAL UNIT FILE IS ASSIGNED TO.
C         *IIDATE*   -   DATE IN FILE NAME.
C         *FILEID*  -   FILE IDENTIFIER.
C         *STAT*    -   FILE STATUS 'OLD' OR 'NEW'.
C         *USERID*  -   USER IDENTIFIER.
C         *RUNID*   -   RUN IDENTIFIER.
C         *PATH*    -   PATH NAME (WITHOUT FILE NAME).
C         *IFAIL*   -   ERROR FLAG = 0 FILE OPENED
C                                    = 1 FILE NOT OPENED.
C
C     EXTERNALS.
C     ----------
C
C       *ABORT*     - TERMINATES PROCESSING.
C       *DIFDATE*   - COMPUTE TIME DIFFERENCES.
C       *IECF_LEN*  - LENGTH OF CHARACTER STRING.
C
C     METHOD.
C     -------
C
C       THE METHOD USED IN THIS SUB DEPENDS UPON THE COMPUTER
C       ENVIROMENT. IN ITS PRESENT FORM THE ROUTINE IS ADOPTED TO
C       THE UNICOS CRAY SYSTEM.
C
C       THE FILE NAME IS BUILD FORM THE 3 CHARACTER FILEID FOLLOWED
C       BY YYMMDDHHMM0 WHERE YYMMDDHHMM IS THE DATE OF THE LAST
C       OUTPUT IN THIS FILE.
C       THESE NUMBERS ARE CONSTRUCTED FROM IIDATE.
C
C       THE FULL PATH NAME IS PATH/FILE NAME
C
C     REFERENCES.
C     -----------
C
C       NONE.
C
C ----------------------------------------------------------------------
C
      INTEGER IU06, IUNIT, IFAIL
      CHARACTER FILEID*3, STAT*3, USERID*3, RUNID*3, PATH*60,
     &          IIDATE*12

      CHARACTER FILENA*16, FILENAS*16,IU*8, FNAME*128,FNAMES*128
C
C        *FILENA*  CHARACTER   GENERATED FILE NAME.
C        *IU*      CHARACTER   UNIT ALIAS FILE NAME.
C        *FNAME*   CHARACTER   FULL PATH NAME.
C
C ----------------------------------------------------------------------
C
C*    1. BUILD FILE NAME.
C        ----------------
C
 1000 CONTINUE
      FILENA = FILEID
      FILENAS = 'SWE'
      WRITE (FILENA(4:16),'(A12)') IIDATE
      WRITE (FILENAS(4:16),'(A12)') IIDATE
C
C ----------------------------------------------------------------------
C
C*    2. CONSTRUCTED FULL PATH.
C        ----------------------
C
 2000 CONTINUE
      ILEN  = IECF_LEN(PATH)
      LNAME = IECF_LEN(FILENA)
      FNAME = ' '
      FNAMES = ' '
       FNAME = PATH(1:ILEN)//'/'//FILENA(1:LNAME)
       FNAMES = PATH(1:ILEN)//'/'//FILENAS(1:LNAME)
C
C*    3. OPEN FILE AND RETURN.
C        ---------------------
C
 3000 CONTINUE
      ILEN = IECF_LEN(FNAME)
      OPEN (UNIT=IUNIT, FILE=FNAME, STATUS=STAT, FORM='UNFORMATTED',
     1      ERR=4000)
      OPEN (UNIT=IUNITS, FILE=FNAMES, STATUS=STAT, FORM='UNFORMATTED',
     1      ERR=4000)

      WRITE (IU06,*) ' FILE [ ', FNAME(1:ILEN),' ] OPENED',
     1               ' AND ASSIGNED TO UNIT ', IUNIT
      WRITE (IU06,*) ' FILE [ ', FNAMES(1:ILEN),' ] OPENED',
     1               ' AND ASSIGNED TO UNIT ', IUNITS

      IFAIL = 0
      RETURN
C
C*    4. ERROR MESSAGE.
C        --------------
C
 4000 CONTINUE
      IFAIL = 1
      WRITE (IU06,*) ' +++++++++++++++++++++++++++++++++++'
      WRITE (IU06,*) ' +                                 +'
      WRITE (IU06,*) ' +    WARNING ERROR SUB. OPENFIL   +'
      WRITE (IU06,*) ' +    ==========================   +'
      WRITE (IU06,*) ' +                                 +'
      WRITE (IU06,*) ' + COULD NOT OPEN FILE             +'
      WRITE (IU06,*) ' + FULL PATH NAME IS : ', FNAME(1:ILEN)
      WRITE (IU06,*) ' +                                 +'
      WRITE (IU06,*) ' +++++++++++++++++++++++++++++++++++'
      RETURN

      END
      SUBROUTINE OUTPP (IIDATE, IUOUT, TITL, CONST, NX, NY,
     1                  ARRAY, AMOWEP, AMOSOP, AMOEAP, AMONOP)

C ---------------------------------------------------------------
C
C**** *OUTPP* - FORMATED OUTPUT OF AN ARRAY.
C
C     H. GUNTHER       ECMWF    NOVEMBER 1989
C
C*    PURPOSE.
C     --------
C
C       FORMATED OUTPUT OF AN ARRAY.
C
C**   INTERFACE.
C     ---------
C
C       *CALL* *OUTPP (IIDATE, IUOUT, NGX, NGY, TITL, CONST,
C                      ARRAY, AMOWEP, AMOSOP, AMOEAP, AMONOP)*
C          *IIDATE*    CHAR*10   DATE (YYMMDDHHMM).
C          *IUOUT*    INTEGER   OUTPUT UNIT.
C          *NGX*      INTEGER   FIRST DIMENSION  USED.
C          *NGY*      INTEGER   SECOND DIMENSION USED.
C          *TITL*     CHARACTER HEADER TO BE PRINTED.
C          *CONST*    REAL      SCALING FACTOR.
C          *ARRAY*    REAL      ARRAY TO BE PRINTED.
C          *AMOWEP*   REAL      MOST WESTERN LONGITUDE (DEGREE).
C          *AMOSOP*   REAL      MOST SOUTHERN LATITUDE (DEGREE).
C          *AMOEAP*   REAL      MOST EASTERN LONGITUDE (DEGREE).
C          *AMONOP*   REAL      MOST NORTHERN LATITUDE (DEGREE).
C
C     METHOD.
C     -------
C
C       A TWO DIMENSIONAL ARRAY IS PRINTED WITH A MAXIMUM OF
C       30 COLUMNS PER PAGE.
C
C     EXTERNALS.
C     ----------
C
C       NONE.
C
C     REFERENCE.
C     ----------
C
C       NONE.
C
C ----------------------------------------------------------------------
C
      INCLUDE 'pgrid.h'
C
      CHARACTER TITL*100
      CHARACTER*12 IIDATE
      DIMENSION IARRAY(NGX,NGY),ARRAY(NGX,NGY),ILON(NGX),YLAT(NGY)
C
C ----------------------------------------------------------------------
C
C
C*    1. INITIALIZATION
C     -----------------
C
      DLAMA = (AMOEAP-AMOWEP)/FLOAT(NX-1)
      DO 110 I=1,NX
	 ILON(I)=NINT(AMOWEP + (I-1)*DLAMA)
 110  CONTINUE
      DPHIA = (AMOSOP-AMONOP)/FLOAT(NY-1)
      DO 120 J=1,NY
	 YLAT(J)=AMONOP + (J-1)*DPHIA
 120  CONTINUE

      NPTS=30
      NPAGE=(NX+NPTS-1)/NPTS
      DO 100 J=1,NY
      DO 100 I=1,NX
	 IARRAY(I,J) = NINT(CONST*ARRAY(I,J))
 100  CONTINUE
      ISTART=-NPTS+1
      IEND=ISTART+NPTS-1

      DO 200 NP=1,NPAGE
	 WRITE (IUOUT,300) IIDATE,TITL,NP
	 ISTART=ISTART+NPTS
	 IEND= MIN(IEND+NPTS,NX)
	 WRITE (IUOUT,302) (I,I=ISTART,IEND)
	 WRITE (IUOUT,303) (ILON(I),I=ISTART,IEND)
	 WRITE (IUOUT,304)
	 DO 220 J=1,NY
	    WRITE (IUOUT,305) J,YLAT(J),(IARRAY(I,J),I=ISTART,IEND)
 220     CONTINUE
 200  CONTINUE

 300  FORMAT(1H1,6X,A10,2X,A100,5X,'PAGE ',I2,/)
 302  FORMAT(7X,'I=',30I4)
 303  FORMAT(5X,'LON=',30I4)
 304  FORMAT('   J LAT',/)
 305  FORMAT(1X,I2,F5.1,1X,30I4)

      RETURN
      END
      PROGRAM PGRID
c     USE DFPORT       
C ------------------------------------------------------------------
C
C**** *PGRID* - PRINTS MAPS FROM WAMODEL OUTPUT.
C
C        H. GUNTHER    GKSS/ECMWF          DECEMBER 1989
C
C*    PURPOSE.
C     --------
C
C       POSTPROCESSING OF WAM MODEL INTEGRATED DATA.
C
C**   INTERFACE.
C     ----------
C
C       *PROGRAM* *PGRID*
C          IU01     INPUT UNIT WAVE AND WIND FIELDS (WAMODEL IU20).
C          IU05     USER INPUT.
C          IU06     PRINTER OUTPUT.
C
C     EXTERNALS
C     ---------
C
C       *ABORT*     - TERMINATES PROCESSING.
C       *INCDATE*   - INCREMENTS DATE-TIME-GROUP
C       *INGRID*    - READS WAVEMODEL OUTPUT FILE (MAP) (GRIDDED)
C       *OPENFIL*   - OPENS A FILE.
C       *OUTPP*     - PRINTS A FIELD.
C       *UIPGRID*   - READS IN USER INPUT.
C
C     METHOD.
C     -------
C
C       THIS PROGRAM TAKES THE  WAM MODEL OUTPUTS AS INPUT AND
C       PRINTS FIELDS OF WAVE HEIGHTS, WAVE DIRECTION, FRICTION
C       VELOCITY, WINDSPEED U10, WIND DIRECTION, WAVE PEAK PERIOD,
C       WAVE MEAN PERIOD, NORMALIZED WAVE STRESS, AND/OR DRAG
C       COEFFICIENT.
C       THE FILES ARE DYNAMICALLY ASSIGNED BY OPENFIL.
C
C     REFERENCE.
C     ----------
C
C        NONE.
C
C -------------------------------------------------------------------
C
      INCLUDE 'pgrid.h'
C
C       VARIABLE.   TYPE.    PURPOSE.
C       ---------   -----    --------
C        *NGX*      INTEGER  FIRST DIMENSION OF GRID ARRAY.
C        *NGY*      INTEGER  SECOND DIMENSION OF GRID ARRAY.
C        *IDS*      INTEGER  DIMENSION OF PARAMETER ARRAY.
C        *IDO*      INTEGER  DIMENSION OF OUTPUT TIME ARRAY.
C
      CHARACTER USERID*3, RUNID*3, FILEID*3, PATH*60, NAME(IDS)*50
      CHARACTER TITL*100
      CHARACTER*12 IDATEA, IDATEE, IOUTT(IDO), IDATEF, IDATEP,
     &             JJDATE, IIDATE, IIHH
      LOGICAL IEOF, PLOTF(IDS), FFLAG(8)

      DIMENSION WAVEHT(NGX,NGY), WAVEDIR(NGX,NGY), WAVEMFR(NGX,NGY),
     1          WINDSPD(NGX,NGY), WINDDIR(NGX,NGY), WAVEPFR(NGX,NGY),
     2          WIND10(NGX,NGY), CD(NGX,NGY), WSTRESS(NGX,NGY),
     3          SW_HT(NGX,NGY), SW_DIR(NGX,NGY), SW_PER(NGX,NGY)
C
C ---------------------------------------------------------------------
C
C*    1. INITALISATION.
C        --------------
C
C*    1.1 INITALISE UNITS.
C         ----------------
C
      ITIMES = 0
      IU01 = 1
      IU02 = 45
      IU05 = 5
      IU06 = 6
      IU07 = 7
C
C*    1.2 READ USER INPUT.
C         ----------------
C
      NS=0
C
      CALL UIPGRID (IU05, IU06, IDS, NAME, PLOTF, NS,
     1             IDATEA, IDATEE, IDELDO, IDO, NOUTT, IOUTT,
     2             USERID, RUNID, FILEID, PATH, IDATEF, IDELFI)
C
C*    1.3 FIRST WAVEMODEL OUTPUT FILE DATE AND PRINT DATE.
C         ------------------------------------------------
C
      JJDATE  = IDATEF
      IF (NOUTT.EQ.0) THEN
	 IDATEP = IDATEA
      ELSE
	 IDATEE = '000000000000'
	 IDATEP = IOUTT(1)
	 DO 1301 I=1,NOUTT
	    IF(IDATEP.GT.IOUTT(I))IDATEP=IOUTT(I)
	    IF(IDATEE.LT.IOUTT(I))IDATEE=IOUTT(I)
 1301    CONTINUE
      ENDIF
C
C ---------------------------------------------------------------------
C
C*    2. LOOP OVER OUTPUT FILES.
C        -----------------------
C
 2000 CONTINUE
C
C*    2.1 FETCH FILE.
C         -----------
C
      CALL OPENFIL (IU06, IU01,IU02, JJDATE, FILEID, 'OLD',
     1              USERID, RUNID, PATH, IFAIL)
      IF (IFAIL.NE.0) STOP
C
C*    2.2  LOOP OVER OUTPUT TIMES.
C          -----------------------
 2200 CONTINUE
C
C*    2.2.1 READ IN WIND AND WAVE FIELDS.
C           -----------------------------
C


      CALL INGRID (IU06, IU01,IU02, IIDATE, NX, NY,
     1             AMOWEP, AMOSOP, AMOEAP, AMONOP,
     2             WAVEHT, WAVEDIR, WAVEMFR, WINDSPD,
     3             WINDDIR, WAVEPFR, CD, WSTRESS, 
     4 SW_HT,SW_DIR,SW_PER,FFLAG, IEOF)

C
C*    2.2.2 END OF FILE ENCOUNTED?
C           ----------------------
C
      IF (IEOF) THEN
C
C*    2.2.2.1 INCREMENT DATE FOR THE NEXT FILE.
C             ---------------------------------
C
	 CALL INCDATE (JJDATE, IDELFI)
C
C*    2.2.2.2 CLOSE OLD FILE AND BRANCH BACK TO 2.0 FOR NEXT FILE.
C             ----------------------------------------------------
C
	 CLOSE (UNIT=IU01, STATUS='KEEP')
	 CLOSE (UNIT=IU02, STATUS='KEEP')
	 IF (JJDATE.GT.IDATEE) STOP
	 GOTO 2000
      ENDIF
C
C*    2.2.3 OUTPUT TIME FOUND?
C           ------------------
C

 2300 CONTINUE
C      write (*,*) 'IIDATE=',IIDATE, ' IDATEP =',IDATEP

      IF (IIDATE.LT.IDATEP) GOTO 2200

      IF (IIDATE.GT.IDATEP) THEN
	 IF (NOUTT.EQ.0) THEN
	    CALL INCDATE(IDATEP,IDELDO)
	 ELSE
	    IIHH = '999999999999'
	    DO 2301 I=1,NOUTT
	       IF (IOUTT(I).GT.IDATEP) THEN
		 IF(IIHH.GT.IOUTT(I)) IIHH=IOUTT(I)
	       ENDIF
 2301       CONTINUE
	    IDATEP = IIHH
	 ENDIF
C	 IF (IDATEP.GE.IDATEE) STOP
	 IF (IDATEP.GT.IDATEE) STOP
	 GOTO 2300
      ENDIF
C
C*    3. DO OUTPUT OF REQUESTED FIELDS.
C        ------------------------------
C
C*    3.1 OUTPUT OF WAVE HEIGHT.
C         ----------------------
C

      IF (PLOTF(1).AND. FFLAG(1)) THEN
	 LIU   = IECF_LEN(NAME(1))
	 TITL(1:LIU) = NAME(1)(1:LIU)
	 WRITE (TITL(LIU+1:100),'('' IN 0.1 METRES '')')
	 CONST = 10.
	 DO 3100 K=1,NY
	 DO 3100 I=1,NX
	    IF (WAVEHT(I,K).LT. 0.00001) WAVEHT(I,K) = -999999.
C	    IF (WAVEHT(I,K).LT. 0.00001) WAVEHT(I,K) = -9999999999.
 3100    CONTINUE

c                CALL  OUTGRD (IIDATE, IU07, TITL, 1.0, NX, NY,
c    1                  WAVEHT, AMOWEP, AMOSOP, AMOEAP, AMONOP)

                 CALL OUTPP (IIDATE, IU06, TITL, CONST, NX, NY,
     1               WAVEHT, AMOWEP, AMOSOP, AMOEAP, AMONOP)

      ELSEIF (PLOTF(1) .AND. .NOT. FFLAG(1)) THEN
	 WRITE (IU06,*) ' WAVE HEIGHTS ARE NOT IN FILE FOR IIDATE = ',
     1                  IIDATE
      ENDIF
C
C*    3.2 OUTPUT OF WAVE DIRECTION.
C         -------------------------
C
      IF (PLOTF(2) .AND. FFLAG(2)) THEN
	 LIU   = IECF_LEN(NAME(2))
	 TITL(1:LIU) = NAME(2)(1:LIU)
	 WRITE (TITL(LIU+1:100),'('' IN DEGREES '')')
	 CONST = 1.
	 DO 3200 K=1,NY
	 DO 3200 I=1,NX
	    IF (WAVEHT(I,K).LT.0.00001) THEN
	       WAVEDIR(I,K) = 999999.
	       WAVEMFR(I,K) = 999999.
	       WAVEPFR(I,K) = 999999.
C	       WAVEDIR(I,K) = 9999999999.
	    ELSE
	       IF (WAVEDIR(I,K).LT.0.) WAVEDIR(I,K) = WAVEDIR(I,K)+360.
	       WAVEMFR(I,K) = 1./WAVEMFR(I,K)
	       WAVEPFR(I,K) = 1./WAVEPFR(I,K)
	    ENDIF
 3200    CONTINUE
	 DO 3201 K=1,NY
	 DO 3201 I=1,NX
	    IF (SW_HT(I,K).LT.0.00001) THEN
            SW_HT(I,K)=999999.
            SW_DIR(I,K)=999999.
            SW_PER(I,K)=999999.
           ELSE
	       IF (SW_DIR(I,K).LT.0.) SW_DIR(I,K) = SW_DIR(I,K)+360.
               SW_PER(I,K)=1./SW_PER(I,K)
            ENDIF
 3201     CONTINUE

          ITIMES = ITIMES + 1
                 CALL  OUTDIR (IIDATE, IU07, TITL, 1.0, NX, NY,
     1 WAVEHT, WAVEDIR, WAVEMFR,
     2 SW_HT,SW_DIR,SW_PER,AMOWEP, AMOSOP, AMOEAP, AMONOP,ITIMES)



	 CALL OUTPP (IIDATE, IU06, TITL, CONST, NX, NY,
     1               WAVEDIR, AMOWEP, AMOSOP, AMOEAP, AMONOP)

      ELSEIF (PLOTF(1).AND. .NOT. FFLAG(2)) THEN
	 WRITE (IU06,*) ' WAVE DIRECTIONS ARE NOT IN FILE FOR IIDATE = ',
     1                  IIDATE
      ENDIF
C
C*    3.3 OUTPUT OF WIND SPEED U10.
C         -------------------------
C
      IF (PLOTF(3) .AND. FFLAG(4) .AND. FFLAG(7)) THEN
	 LIU   = IECF_LEN(NAME(3))
	 TITL(1:LIU) = NAME(3)(1:LIU)
	 WRITE (TITL(LIU+1:100),'('' IN 0.1 METRES/SECOND '')')
	 CONST = 10.
C
C*    3.3.1 CONVERT FRICTION VELOCITIES TO U10.
C           -----------------------------------
C
	 DO 3300 K=1,NY
	 DO 3300 I=1,NX
	    IF (WAVEHT(I,K).LT.0.00001) THEN
	       WIND10(I,K) = -999999.
C	       WIND10(I,K) = -9999999999.
	    ELSE
	       WIND10(I,K) = WINDSPD(I,K)/SQRT(CD(I,K))
	    ENDIF
 3300    CONTINUE
	 CALL OUTPP (IIDATE, IU06, TITL, CONST, NX, NY,
     1               WIND10, AMOWEP, AMOSOP, AMOEAP, AMONOP)

      ELSEIF (PLOTF(3) .AND. .NOT.(FFLAG(4) .AND. FFLAG(7))) THEN
	 WRITE (IU06,*) ' WIND SPEED U10 IS NOT PRINTED  FOR IIDATE = ',
     1                  IIDATE
	 WRITE (IU06,*) ' FRICTION VELOCITIES OR DRAG IS NOT IN FILE '
      ENDIF
C
C*    3.4 OUTPUT OF FRICTION VELOCITY.
C         ----------------------------
C
      IF (PLOTF(4) .AND. FFLAG(4)) THEN
	 LIU   = IECF_LEN(NAME(4))
	 TITL(1:LIU) = NAME(4)(1:LIU)
	 WRITE (TITL(LIU+1:100),'('' IN 0.01 METRES/SECOND '')')
	 CONST = 100.
	 DO 3400 K=1,NY
	 DO 3400 I=1,NX
	    IF (WAVEHT(I,K).LT.0.00001) WINDSPD(I,K) = -999999.
C	    IF (WAVEHT(I,K).LT.0.00001) WINDSPD(I,K) = -9999999999.
 3400    CONTINUE
	 CALL OUTPP (IIDATE, IU06, TITL, CONST, NX, NY,
     1               WINDSPD, AMOWEP, AMOSOP, AMOEAP, AMONOP)

      ELSEIF (PLOTF(4) .AND. .NOT.FFLAG(4)) THEN
	 WRITE (IU06,*) ' FRICTION VELOCITIES ARE NOT IN FILE FOR',
     1                  ' IIDATE = ', IIDATE
      ENDIF
C
C*    3.5 OUTPUT OF WIND DIRECTION.
C         -------------------------
C
      IF (PLOTF(5) .AND. FFLAG(5)) THEN
	 LIU   = IECF_LEN(NAME(5))
	 TITL(1:LIU) = NAME(5)(1:LIU)
	 WRITE (TITL(LIU+1:100),'('' IN DEGREES '')')
	 CONST = 1.
	 DO 3500 K=1,NY
	 DO 3500 I=1,NX
	    IF (WAVEHT(I,K).LT.0.00001) THEN
	       WINDDIR(I,K) = 999999.
C	       WINDDIR(I,K) = 9999999999.
	    ELSE
	       IF (WINDDIR(I,K).LT.0.) WINDDIR(I,K) = WINDDIR(I,K)+360.
	    ENDIF
 3500    CONTINUE
	 CALL OUTPP (IIDATE, IU06, TITL, CONST, NX, NY,
     1               WINDDIR, AMOWEP, AMOSOP, AMOEAP, AMONOP)
      ELSEIF (PLOTF(5) .AND. .NOT.FFLAG(5)) THEN
	 WRITE (IU06,*) ' WIND DIRECTIONS ARE NOT IN FILE FOR',
     1                  ' IIDATE = ', IIDATE
      ENDIF
C
C*    3.6 OUTPUT OF MEAN FREQUENCY.
C         -------------------------
C
      IF (PLOTF(6) .AND. FFLAG(3)) THEN
         LIU   = IECF_LEN(NAME(6))
         TITL(1:LIU) = NAME(6)(1:LIU)
         WRITE (TITL(LIU+1:100),'('' IN 0.1 SECONDS '')')
         CONST = 10.
         DO 3600 K=1,NY
         DO 3600 I=1,NX
            IF (WAVEHT(I,K).GT.0.00001) THEN
               WAVEMFR(I,K) = 1./WAVEMFR(i,K)
            ELSE
	       WAVEMFR(I,K) = 999999.
C	       WAVEMFR(I,K) = 9999999999.
	    ENDIF
 3600    CONTINUE
         CALL OUTPP (IIDATE, IU06, TITL, CONST, NX, NY,
     1               WAVEMFR, AMOWEP, AMOSOP, AMOEAP, AMONOP)
      ELSEIF (PLOTF(6) .AND. .NOT.FFLAG(3)) THEN
         WRITE (IU06,*) ' MEAN FREQUENCIES ARE NOT IN FILE FOR',
     1                  ' IIDATE = ', IIDATE
      ENDIF
C
C*    3.7 OUTPUT OF PEAK FREQUENCY.
C         -------------------------
C
      IF (PLOTF(7) .AND. FFLAG(6)) THEN
         LIU   = IECF_LEN(NAME(7))
         TITL(1:LIU) = NAME(7)(1:LIU)
         WRITE (TITL(LIU+1:100),'('' IN 0.1 SECONDS '')')
         CONST = 10.
         DO 3700 K=1,NY
         DO 3700 I=1,NX
            IF (WAVEHT(I,K).GT.0.00001) THEN
               WAVEPFR(I,K) = 1./WAVEPFR(i,K)
            ELSE
	       WAVEPFR(I,K) = 999999.
C	       WAVEPFR(I,K) = 9999999999.
	    ENDIF
 3700    CONTINUE
         CALL OUTPP (IIDATE, IU06, TITL, CONST, NX, NY,
     1               WAVEPFR, AMOWEP, AMOSOP, AMOEAP, AMONOP)
      ELSEIF (PLOTF(7) .AND. .NOT.FFLAG(6)) THEN
         WRITE (IU06,*) ' PEAK FREQUENCIES ARE NOT IN FILE FOR',
     1                  ' IIDATE = ', IIDATE
      ENDIF
C
C*    3.8 OUTPUT OF DRAG COEFFICIENT.
C         ---------------------------
C
      IF (PLOTF(8) .AND. FFLAG(7)) THEN
	 LIU   = IECF_LEN(NAME(8))
	 TITL(1:LIU) = NAME(8)(1:LIU)
	 WRITE (TITL(LIU+1:100),'('' IN 0.1 PROMILLE '')')
	 CONST = 10000.
	 DO 3800 K=1,NY
	 DO 3800 I=1,NX
	    IF (WAVEHT(I,K).LE.0.00001) THEN
	       CD(I,K) = 9999.
C	       CD(I,K) = 9999999999.
	    ENDIF
 3800    CONTINUE
	 CALL OUTPP (IIDATE, IU06, TITL, CONST, NX, NY,
     1               CD     , AMOWEP, AMOSOP, AMOEAP, AMONOP)

      ELSEIF (PLOTF(8) .AND. .NOT.FFLAG(7)) THEN
         WRITE (IU06,*) ' DRAG COEFFICIENTS ARE NOT IN FILE FOR',
     1                  ' IIDATE = ', IIDATE
      ENDIF
C
C*    3.9 OUTPUT OF NORMALIZED WAVE STRESS.
C         ---------------------------------
C
      IF (PLOTF(9) .AND. FFLAG(8)) THEN
         LIU   = IECF_LEN(NAME(9))
         TITL(1:LIU) = NAME(9)(1:LIU)
         WRITE (TITL(LIU+1:100),'('' IN % '')')
         CONST = 100.
         DO 3900 K=1,NY
         DO 3900 I=1,NX
            IF (WAVEHT(I,K).LE.0.00001) THEN
	       WSTRESS(I,K) = 999999.
C	       WSTRESS(I,K) = 9999999999.
	    ENDIF
 3900    CONTINUE
         CALL OUTPP (IIDATE, IU06, TITL, CONST, NX, NY,
     1               WSTRESS, AMOWEP, AMOSOP, AMOEAP, AMONOP)

      ELSEIF (PLOTF(9) .AND. .NOT.FFLAG(8)) THEN
         WRITE (IU06,*) ' WAVE STRESS ARE NOT IN FILE FOR',
     1                  ' IIDATE = ', IIDATE
      ENDIF
C
C*    2.2.7 NEXT OUTPUT TIME.
C           -----------------
C
      IF (NOUTT.EQ.0) THEN
         CALL INCDATE(IDATEP,IDELDO)
      ELSE
	 IIHH = '999999999999'
         DO 2271 I=1,NOUTT
            IF (IOUTT(I).GT.IDATEP) THEN
               IF(IIHH.GT.IOUTT(I)) IIHH=IOUTT(I)
            ENDIF
 2271    CONTINUE
         IDATEP = IIHH
      ENDIF
      IF (IDATEP.LE.IDATEE) GOTO 2200

      STOP
      END
      SUBROUTINE UIPGRID (IU05, IU06, IDS, NAME, PLOTF, NS,
     1                    IDATEA, IDATEE, IDELDO, IDO, NOUTT, IOUTT,
     2                    USERID, RUNID, FILEID, PATH, IDATEF, IDELFI)

C -----------------------------------------------------------------
C
C**** *UIPGRID* - ROUTINE TO READ USER INPUT OF PROG PGRID.
C
C     H. GUNTHER     GKSS/ECMWF     NOVEMBER 1989
C
C*    PURPOSE.
C     --------
C
C       READ USER INPUT CONCERNING PERIOD OF INTEREST,TIMESTEPS AND
C       OPTIONS. A CONSISTENCY CHECK IS DONE TOO.
C
C**   INTERFACE.
C     ----------
C
C       *CALL* *UIPGRID (IU05, IU06, IDS, NAME, PLOTF, NS,
C                        IDATEA, IDATEE, IDELDO, IDO, NOUTT, IOUTT,
C                        USERID, RUNID, FILEID, PATH, IDATEF, IDELFI)*
C          *IU05*    INTEGER    INPUT UNIT OF USER INPUT.
C          *IU06*    INTEGER    PRINTER OUTPUT UNIT.
C          *IDS*     INTEGER    DIMENSION OF ARRAYS
C          *NAME*    CHARACTER  OUTPUT FIELDS TITEL.
C          *PLOTF*   LOGICAL    FIELDS TO BE OUTPUTTED.
C          *NS*      INTEGER    DIMENSION OF ARRAYS USED
C          *IDATEA*  INTEGER    START DATE OF OUTPUT (YYMMDDHHMM)
C          *IDATEE*  INTEGER    END DATE OF OUTPUT (YYMMDDHHMM)
C          *IDELDO*  INTEGER    OUTPUT TIME INCREMENT (SECONDS)
C          *IDO*     INTEGER    DIMENSION OF OUTPUT TIME ARRAY.
C          *NOUTT*   INTEGER    NUMBER OF OUTPUT TIMES.
C          *IOUTT*   INTEGER    OUTPUT TIME ARRAY.
C          *USERID*  CHARACTER  USERID OF INPUT FILES
C          *RUNID*   CHARACTER  RUNID  OF INPUT FILES
C          *FILEID*  CHARACTER  FILE ID OF INPUT FILES
C          *PATH*    CHARACTER  DIRECTORY OF INPUT FILES
C          *IDATEF*  INTEGER    FIRST INPUT FILE DATE (YYMMDDHHMM)
C          *IDELFI*  INTEGER    INPUT FILE DATE INCREMENT (SECONDS)
C
C     METHOD.
C     -------
C
C       USER INFORMATION IS BEING READ WITH THE PRESUMPTIONS THAT:
C         1. EVERY LINE STARTING WITH 'C' IS A COMMENT LINE
C         2. VALUES ARE PUT IN BELOW POSITIONS INDICATED WITH '-'
C            (RIGHT-JUSTIFIED, BUT CHARACTER LEFT-JUSTIFIED)
C
C     EXTERNALS.
C     ----------
C
C       *ABORT*     - TERMINATES PROCESSING.
C
C     REFERENCE.
C     ----------
C
C       NONE.
C
C ------------------------------------------------------------------
C
      CHARACTER USERID*3, RUNID*3, FILEID*3, NAME(IDS)*50, PATH*60
      LOGICAL PLOTF(IDS)
      CHARACTER*12 IOUTT(IDO), IDATEA, IDATEE, IDATEF
      CHARACTER LINE*72
      LOGICAL LERROR
C
C --------------------------------------------------------------------
C
C*    1. READ USER INPUT
C        ---------------
C
      NOUTT  = 0
      ICOUNT = 0
 1000 CONTINUE
      READ(IU05, '(A72)',ERR=4000,END=4000,IOSTAT=IOS) LINE
      IF (LINE(1:1).EQ.'C') GOTO 1000
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.EQ.1) THEN
         READ(LINE( 2:11),'(A10)',ERR=4100,IOSTAT=IOS) IDATEA(1:10)
         IDATEA(11:12)='00'
         READ(LINE(14:23),'(A10)',ERR=4100,IOSTAT=IOS) IDATEE(1:10)
         IDATEE(11:12)='00'
         READ(LINE(26:32),'(I7 )',ERR=4100,IOSTAT=IOS) IDELDO
         IF (LINE(35:35).EQ.'H') IDELDO = IDELDO*3600
         GOTO 1000
      ELSE IF (ICOUNT.EQ.2) THEN
         IF (LINE( 2: 4).NE.'END') THEN
            NOUTT = NOUTT+1
            IF (NOUTT.LE.IDO)
     1        READ(LINE( 2:11),'(A10)',ERR=4100,IOSTAT=IOS) IOUTT(NOUTT)
            ICOUNT = ICOUNT-1
         ELSE
            GOTO 1000
         ENDIF
         IF (LINE(14:16).NE.'END') THEN
            NOUTT = NOUTT+1
            IF (NOUTT.LE.IDO)
     1        READ(LINE(14:23),'(A10)',ERR=4100,IOSTAT=IOS) IOUTT(NOUTT)
         ELSE
            ICOUNT = ICOUNT + 1
            GOTO 1000
         ENDIF
         IF (LINE(26:28).NE.'END') THEN
            NOUTT = NOUTT+1
            IF (NOUTT.LE.IDO)
     1        READ(LINE(26:35),'(A10)',ERR=4100,IOSTAT=IOS) IOUTT(NOUTT)
         ELSE
            ICOUNT = ICOUNT + 1
            GOTO 1000
         ENDIF
         IF (LINE(38:40).NE.'END') THEN
            NOUTT = NOUTT+1
            IF (NOUTT.LE.IDO)
     1        READ(LINE(38:47),'(A10)',ERR=4100,IOSTAT=IOS) IOUTT(NOUTT)
         ELSE
            ICOUNT = ICOUNT + 1
            GOTO 1000
         ENDIF
         IF (LINE(50:52).NE.'END') THEN
            NOUTT = NOUTT+1
            IF (NOUTT.LE.IDO)
     1        READ(LINE(50:59),'(A10)',ERR=4100,IOSTAT=IOS) IOUTT(NOUTT)
         ELSE
            ICOUNT = ICOUNT + 1
            GOTO 1000
         ENDIF
         IF (LINE(62:64).NE.'END') THEN
            NOUTT = NOUTT+1
            IF (NOUTT.LE.IDO)
     1        READ(LINE(62:71),'(A10)',ERR=4100,IOSTAT=IOS) IOUTT(NOUTT)
         ELSE
            ICOUNT = ICOUNT + 1
         ENDIF
         GOTO 1000
      ELSE IF (ICOUNT.EQ.3) THEN
         READ(LINE( 2:11),'(A10)',ERR=4100,IOSTAT=IOS) IDATEF(1:10)
         IDATEF(11:12)='00'
         READ(LINE(14:20),'(I7 )',ERR=4100,IOSTAT=IOS) IDELFI
         IF (LINE(23:23).EQ.'H') IDELFI = IDELFI*3600
         USERID = LINE(26:28)
         GOTO 1000
      ELSE IF (ICOUNT.EQ.4) THEN
         RUNID  = LINE( 2: 4)
         FILEID = LINE( 7: 9)
         PATH   = LINE(12:71)
         GOTO 1000
      ELSE IF(ICOUNT.GT.4) THEN
	 IF (LINE( 2: 4).EQ.'END') GOTO 2000
	 IF (NS.EQ.IDS) THEN
            WRITE(IU06,*) '++++++++++++++++++++++++++++++++++++++++++++'
            WRITE(IU06,*) '+                                          +'
            WRITE(IU06,*) '+      WARNING ERROR IN SUB. UIPGRID       +'
            WRITE(IU06,*) '+      =============================       +'
            WRITE(IU06,*) '+ NUMBER OF OUTPUT TYPES EXCEEDS DIMENSION +'
            WRITE(IU06,*) '+ THE FIRST ', NS, 'TYPES ARE EXECUTED'
            WRITE(IU06,*) '+                                          +'
            WRITE(IU06,*) '+ CHECK INPUT OR CHANGE DIMENSION IN MAIN  +'
            WRITE(IU06,*) '+ PROGRAM                                  +'
            WRITE(IU06,*) '++++++++++++++++++++++++++++++++++++++++++++'
            GOTO 2000
         ENDIF
         NS = NS + 1
         NAME(NS) = LINE( 2:51)
         IF (LINE(54:54).NE.'F'.AND. LINE(54:54).NE.'T') THEN
            WRITE(IU06,*) '++++++++++++++++++++++++++++++++++++++++++++'
            WRITE(IU06,*) '+                                          +'
            WRITE(IU06,*) '+      WARNING ERROR IN SUB. UIPGRID       +'
            WRITE(IU06,*) '+      =============================       +'
            WRITE(IU06,*) '+ OUTPUT REQUEST FLAG IN INPUT LINE        +'
            WRITE(IU06,*) '+ ',LINE
            WRITE(IU06,*) '+ IS NOT F OR T.                           +'
            WRITE(IU06,*) '+ CHECK INPUT                              +'
            WRITE(IU06,*) '+ PROGRAM CHANGES TO FALSE                 +'
            WRITE(IU06,*) '++++++++++++++++++++++++++++++++++++++++++++'
            LINE(54:54) = 'F'
         ENDIF
         READ(LINE(54:54),'(L1)',ERR=4100,IOSTAT=IOS) PLOTF(NS)
         GOTO 1000
      ENDIF
C
C     2. PRINT USER INPUT
C        ----------------
 2000 CONTINUE
      WRITE(IU06,'(1H1)')
      WRITE(IU06,*) ' USER INPUT:'
      WRITE(IU06,*) '  '
      IF (NOUTT.EQ.0) THEN
         WRITE(IU06,*) ' START  DATE (FORMAT:YYMMDDHHMMSS) : ',IDATEA,
     1                 ' END DATE :',IDATEE
         WRITE(IU06,*) '  '
         WRITE(IU06,*) ' OUTPUT EVERY ',IDELDO ,' SECONDS'
      ELSE
         WRITE(IU06,*) ' FIELDS ARE PRINTED AT:'
         WRITE(IU06,'((1X,6(A10,2X)))')  (IOUTT(I),I=1,NOUTT)
      ENDIF
      WRITE(IU06,*) '  '
      WRITE(IU06,*) ' DATA WILL BE FETCHED FROM:'
      WRITE(IU06,*) ' USER ID IS ..................... ', USERID
      WRITE(IU06,*) ' RUN  ID IS ..................... ', RUNID
      WRITE(IU06,*) ' FILE ID IS ..................... ', FILEID
      WRITE(IU06,*) ' DIRECTORY NAME IS .............. ', PATH
      WRITE(IU06,*) ' THE FIRST FILE DATE IS ......... ', IDATEF
      WRITE(IU06,*) ' A NEW FILE WILL BE FETCHED EVERY ', IDELFI,
     1              ' SECONDS'
      WRITE(IU06,*) '  '
      WRITE(IU06,*) ' LIST OF OUTPUTS TO BE GENERATED:'
      WRITE(IU06,*) '  '
      DO 2100 I=1,NS
         IF (PLOTF(I))  WRITE(IU06,'(1X,A50)') NAME(I)
 2100 CONTINUE
C
C*    3. CHECK CONSISTENCY OF INPUT DATA
C        -------------------------------
C
      IF (NOUTT.EQ.0 .AND. IDATEE.LT.IDATEA) THEN
         WRITE(IU06,*) '*******************************************'
         WRITE(IU06,*) '*                                         *'
         WRITE(IU06,*) '*    FATAL ERROR IN SUB. UIPGRID          *'
         WRITE(IU06,*) '*    ===========================          *'
         WRITE(IU06,*) '* END DATE IS BEFORE START DATE           *'
         WRITE(IU06,*) '* START DATE = ', IDATEA
         WRITE(IU06,*) '* END  DATE  = ', IDATEE
         WRITE(IU06,*) '*                                         *'
         WRITE(IU06,*) '* CORRECT USER INPUT                      *'
         WRITE(IU06,*) '*                                         *'
         WRITE(IU06,*) '* PROGRAM ABORTS.   PROGRAM ABORTS.       *'
         WRITE(IU06,*) '*                                         *'
         WRITE(IU06,*) '*******************************************'
         CALL ABORT
      ENDIF

      RETURN
C
C*    4. READ ERROR MESSAGES
C        -------------------
C
 4000 CONTINUE
         WRITE(IU06,*) ' ********************************************'
         WRITE(IU06,*) ' *                                          *'
         WRITE(IU06,*) ' *     FATAL ERROR IN SUB. UIPGRID          *'
         WRITE(IU06,*) ' *     ===========================          *'
         WRITE(IU06,*) ' * READ ERROR ON INPUT FILE:                *'
         WRITE(IU06,*) ' * ERROR IS LATER THAN ICOUNT = ', ICOUNT
         WRITE(IU06,*) ' * LAST LINE READ IS     LINE = ', LINE
         WRITE(IU06,*) ' *                                          *'
         WRITE(IU06,*) ' *   PROGRAM ABORTS  PROGRAM ABORTS         *'
         WRITE(IU06,*) ' *                                          *'
         WRITE(IU06,*) ' ********************************************'
         CALL ABORT
 4100 CONTINUE
         WRITE(IU06,*) ' ********************************************'
         WRITE(IU06,*) ' *                                          *'
         WRITE(IU06,*) ' *     FATAL ERROR IN SUB. UIPGRID          *'
         WRITE(IU06,*) ' *     ===========================          *'
         WRITE(IU06,*) ' * READ ERROR ON CHARACTER STRING           *'
         WRITE(IU06,*) ' * ERROR IS IN DATA LINE ICOUNT = ', ICOUNT
         WRITE(IU06,*) ' * CHARACTER STRING IS   LINE = ', LINE
         WRITE(IU06,*) ' *                                          *'
         WRITE(IU06,*) ' *   PROGRAM ABORTS  PROGRAM ABORTS         *'
         WRITE(IU06,*) ' *                                          *'
         WRITE(IU06,*) ' ********************************************'
         CALL ABORT

      END
