SUBROUTINE wsmfen (fsea, ew, fm, ustt)  
!----------------------------------------------------------------------
!**** *WSMFEN* - COMPUTES MEAN FREQUENCY AND ENERGY OF THE WINDSEA
!****            SPECTRUM.
!     --------
!       COMPUTES MEAN FREQUENCY AND ENERGY OF THE WINDSEA SPECTRUM.
!**   INTERFACE.
!     ----------
!        *FSEA*   REAL     WINDSEA PART OF THE WAVE SPECTRUM.
!        *EW*     REAL     WINDSEA ENERGY .
!        *FM*     REAL     MEAN FREQUENCY OF THE WINDSEA.
!        *USTT*   REAL     FRICTION VELOCITY.
!     METHOD.
!     -------
!       ENERGY AND MEAN FREQUENCY ARE FIRST COMPUTED BY INTEGRATION
!       OF THE WINDSEA PART OF THE SPECTRUM:
!       THIS IMPLIES AN UNDERESTIMATION BOTH OF ENERGY AND MEAN
!       FREQUENCY. THE UNDERESTIMATED VALUES ARE USED IN THE GROWTH
!       CURVE PRODUCING OVERSTIMATES OF BOTH ENERGY AND MEAN FREQUENCY.
!       THE AVERAGE OF THE TWO ESTIMATES IS TAKEN TO PROVIDE A BEST
!       ESTIMATE.
! ----------------------------------------------------------------------
use params
use fredir
implicit none

REAL, INTENT(IN)  :: fsea(nang,nfre), ustt
REAL, INTENT(OUT) :: ew, fm
REAL, PARAMETER :: EPSMIN = 0.1E-32, FRATIO = 1.1
REAL, PARAMETER :: G = 9.806
REAL, PARAMETER :: AF = 0.000168, BF = - 3.27
!       *AF*   REAL   PARAMETER OF THE ENERGY - MEAN FREQUENCY RELATION.
!       *BF*   REAL   PARAMETER OF THE ENERGY - MEAN FREQUENCY RELATION.
REAL    :: X, EN,  YNU, SPFB, XTEMP, DELT25, TEMP, SPINTDI, FREQDI
INTEGER :: K, M
! ----------------------------------------------------------------------
!     INLINE FUNCTIONS.
!     -----------------
!     ENERGY AS FUNCTION OF MEAN FREQUENCY.
EN (X) = AF * X**BF  
!     MEAN FREQUENCY AS FUNCTION OF ENERGY.
YNU (X) = (X / AF) ** (1. / BF)  
! ----------------------------------------------------------------------
!*    1. INTEGRATING THE WINDSEA PART OF THE SPECTRUM.
!*       (UNDERESTIMATE IS IMPLIED)
!        ---------------------------------------------
!*    1.1 COMPUTATION OF THE WIND-SEA ENERGY.
!         -----------------------------------
EW = EPSMIN  
DO M = 1, NFRE  
   TEMP = 0.  
   DO K = 1, NANG  
      TEMP = TEMP + FSEA (K, M)  
   ENDDO  
   EW = EW + TEMP * DFIM (M)  
ENDDO  
DELT25 = FR (NFRE) / 3. * DELTH  
EW = EW + DELT25 * TEMP  
!*    1.2 COMPUTATION OF THE MEAN FREQUENCY.
!         ----------------------------------
FM = EPSMIN  
DO M = 1, NFRE  
   SPFB = 0.  
   DO K = 1, NANG  
      SPFB = SPFB + FSEA (K, M)  
   ENDDO  
   SPFB = SPFB * DELTH  
   FM = FM + SPFB * FR (M) **2. * (FRATIO - 1. / FRATIO) / 2.  
ENDDO  
FM = FM + SPFB * FR (NFRE) **2. / 3.  
FM = FM / EW  
! ----------------------------------------------------------------------
!*    2. ESTIMATES FROM MODEL RELATIONS.
!        -------------------------------
!*    2.1 ENERGY IS DERIVED FROM UNDERESTIMATED MEAN FREQUENCY.
!         -----------------------------------------------------
XTEMP = FM * USTT / G  
IF (XTEMP.LE.0.) WRITE ( *, * ) FM, USTT, EW  
SPINTDI = USTT**4 / G**2 * EN (FM * USTT / G)  
!*    2.2 MEAN FREQUENCY IS DERIVED FROM THE UNDERESTIMATED ENERGY.
!         ---------------------------------------------------------
FREQDI = G / USTT * YNU (EW * G**2 / USTT**4)  
! ----------------------------------------------------------------------
!*    3. FINAL ESTIMATE.
!        ---------------
!*    3.1 AVERAGING THE ENERGY ESTIMATES.
!         -------------------------------
EW = (EW + SPINTDI) * 0.5  
!*    3.2 AVERAGING THE MEAN FREQUENCY ESTIMATES.
!         ---------------------------------------
FM = (FM + FREQDI) * 0.5  

RETURN  
END SUBROUTINE wsmfen
