SUBROUTINE wavenumber(f, cpp)
! ----------------------------------------------------------------------
!**** *WAVENUMBER at peak frequency* - COMPUTATION AT EACH GRID POINT.
! ----------------------------------------------------------------------
use params
use fredir ; use shallow
implicit none
INCLUDE 'globals.h'

REAL   , INTENT(IN) :: f(0:niblo,nang,nfre)
REAL   , INTENT(OUT):: cpp(niblo)
REAL PEAKF,WFREQP
REAL :: temp1, temp2,x1,z1
INTEGER :: K, M, IJ
! ----------------------------------------------------------------------
!        -----------------
!*    2. LOOP OVER FREQUENCIES
!        ---------------------
DO IJ = 1,NIBLO
 TEMP1 = 0.0
 DO M = 1, NFRE
!*    2.1 COMPUTE 1-D SPECTRUM (WITHOUT DELTA THETA)
!        -------------------------------------------
   TEMP2 = 0.0
   DO K = 1, NANG
         TEMP2  = TEMP2  + F (IJ, K, M)
   END DO
!*    2.2 DEFINE PEAK FREQUENCY
!         ---------------------
      IF (TEMP1  .LT.TEMP2  ) THEN
         TEMP1  = TEMP2 
         PEAKF  = FR (M)
      ENDIF
 END DO
       WFREQP=ZPI*PEAKF
       X1 = WFREQP*WFREQP*DEPTH(IJ,1)/G
         Z1 = 0.1608+X1*(0.06321+X1*(0.02744+X1*0.01))
         Z1 = (1.0+X1*(0.6667+X1*(0.3556+X1*Z1)))**(-1)
         CPP(IJ) = SQRT(G*DEPTH(IJ,1))/SQRT(X1+Z1)
END DO

RETURN
END SUBROUTINE wavenumber
