SUBROUTINE wamwnd (us, ds, uwnd, vwnd, nc, nr, it1, it2, us_eta, z0_eta)  
! ----------------------------------------------------------------------
!**** *WAMWND* - TRANSFORMS INPUT WINDS TO BLOCKED WAM POINTS.
!*    PURPOSE.
!     --------
!       INTERPOLATE AND CONVERT INPUT WINDS TO WAM WINDS FOR ALL
!       POINTS IN THE GRID.
!**   INTERFACE.
!     ----------
!       *CALL WAMWND (US, DS, UWND, VWND, NC, NR)*
!          *US*   - INTERPOLATED WINDS IN ALL POINTS AND BLOCKS.
!          *DS*   - INTERPOLATED WIND DIRECTION IN ALL POINTS.
!          *UWND* - INPUT WIND : U COMPONENT.
!          *VWND* - INPUT WIND : V COMPONENT.
!          *NC*   - DIMENSION OF IN INPUT WIND ARRAYS (COLUMNS).
!          *NR*   - DIMENSION OF IN INPUT WIND ARRAYS (ROWS).
!     METHOD.
!     -------
!       THE INPUT WINDS ARE INTERPOLATED TO THE WAVE MODEL GRID POINTS
!       IN BLOCKED FORMAT. THE INTERPOLATED VALUES ARE TRANSFORMED TO
!       MAGNITUDE AND DIRECTION. INPUT MAY BE WIND IN 10M HEIGHT ,
!       SURFACE WINDS OR FRICTION VELOCETIES. THE INPUT GRID HAS TO BE
!       A LATITUDE/LONGITUDE GRID EITHER PERIODIC OR NON PERIODIC.
!     EXTERNALS.
!     ----------
!       *LOCINT*    - LOCATES WAM POINT IN INPUT GRID AND INTERPOLATES.
! ----------------------------------------------------------------------
use params
use gridpar
use testo
use wndgrd
implicit none

REAL, INTENT(OUT)    :: us(niblo,nblo), ds(niblo,nblo)
REAL, INTENT(IN OUT) :: uwnd(nc,nr), vwnd(nc,nr)
REAL, INTENT(IN OUT) :: us_eta(nc,nr), z0_eta(nc,nr)
INTEGER*4, INTENT(IN)  :: nc, nr, it1, it2  !cpk-i4 instead of -i8
REAL ,PARAMETER :: ROAIR = 1.225
REAL, PARAMETER :: XKAPPA = 0.41, ALPHACH = 0.0185
INCLUDE'globals.h'
INTEGER :: IJ
REAL    :: CD, UU, VV, Z0, USTAR
! ----------------------------------------------------------------------
!*    1. INITIALISE WIND ARRAYS WITH ZERO
!        --------------------------------
! 1000 CONTINUE
DO IJ = IT1, IT2
   US (IJ, 1) = 0.
   DS (IJ, 1) = 0.
END DO
! ----------------------------------------------------------------------
!*    2. INTERPOLATE INPUT WINDS TO WAVEMODEL GRID.
!        ------------------------------------------
! 2000 CONTINUE
!*    2.1 INTERPOLATE ONE BLOCK IN SPACE.
!         ------------------------------
CALL LOCINT (1, IT1, IT2, NC, NR, KCOL, KROW, IWPER, DLAM, DPHI, &
 RLONL, RLATS, UWND, VWND, US (1, 1), DS (1, 1) )
! ----------------------------------------------------------------------
!*    3. PROCESS WINDS ACCORDING TO TYPE
!        NOTHING TO DO FOR WIND SPEED U10 (ICODE = 3).
!        ---------------------------------------------
! 3000 CONTINUE
!*    3.1 TRANSFORM TO MAGNITUDE AND DIRECTION.
!         -------------------------------------
DO IJ = IT1, IT2
   UU = US (IJ, 1)
   VV = DS (IJ, 1)
   US (IJ, 1) = SQRT (UU**2 + VV**2)
   IF (US (IJ, 1) .NE.0.) DS (IJ, 1) = ATAN2 (UU, VV)
   IF (DS (IJ, 1) .LT.0.) DS (IJ, 1) = DS (IJ, 1) + ZPI
   US(IJ,1)=MAX(US(IJ,1),1.0)
END DO
IF (ICODE.EQ.1) THEN
!*    3.2  INPUT IS FRICTION VELOCITY.
!          ---------------------------
   DO IJ = IT1, IT2
      USTAR = MAX (0.01, US (IJ, 1) )
      Z0 = ALPHACH / G * USTAR**2
      CD = XKAPPA / ALOG (10. / Z0)
      US (IJ, 1) = USTAR / CD
   END DO
ELSEIF (ICODE.EQ.2) THEN
!*    3.3 INPUT WINDS ARE SURFACE STRESSES.
!         ---------------------------------
   DO IJ = IT1, IT2
      USTAR = MAX (0.01, SQRT (US (IJ, 1) / ROAIR) )
      Z0 = ALPHACH / G * USTAR**2
      CD = XKAPPA / ALOG (10. / Z0)
      US (IJ, 1) = USTAR / CD
   END DO
ENDIF
!*    4. TEST OUTPUT OF WAVE MODEL BLOCKS
!        ---------------------------------
4000 CONTINUE

RETURN
END SUBROUTINE wamwnd
