SUBROUTINE userin (iu05, ibounc, ibounf)  
! ----------------------------------------------------------------------
!**** *USERIN* - ROUTINE TO READ AND WRITE USER INPUT.
!     H. GUNTHER     GKSS/ECMWF     NOVEMBER 1989
!*    PURPOSE.
!     --------
!       READ USER INPUT CONCERNING PERIOD OF INTEREST,TIMESTEPS AND
!       MODEL OPTIONS TO INITIALIZE COMMON USERD. A CONSISTENCY CHECK
!       IS DONE TOO.
!**   INTERFACE.
!     ----------
!       *CALL* *USERIN (IU05, IBOUNC, IBOUNF)*
!          *IU05*   -  INPUT UNIT USER INPUT FILE.
!          *IBOUNC* -  COARSE GRID BOUNDARY FLAG.
!          *IBOUNF* -  FINE GRID BOUNDARY FLAG.
!     METHOD.
!     -------
!        USER INFORMATION IS BEING READ WITH THE PRESUMPTIONS THAT:
!         1. EVERY LINE STARTING WITH 'C' IS A COMMENT LINE
!         2. VALUES ARE PUT IN BELOW POSITIONS INDICATED WITH '-'
!            (RIGHT-JUSTIFIED)
!     EXTERNALS.
!     ----------
!       *ABORT*     - TERMINATES PROCESSING.
!       *DIFDATE*   - COMPUTES A TIME DIFFERENCE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params  
use cout
use stat
use idfout
use idfout1
use testo
use text
use units
implicit none

INTEGER, INTENT(IN) :: iu05
INTEGER, INTENT(OUT):: ibounc, ibounf
LOGICAL  :: LERROR
CHARACTER:: LINE * 72, HEADER * 70
INTEGER  :: I, J, IOS, ICOUNT, ISHIFT
! ----------------------------------------------------------------------
!*    1. READ USER INPUT.
!        ----------------
ICOUNT = 0  
NOUTT = 0  
 1000 CONTINUE  
READ (IU05, '(A72)', ERR = 4000, END = 4000, IOSTAT = IOS) LINE  
IF (LINE (1:1) .EQ.'C') GOTO 1000  
ICOUNT = ICOUNT + 1  
IF (ICOUNT.EQ.1) THEN  
   HEADER = LINE (1:70)  
   GOTO 1000  
ELSEIF (ICOUNT.EQ.2) THEN  
   IDATEA (1:10) = LINE (2:11)  
   IDATEA (11:12) = '00'  
! ISKA 21/4/98 IDTOUT INIT
   IDTOUT = IDATEA  
   IDATEE (1:10) = LINE (14:23)  
   IDATEE (11:12) = '00'  
   GOTO 1000  
ELSEIF (ICOUNT.EQ.3) THEN  
   READ (LINE (2:8) , '(I7)', ERR = 4100, IOSTAT = IOS) IDELPRO  
   IF (LINE (10:10) .EQ.'H') IDELPRO = IDELPRO * 3600  
   READ (LINE (13:19) , '(I7)', ERR = 4100, IOSTAT = IOS) IDELT  
   IF (LINE (21:21) .EQ.'H') IDELT = IDELT * 3600  
   READ (LINE (24:30) , '(I7)', ERR = 4100, IOSTAT = IOS) IDELWO  
   IF (LINE (32:32) .EQ.'H') IDELWO = IDELWO * 3600  
   READ (LINE (35:41) , '(I7)', ERR = 4100, IOSTAT = IOS) IDELWI  
   IF (LINE (43:43) .EQ.'H') IDELWI = IDELWI * 3600  
   GOTO 1000  
ELSEIF (ICOUNT.EQ.4) THEN  
   READ (LINE (2:8) , '(I7)', ERR = 4100, IOSTAT = IOS) IDELINT  
   IF (LINE (10:10) .EQ.'H') IDELINT = IDELINT * 3600  
   READ (LINE (13:19) , '(I7)', ERR = 4100, IOSTAT = IOS) IDELINS  
   IF (LINE (21:21) .EQ.'H') IDELINS = IDELINS * 3600  
   READ (LINE (24:30) , '(I7)', ERR = 4100, IOSTAT = IOS) IDELSPT  
   IF (LINE (32:32) .EQ.'H') IDELSPT = IDELSPT * 3600  
   READ (LINE (35:41) , '(I7)', ERR = 4100, IOSTAT = IOS) IDELSPS  
   IF (LINE (43:43) .EQ.'H') IDELSPS = IDELSPS * 3600  
   READ (LINE (46:52) , '(I7)', ERR = 4100, IOSTAT = IOS) IDELRES  
   IF (LINE (54:54) .EQ.'H') IDELRES = IDELRES * 3600  
   GOTO 1000  
ELSEIF (ICOUNT.EQ.5) THEN  
   IF (LINE (2:4) .NE.'END') THEN  
      NOUTT = NOUTT + 1  
      IF (NOUTT.LE.MOUTT) IOUTT (NOUTT) = LINE (2:11)  
      ICOUNT = ICOUNT - 1  
   ELSE  
      GOTO 1000  
   ENDIF  
   IF (LINE (14:16) .NE.'END') THEN  
      NOUTT = NOUTT + 1  
      IF (NOUTT.LE.MOUTT) IOUTT (NOUTT) = LINE (14:23)  
   ELSE  
      ICOUNT = ICOUNT + 1  
      GOTO 1000  
   ENDIF  
   IF (LINE (26:28) .NE.'END') THEN  
      NOUTT = NOUTT + 1  
      IF (NOUTT.LE.MOUTT) IOUTT (NOUTT) = LINE (26:35)  
   ELSE  
      ICOUNT = ICOUNT + 1  
      GOTO 1000  
   ENDIF  
   IF (LINE (38:40) .NE.'END') THEN  
      NOUTT = NOUTT + 1  
      IF (NOUTT.LE.MOUTT) IOUTT (NOUTT) = LINE (38:47)  
   ELSE  
      ICOUNT = ICOUNT + 1  
      GOTO 1000  
   ENDIF  
   IF (LINE (50:52) .NE.'END') THEN  
      NOUTT = NOUTT + 1  
      IF (NOUTT.LE.MOUTT) IOUTT (NOUTT) = LINE (50:59)  
   ELSE  
      ICOUNT = ICOUNT + 1  
      GOTO 1000  
   ENDIF  
   IF (LINE (62:64) .NE.'END') THEN  
      NOUTT = NOUTT + 1  
      IF (NOUTT.LE.MOUTT) IOUTT (NOUTT) = LINE (62:71)  
   ELSE  
      ICOUNT = ICOUNT + 1  
   ENDIF  
   GOTO 1000  
ELSEIF (ICOUNT.EQ.6) THEN  
   IF (LINE (2:2) .EQ.'Y') PFLAG (1) = .TRUE.  
   IF (LINE (4:4) .EQ.'Y') FFLAG (1) = .TRUE.  
   IF (LINE (40:40) .EQ.'Y') PFLAG (2) = .TRUE.  
   IF (LINE (42:42) .EQ.'Y') FFLAG (2) = .TRUE.  
   READ (IU05, '(A72)', ERR = 4000, END = 4000, IOSTAT = IOS) LINE
   IF (LINE (2:2) .EQ.'Y') PFLAG (3) = .TRUE.  
   IF (LINE (4:4) .EQ.'Y') FFLAG (3) = .TRUE.  
   IF (LINE (40:40) .EQ.'Y') PFLAG (4) = .TRUE.  
   IF (LINE (42:42) .EQ.'Y') FFLAG (4) = .TRUE.  
   READ (IU05, '(A72)', ERR = 4000, END = 4000, IOSTAT = IOS) LINE
   IF (LINE (2:2) .EQ.'Y') PFLAG (5) = .TRUE.  
   IF (LINE (4:4) .EQ.'Y') FFLAG (5) = .TRUE.  
   IF (LINE (40:40) .EQ.'Y') PFLAG (6) = .TRUE.  
   IF (LINE (42:42) .EQ.'Y') FFLAG (6) = .TRUE.  
   READ (IU05, '(A72)', ERR = 4000, END = 4000, IOSTAT = IOS) LINE
   IF (LINE (2:2) .EQ.'Y') PFLAG (7) = .TRUE.  
   IF (LINE (4:4) .EQ.'Y') FFLAG (7) = .TRUE.  
   IF (LINE (40:40) .EQ.'Y') PFLAG (8) = .TRUE.  
   IF (LINE (42:42) .EQ.'Y') FFLAG (8) = .TRUE.  
   READ (IU05, '(A72)', ERR = 4000, END = 4000, IOSTAT = IOS) LINE
   IF (LINE (2:2) .EQ.'Y') PFLAG (9) = .TRUE.  
   IF (LINE (4:4) .EQ.'Y') FFLAG (9) = .TRUE.  
   IF (LINE (40:40) .EQ.'Y') PFLAG (10) = .TRUE.  
   IF (LINE (42:42) .EQ.'Y') FFLAG (10) = .TRUE.  
   READ (IU05, '(A72)', ERR = 4000, END = 4000, IOSTAT = IOS) LINE
   IF (LINE (2:2) .EQ.'Y') PFLAG (11) = .TRUE.  
   IF (LINE (4:4) .EQ.'Y') FFLAG (11) = .TRUE.  
   IF (LINE (40:40) .EQ.'Y') PFLAG (12) = .TRUE.  
   IF (LINE (42:42) .EQ.'Y') FFLAG (12) = .TRUE.  
   READ (IU05, '(A72)', ERR = 4000, END = 4000, IOSTAT = IOS) LINE
   IF (LINE (2:2) .EQ.'Y') PFLAG (13) = .TRUE.  
   IF (LINE (4:4) .EQ.'Y') FFLAG (13) = .TRUE.  
   IF (LINE (40:40) .EQ.'Y') PFLAG (14) = .TRUE.  
   IF (LINE (42:42) .EQ.'Y') FFLAG (14) = .TRUE.  
   GOTO 1000  
ELSEIF (ICOUNT.EQ.7) THEN  
   READ (LINE (2:8) , '(I7)', ERR = 4100, IOSTAT = IOS) ICASE  
   READ (LINE (11:17) , '(I7)', ERR = 4100, IOSTAT = IOS) ISHALLO  
   READ (LINE (20:26) , '(I7)', ERR = 4100, IOSTAT = IOS) IREFRA  
   READ (LINE (29:35) , '(I7)', ERR = 4100, IOSTAT = IOS) ITEST  
   READ (LINE (38:44) , '(I7)', ERR = 4100, IOSTAT = IOS) ITESTB  
   READ (LINE (47:53) , '(I7)', ERR = 4100, IOSTAT = IOS) IREST  
   GOTO 1000  
ELSEIF (ICOUNT.EQ.8) THEN  
   READ (LINE (2:8) , '(I7)', ERR = 4100, IOSTAT = IOS) IBOUNC  
   READ (LINE (11:17) , '(I7)', ERR = 4100, IOSTAT = IOS) IBOUNF  
   GOTO 1000  
ELSEIF (ICOUNT.EQ.9) THEN  
   USERID = LINE (2:4)  
   RUNID = LINE (7:9)  
   PATH = LINE (12:71)  
ENDIF  

!*    1.1 CHECK NUMBER OF OUTPUT TIMES.
!         -----------------------------
IF (NOUTT.GT.MOUTT) THEN  
   WRITE(IU06,*) '+++++++++++++++++++++++++++++++++++++++++++++'  
   WRITE(IU06,*) '+                                           +'  
   WRITE(IU06,*) '+    WARNING ERROR IN SUB. USERIN           +'  
   WRITE(IU06,*) '+    ============================           +'  
   WRITE(IU06,*) '+ NUMBER OF OUTPUT TIMES IN INPUT EXCEEDS   +'  
   WRITE(IU06,*) '+ DIMENSION MOUTT                = ', MOUTT  
   WRITE(IU06,*) '+ NUMBER OF TIMES INPUT IS NOUTT = ', NOUTT  
   WRITE(IU06,*) '+ PROGRAM WILL IGNORE THE LAST OUTPUT TIMES +'  
   WRITE(IU06,*) '+                                           +'  
   WRITE(IU06,*) '+++++++++++++++++++++++++++++++++++++++++++++'  
   NOUTT = MOUTT  
ENDIF  
!*    1.2  PRINT INITIAL CONDITIONS.
!          -------------------------
WRITE (IU06, '(1H1)')  
WRITE (IU06, '(1H0,A70)') HEADER  
WRITE (IU06,  * ) '  '  
WRITE (IU06,  * ) ' STARTING  DATE (FORMAT:YYMMDDHHMM) : ', IDATEA &
&, ' END DATE :', IDATEE
WRITE (IU06,  * ) '  '  
WRITE (IU06, * ) ' MODEL TIME STEPS:'  
WRITE (IU06, * ) ' SOURCE TERM INTEGRATION TIME STEP : ', IDELT,' SECS'
WRITE (IU06, * ) ' PROPAGATION TIME STEP ............: ', IDELPRO,' SECS'
WRITE (IU06, * ) ' MODEL WIND INPUT TIME STEP .......: ', IDELWI, ' SECS'
WRITE (IU06, * ) ' MODEL WIND OUTPUT TIME STEP.......: ', IDELWO, ' SECS'
WRITE (IU06,  * ) '  '  
WRITE (IU06, * ) ' MODEL OPTIONS:'  
IF (ICASE.EQ.1) THEN  
   WRITE (IU06,  * ) ' PROPAGATION GRID SPHERICAL LAT/LON COORDINATES'
ELSE  
   WRITE (IU06, * ) ' PROPAGATION GRID CARTESIAN COORDINATES'  
ENDIF  
IF (ISHALLO.EQ.1) THEN  
   WRITE (IU06, * ) ' THIS IS A DEEP WATER RUN '  
ELSE  
   WRITE (IU06, * ) ' THIS IS A SHALLOW WATER RUN '  
ENDIF  
IF (IREFRA.EQ.0) THEN  
   WRITE (IU06, * ) ' MODEL RUNS WITHOUT REFRACTION'  
ELSEIF (IREFRA.EQ.1) THEN  
   WRITE (IU06, * ) ' MODEL RUNS WITH DEPTH REFRACTION'  
ELSEIF (IREFRA.EQ.2) THEN  
WRITE (IU06,  * ) ' MODEL RUNS WITH DEPTH AND CURRENT REFRACTION'  
ENDIF  
IF (IDELWO.GE.IDELWI) THEN  
   WRITE (IU06, * ) ' WIND FIELD ARE NOT INTERPOLATED IN TIME'  
ELSE  
   WRITE (IU06, * ) ' WIND FIELD ARE INTERPOLATED IN TIME'  
ENDIF  
IF (IBOUNC.EQ.1) THEN  
WRITE (IU06,  * ) ' MODEL RUNS WITH BOUNDARY POINTS (COURSE GRID)'  
   WRITE (IU06, * ) ' NUMBER OF NESTS OUTPUT:', NESTS  
ELSE  
WRITE (IU06,  * ) ' MODEL RUNS WITHOUT BOUNDARY POINTS', ' (COURSE &
& GRID)'
ENDIF  
IF (IBOUNF.EQ.1) THEN  
WRITE (IU06,  * ) ' MODEL RUNS WITH BOUNDARY POINTS (FINE GRID)'  
ELSE  
WRITE (IU06,  * ) ' MODEL RUNS WITHOUT BOUNDARY POINTS', ' (FINE G &
&RID)'
ENDIF  
WRITE (IU06,  * ) '  '  
WRITE (IU06, * ) ' MODEL OUTPUT SELECTION:'  
WRITE (IU06,  * ) '  '  
IF (NOUTT.GT.0) THEN  
   WRITE (IU06, * ) ' NUMBER OF OUTPUT TIMES IS NOUTT = ', NOUTT  
   WRITE (IU06, * ) ' OUTPUT WILL BE PROCESSED AT:'  
   WRITE (IU06, '(6(2X,A10))') (IOUTT (I) , I = 1, NOUTT)  
WRITE (IU06,  * ) '  '  
   WRITE (IU06, * ) ' TO PRINTER AND/OR UNIT IU20 = ', IU20  
ELSE  
WRITE (IU06,  * ) ' TO PRINTER AND/OR UNIT IU20 = ', IU20, ' EVERY &
& ', IDELINT, ' SECONDS'
ENDIF  
WRITE (IU06,  * ) '    F = FALSE   T = TRUE '  
WRITE (IU06,  * ) '                        PRINTER  UNIT'  
WRITE (IU06, * ) ' SIGNIFICANT WAVE HEIGHT ..', PFLAG (1) , &
 '......', FFLAG (1)
WRITE (IU06, * ) ' MEAN WAVE DIRECTION ......', PFLAG (2) , &
 '......', FFLAG (2)
WRITE (IU06, * ) ' WAVE MEAN FREQUENCY ......', PFLAG (3) , &
 '......', FFLAG (3)
WRITE (IU06, * ) ' FRICTION VELOCITY ........', PFLAG (4) , &
 '......', FFLAG (4)
WRITE (IU06, * ) ' WIND DIRECTION ...........', PFLAG (5) , &
 '......', FFLAG (5)
WRITE (IU06, * ) ' WAVE PEAK FREQUENCY ......', PFLAG (6) , &
 '......', FFLAG (6)
WRITE (IU06, * ) ' DRAG COEFFICIENT .........', PFLAG (7) , &
 '......', FFLAG (7)
WRITE (IU06, * ) ' NORMALISED WAVE STRESS ...', PFLAG (8) , &
 '......', FFLAG (8)
WRITE (IU06,  * ) '  '  
IF (NOUTT.GT.0) THEN  
   WRITE (IU06, * ) ' TO PRINTER AND/OR UNIT IU21 = ', IU21  
ELSE  
WRITE (IU06,  * ) ' TO PRINTER AND/OR UNIT IU21 = ', IU21, ' EVERY &
& ', IDELINS, ' SECONDS'
ENDIF  
WRITE (IU06,  * ) '                        PRINTER  UNIT'  
WRITE (IU06, * ) ' SWELL WAVE HEIGHT ........', PFLAG (9) , &
 '......', FFLAG (9)
WRITE (IU06, * ) ' SWELL DIRECTION ..........', PFLAG (10) , &
 '......', FFLAG (10)
WRITE (IU06, * ) ' WIND WAVE DIRECTION ......', PFLAG (11) , &
 '......', FFLAG (11)
WRITE (IU06, * ) ' SWELL MEAN FREQUENCY .....', PFLAG (12) , &
 '......', FFLAG (12)
WRITE (IU06,  * ) '  '  
IF (NOUTT.GT.0) THEN  
   WRITE (IU06, * ) ' TO PRINTER AND/OR UNIT IU25 = ', IU25  
ELSE  
WRITE (IU06,  * ) ' TO PRINTER AND/OR UNIT IU25 = ', IU25, ' EVERY &
& ', IDELSPT, ' SECONDS'
ENDIF  
WRITE (IU06,  * ) '                        PRINTER  UNIT'  
WRITE (IU06, * ) ' SPECTRA OF TOTAL SEA .....', PFLAG (13) , &
 '......', FFLAG (13)
WRITE (IU06,  * ) '  '  
IF (NOUTT.GT.0) THEN  
   WRITE (IU06, * ) ' TO PRINTER AND/OR UNIT IU26 = ', IU26  
ELSE  
WRITE (IU06,  * ) ' TO PRINTER AND/OR UNIT IU26 = ', IU26, ' EVERY &
& ', IDELSPS, ' SECONDS'
ENDIF  
WRITE (IU06,  * ) '                        PRINTER  UNIT'  
WRITE (IU06, * ) ' SWELL SPECTRA ............', PFLAG (14) , &
 '......', FFLAG (14)

WRITE (IU06,  * ) '  '  
IF (IREST.EQ.1) THEN  
WRITE (IU06,  * ) ' OUTPUT AND RESTART FILES WILL BE DISPOSED EVER &
&Y', '...', IDELRES, ' SECONDS'
ELSE  
WRITE (IU06,  * ) ' OUTPUT FILES WILL BE DISPOSED EVERY .......... &
&.', '...', IDELRES, ' SECONDS'
ENDIF  
WRITE (IU06,  * ) '  '  
WRITE (IU06, * ) ' MODEL FILE NAMES:'  
WRITE (IU06, * ) ' USERID IS ........: ', USERID  
WRITE (IU06, * ) ' RUN IDENTIFIER IS : ', RUNID  
WRITE (IU06, * ) ' PATH NAME IS .....: ', PATH  
WRITE (IU06,  * ) '  '  
WRITE (IU06, * ) ' TEST OUTPUT LEVEL IS .............. ITEST = ', &
 ITEST
WRITE (IU06, * ) ' TEST OUTPUT OF IN BLOCK LOOPS UPTO ITESTB = ', &
 ITESTB
!
! ----------------------------------------------------------------------
!
!*    2. CHECK INTEGER RATIOS BETWEEN TIMESTEPS.
!        ---------------------------------------
!
LERROR = .FALSE.  
!
!*    2.1 WIND OUTPUT AND PROPAGATION TIME STEP.
!         --------------------------------------
!
IF ( (IDELWO.LT.IDELPRO.AND.MOD (IDELPRO, IDELWO) .NE.0) .OR. ( &
 IDELWO.GE.IDELPRO.AND.MOD (IDELWO, IDELPRO) .NE.0) ) THEN
   WRITE (IU06, * ) '*******************************************'  
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* WIND OUTPUT TIMSTEP AND PROPAGATION     *'  
WRITE (IU06,  * ) '* TIME STEP DO NOT HAVE INTEGER RATIO.    *'  
WRITE (IU06,  * ) '* WIND OUTPUT TIMSTEP    IDELWO = ', IDELWO  
   WRITE (IU06, * ) '* PROPAGATION TIME STEP IDELPRO = ', IDELPRO  
WRITE (IU06,  * ) '*                                         *'  
   WRITE (IU06, * ) '*******************************************'  
   LERROR = .TRUE.  
ENDIF  
!
!*    2.2 SOURCE FUNCTION AND PROPAGATION TIMESTEP.
!         -----------------------------------------
!
!     IF (IDELT.GT.IDELPRO.OR.MOD(IDELPRO,IDELT).NE.0) THEN
!        WRITE(IU06,*) '*******************************************'
!        WRITE(IU06,*) '*                                         *'
!        WRITE(IU06,*) '*    FATAL ERROR IN SUB. USERIN           *'
!        WRITE(IU06,*) '*    ==========================           *'
!        WRITE(IU06,*) '* SOURCE FUNCTION  AND PROPAGATION        *'
!        WRITE(IU06,*) '* TIME STEP DO NOT HAVE INTEGER RATIO OR  *'
!        WRITE(IU06,*) '* SOURCE FUNCTION TIMESTEP IS GREATER     *'
!        WRITE(IU06,*) '* THEN PROPAGATION TIMESTEP.              *'
!        WRITE(IU06,*) '* SOURCE FUNCTION TIMESTEP IDELT = ', IDELT
!        WRITE(IU06,*) '* PROPAGATION TIMESTEP   IDELPRO = ', IDELPRO
!        WRITE(IU06,*) '*                                         *'
!        WRITE(IU06,*) '*******************************************'
!        LERROR = .TRUE.
!     END IF
IF (IDELT.GT.IDELPRO) THEN  
   IF (MOD (IDELT, IDELPRO) .NE.0) THEN  
      WRITE (IU06, * ) &
       '*******************************************'
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* SOURCE FUNCTION  AND PROPAGATION        *'  
WRITE (IU06,  * ) '* TIME STEP DO NOT HAVE INTEGER RATIO     *'  
      WRITE (IU06, * ) '* SOURCE FUNCTION TIMESTEP IDELT = ', &
       IDELT
WRITE (IU06,  * ) '* PROPAGATION TIMESTEP   IDELPRO = ', IDELPRO  
WRITE (IU06,  * ) '*                                         *'  
      WRITE (IU06, * ) &
       '*******************************************'
      LERROR = .TRUE.  
   ENDIF  
ELSE  
   IF (MOD (IDELPRO, IDELT) .NE.0) THEN  
      WRITE (IU06, * ) &
       '*******************************************'
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* SOURCE FUNCTION  AND PROPAGATION        *'  
WRITE (IU06,  * ) '* TIME STEP DO NOT HAVE INTEGER RATIO     *'  
      WRITE (IU06, * ) '* SOURCE FUNCTION TIMESTEP IDELT = ', &
       IDELT
WRITE (IU06,  * ) '* PROPAGATION TIMESTEP   IDELPRO = ', IDELPRO  
WRITE (IU06,  * ) '*                                         *'  
      WRITE (IU06, * ) &
       '*******************************************'
      LERROR = .TRUE.  
   ENDIF  

ENDIF  
!
!*    2.3 SOURCE FUNCTION AND WIND OUTPUT TIMESTEP.
!         -----------------------------------------
!
IF (MOD (IDELWO, IDELT) .NE.0) THEN  
   WRITE (IU06, * ) '*******************************************'  
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* SOURCE FUNCTION  AND WIND OUTPUT        *'  
WRITE (IU06,  * ) '* TIME STEP DO NOT HAVE INTEGER RATIO OR  *'  
   WRITE (IU06, * ) '* SOURCE FUNCTION TIMESTEP IDELT = ', IDELT  
WRITE (IU06,  * ) '* WIND OUTPUT TIMESTEP    IDELWO = ', IDELWO  
WRITE (IU06,  * ) '*                                         *'  
   WRITE (IU06, * ) '*******************************************'  
   LERROR = .TRUE.  
ENDIF  
!
!*    2.4 WIND INPUT AND WIND OUTPUT TIMESTEP.
!         ------------------------------------
!
IF (IDELWO.GT.IDELWI) THEN  
   WRITE (IU06, * ) '+++++++++++++++++++++++++++++++++++++++++++'  
WRITE (IU06,  * ) '+                                         +'  
WRITE (IU06,  * ) '+   WARNING ERROR IN SUB. USERIN          +'  
WRITE (IU06,  * ) '+   ============================          +'  
WRITE (IU06,  * ) '+ WIND INPUT TIME STEP IS LESS THAN       +'  
WRITE (IU06,  * ) '+ WIND OUTPUT STEP                        +'  
WRITE (IU06,  * ) '+ WIND INPUT TIMESTEP   IDELWI = ', IDELWI  
WRITE (IU06,  * ) '+ WIND OUTPUT TIMESTEP  IDELWO = ', IDELWO  
WRITE (IU06,  * ) '+                                         +'  
WRITE (IU06,  * ) '+ WIND INPUT CHANGED TO WIND OUTPUT       +'  
WRITE (IU06,  * ) '+ MODEL WILL USE A NEW WIND FIELD EVERY   +'  
   WRITE (IU06, * ) '+ WIND OUTPUT TIME STEP AND IGNORE FIELDS +'  
WRITE (IU06,  * ) '+ IN BETWEEN.                             +'  
WRITE (IU06,  * ) '+                                         +'  
   WRITE (IU06, * ) '+++++++++++++++++++++++++++++++++++++++++++'  
   IDELWI = IDELWO  
ENDIF  
IF ( (IDELWO.LE.IDELWI.AND.MOD (IDELWI, IDELWO) .NE.0) ) THEN  
   WRITE (IU06, * ) '*******************************************'  
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* WIND INPUT  AND WIND OUTPUT             *'  
WRITE (IU06,  * ) '* TIME STEP DO NOT HAVE INTEGER RATIO OR  *'  
WRITE (IU06,  * ) '* WIND INPUT TIMESTEP   IDELWI = ', IDELWI  
WRITE (IU06,  * ) '* WIND OUTPUT TIMESTEP  IDELWO = ', IDELWO  
WRITE (IU06,  * ) '*                                         *'  
   WRITE (IU06, * ) '*******************************************'  
   LERROR = .TRUE.  
ENDIF  
!
!*    2.5 FILE DISPOSE TIMESTEP.
!         ----------------------
!
IF (MOD (IDELRES, IDELPRO) .NE.0.AND.MOD (IDELRES, IDELWI) .NE.0) &
 THEN
   WRITE (IU06, * ) '*******************************************'  
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* NEW OUTPUT FILES ARE REQUESTED EVERY    *'  
WRITE (IU06,  * ) '*    IDELRES = ', IDELRES, ' SECONDS'  
WRITE (IU06,  * ) '* IDELRES MUST BE MULTIPLES OF            *'  
WRITE (IU06,  * ) '* THE WIND INPUT TIMESTEP   IDELWI = ', IDELWI  
   WRITE (IU06, * ) '* THE PROPAGATION TIMESTEP IDELPRO = ', &
    IDELPRO
WRITE (IU06,  * ) '*                                         *'  
   WRITE (IU06, * ) '*******************************************'  
   LERROR = .TRUE.  
ENDIF  
!
!*    2.5 OUTPUT OPTION.
!         --------------
!
FFLAG20 = FFLAG (1) .OR.FFLAG (2) .OR.FFLAG (3) .OR.FFLAG (4) &
 .OR.FFLAG (5) .OR.FFLAG (6) .OR.FFLAG (7) .OR.FFLAG (8)
PFLAG20 = PFLAG (1) .OR.PFLAG (2) .OR.PFLAG (3) .OR.PFLAG (4) &
 .OR.PFLAG (5) .OR.PFLAG (6) .OR.PFLAG (7) .OR.PFLAG (8)
FFLAG21 = FFLAG (9) .OR.FFLAG (10) .OR.FFLAG (11) .OR.FFLAG (12)  
PFLAG21 = PFLAG (9) .OR.PFLAG (10) .OR.PFLAG (11) .OR.PFLAG (12)  
FFLAG25 = FFLAG (13)  
PFLAG25 = PFLAG (13)  
FFLAG26 = FFLAG (14)  
PFLAG26 = PFLAG (14)  
IF (NOUTT.GT.0) THEN  
   DO 2501 J = 1, NOUTT  
      CALL DIFDATE (IDATEA, IOUTT (J), ISHIFT)  
      IF (ISHIFT.LE.0.OR.MOD (ISHIFT, IDELPRO) .NE.0) THEN  
WRITE (IU06,  * ) '++++++++++++++++++++++++++++++++++++++++'  
WRITE (IU06,  * ) '+                                      +'  
WRITE (IU06,  * ) '+    WARNING ERROR IN SUB. USERIN      +'  
WRITE (IU06,  * ) '+    ============================      +'  
WRITE (IU06,  * ) '+ OUTPUT DATE IS NOT AT THE END OF A   +'  
WRITE (IU06,  * ) '+ PROPAGATION TIMESTEP.                +'  
         WRITE (IU06, * ) '+ DATE IS : ', IOUTT (J)  
WRITE (IU06,  * ) '+ PROGRAM WILL IGNORE THIS OUTPUT TIME +'  
WRITE (IU06,  * ) '+                                      +'  
WRITE (IU06,  * ) '++++++++++++++++++++++++++++++++++++++++'  
      ENDIF  
 2501    END DO  
ELSE  
   IF ( (FFLAG20.OR.PFLAG20) .AND.MOD (IDELINT, IDELPRO) .NE.0) &
    THEN
      WRITE (IU06, * ) &
       '*******************************************'
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* OUTPUT OF INTEGRATED DATA (TOTAL SEA)   *'  
WRITE (IU06,  * ) '* IS REQUESTED.                           *'  
WRITE (IU06,  * ) '* OUTPUT TIME STEP HAS TO BE A MULTIPLE   *'  
WRITE (IU06,  * ) '* OF THE PROPAGATION TIME STEP.           *'  
WRITE (IU06,  * ) '* OUTPUT TIME STEP IS      IDELINT = ', IDELINT  
      WRITE (IU06, * ) '* PROPAGATION TIME STEP IS IDELPRO = ', &
       IDELPRO
WRITE (IU06,  * ) '*                                         *'  
      WRITE (IU06, * ) &
       '*******************************************'
      LERROR = .TRUE.  
   ENDIF  
   IF ( (FFLAG21.OR.PFLAG21) .AND.MOD (IDELINS, IDELPRO) .NE.0) &
    THEN
      WRITE (IU06, * ) &
       '*******************************************'
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* OUTPUT OF INTEGRATED DATA (SEA + SWELL) *'  
WRITE (IU06,  * ) '* IS REQUESTED.                           *'  
WRITE (IU06,  * ) '* OUTPUT TIME STEP HAS TO BE A MULTIPLE   *'  
WRITE (IU06,  * ) '* OF THE PROPAGATION TIME STEP.           *'  
WRITE (IU06,  * ) '* OUTPUT TIME STEP IS      IDELINS = ', IDELINS  
      WRITE (IU06, * ) '* PROPAGATION TIME STEP IS IDELPRO = ', &
       IDELPRO
WRITE (IU06,  * ) '*                                         *'  
      WRITE (IU06, * ) &
       '*******************************************'
      LERROR = .TRUE.  
   ENDIF  
   IF ( (FFLAG25.OR.PFLAG25) .AND.MOD (IDELSPT, IDELPRO) .NE.0) &
    THEN
      WRITE (IU06, * ) &
       '*******************************************'
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* OUTPUT OF SPECTRA (TOTAL SEA)           *'  
WRITE (IU06,  * ) '* IS REQUESTED.                           *'  
WRITE (IU06,  * ) '* OUTPUT TIME STEP HAS TO BE A MULTIPLE   *'  
WRITE (IU06,  * ) '* OF THE PROPAGATION TIME STEP.           *'  
WRITE (IU06,  * ) '* OUTPUT TIME STEP IS      IDELSPT = ', IDELSPT  
      WRITE (IU06, * ) '* PROPAGATION TIME STEP IS IDELPRO = ', &
       IDELPRO
WRITE (IU06,  * ) '*                                         *'  
      WRITE (IU06, * ) &
       '*******************************************'
      LERROR = .TRUE.  
   ENDIF  
   IF ( (FFLAG26.OR.PFLAG26) .AND.MOD (IDELSPS, IDELPRO) .NE.0) &
    THEN
      WRITE (IU06, * ) &
       '*******************************************'
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) '*    ==========================           *'  
WRITE (IU06,  * ) '* OUTPUT OF SPECTRA (SEA + SWELL)         *'  
WRITE (IU06,  * ) '* IS REQUESTED.                           *'  
WRITE (IU06,  * ) '* OUTPUT TIME STEP HAS TO BE A MULTIPLE   *'  
WRITE (IU06,  * ) '* OF THE PROPAGATION TIME STEP.           *'  
WRITE (IU06,  * ) '* OUTPUT TIME STEP IS      IDELSPS = ', IDELSPS  
      WRITE (IU06, * ) '* PROPAGATION TIME STEP IS IDELPRO = ', &
       IDELPRO
WRITE (IU06,  * ) '*                                         *'  
      WRITE (IU06, * ) &
       '*******************************************'
      LERROR = .TRUE.  
   ENDIF  
ENDIF  
!
! ----------------------------------------------------------------------
!
!*    3. ERROR CHECK.
!        ------------
!
IF (LERROR) THEN  
   WRITE (IU06, * ) '*******************************************'  
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '*    FATAL ERROR(S) IN SUB. USERIN        *'  
WRITE (IU06,  * ) '*    =============================        *'  
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '* CORRECT USER INPUT AS INDICATED ABOVE   *'  
WRITE (IU06,  * ) '* AND TRY AGAIN!!!!!!!!!!!!!!!!!!!!!!!!   *'  
WRITE (IU06,  * ) '*                                         *'  
WRITE (IU06,  * ) '* PROGRAM ABORTS.   PROGRAM ABORTS.       *'  
WRITE (IU06,  * ) '* ---------------   --------------        *'  
   WRITE (IU06, * ) '*******************************************'  
   CALL ABORT  
ELSE  
   RETURN  
ENDIF  
!
! ----------------------------------------------------------------------
!
!*    4. READ ERROR MESSAGES.
!        --------------------
!
 4000 CONTINUE  
WRITE (IU06, * ) ' ********************************************'  
WRITE (IU06,  * ) ' *                                          *'  
WRITE (IU06,  * ) ' *     FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) ' *     ==========================           *'  
WRITE (IU06,  * ) ' * READ ERROR ON INPUT FILE:                *'  
WRITE (IU06, * ) ' * ERROR IS LATER THAN ICOUNT = ', ICOUNT  
WRITE (IU06,  * ) ' * LAST LINE READ IS     LINE = ', LINE  
WRITE (IU06,  * ) ' *                                          *'  
WRITE (IU06,  * ) ' *   PROGRAM ABORTS  PROGRAM ABORTS         *'  
WRITE (IU06,  * ) ' *                                          *'  
WRITE (IU06, * ) ' ********************************************'  
CALL ABORT  
 4100 CONTINUE  
WRITE (IU06, * ) ' ********************************************'  
WRITE (IU06,  * ) ' *                                          *'  
WRITE (IU06,  * ) ' *     FATAL ERROR IN SUB. USERIN           *'  
WRITE (IU06,  * ) ' *     ==========================           *'  
WRITE (IU06,  * ) ' * READ ERROR ON CHARACTER STRING           *'  
WRITE (IU06, * ) ' * ERROR IS IN DATA LINE ICOUNT = ', ICOUNT  
WRITE (IU06,  * ) ' * CHARACTER STRING IS   LINE = ', LINE  
WRITE (IU06,  * ) ' *                                          *'  
WRITE (IU06,  * ) ' *   PROGRAM ABORTS  PROGRAM ABORTS         *'  
WRITE (IU06,  * ) ' *                                          *'  
WRITE (IU06, * ) ' ********************************************'  

CALL ABORT  
END SUBROUTINE userin
