#ifdef ice
SUBROUTINE trans_grid (icemask, mask_ice, ijs, ijl, ig)
use params
use map
implicit none

INTEGER, INTENT(OUT)    :: icemask(niblo,nblo)
INTEGER, INTENT(IN OUT) :: mask_ice(ngx,ngy)
INTEGER, INTENT(IN)     :: ijs, ijl, ig

NZERO = 0
NONE = 0
DO IJ = IJS, IJL
   IX = IXLG (IJ, IG)
   IY = KXLT (IJ, IG)
   ICEMASK (IJ, IG) = MASK_ICE (IX, IY)
   IF (ICEMASK (IJ, IG) .EQ.0) NZERO = NZERO + 1
   IF (ICEMASK (IJ, IG) .EQ.1) NONE = NONE+1
END DO
DO I = 1, NGX
   DO J = 1, NGY
      MASK_ICE (I, J) = 1.
   ENDDO
ENDDO

DO IJ = IJS, IJL
   IX = IXLG (IJ, IG)
   IY = KXLT (IJ, IG)
   MASK_ICE (IX, IY) = ICEMASK (IJ, IG)
END DO  

WRITE(*,*) 'NUMBER OF ICE POINTS:', NZERO
WRITE(*,*) 'NUMBER OF OTHER POINTS:', NONE
WRITE(*,*) 'ICE MASK UNDERSTOOD'

DO I = 1, NGX
   WRITE(*, '(129i1)') (MASK_ICE (I, J) , J = 1, NGY)
ENDDO

RETURN
END SUBROUTINE trans_grid
#endif
