SUBROUTINE syminv (a, nobs, v, z, ipvt, ier)  
! --- invert the nobs*nobs matrix a
! --- the inverted matrix is named a
implicit none

INTEGER, INTENT(IN)     :: nobs
INTEGER, INTENT(IN OUT) :: ipvt(nobs)
INTEGER, INTENT(OUT)    :: ier
REAL, INTENT(IN OUT)    :: a(nobs,nobs), v(nobs), z(nobs)
REAL, ALLOCATABLE, DIMENSION (:, :) ::AA
REAL    :: DET(2), RCOND, RR
INTEGER :: I, J, JOB

ier = 0
ALLOCATE (AA (NOBS, NOBS) )
do i = 1, nobs
   do j = 1, nobs
      aa (i, j) = a (i, j)
   enddo
enddo
call sgeco (aa, nobs, nobs, ipvt, rcond, z)
rr = rcond+1.
if (rr.eq.1.) then
!     matrix is singular
   ier = 1
   return
endif
job = 1
call sgedi (aa, nobs, nobs, ipvt, det, v, job)
do i = 1, nobs
   do j = 1, nobs
      a (i, j) = aa (i, j)
   enddo
enddo
DEALLOCATE (AA)

return
END SUBROUTINE syminv
