SUBROUTINE sscal (n, sa, sx, incx)  
!     scales a vector by a constant.
!     uses unrolled loops for increment equal to 1.
!     jack dongarra, linpack, 3/11/78.
!     modified 3/93 to return if incx .le. 0.
!     modified 12/3/93, array(1) declarations changed to array(*)
implicit none

INTEGER, INTENT(IN) :: n, incx
REAL   , INTENT(IN) :: sa
REAL   , INTENT(OUT):: sx(*)
integer :: i, m, mp1, nincx

if (n.le.0.or.incx.le.0) return
if (incx.eq.1) goto 20
!        code for increment not equal to 1
nincx = n * incx  
do 10 i = 1, nincx, incx  
   sx (i) = sa * sx (i)  
10 end do  
return  
!        code for increment equal to 1
!        clean-up loop
   20 m = mod (n, 5)  
if (m.eq.0) goto 40  
do 30 i = 1, m  
   sx (i) = sa * sx (i)  
30 end do  
if (n.lt.5) return  
40 mp1 = m + 1  
do 50 i = mp1, n, 5  
   sx (i) = sa * sx (i)  
   sx (i + 1) = sa * sx (i + 1)  
   sx (i + 2) = sa * sx (i + 2)  
   sx (i + 3) = sa * sx (i + 3)  
   sx (i + 4) = sa * sx (i + 4)  
50 end do  

return  
END SUBROUTINE sscal
