#ifdef waves_breaking
SUBROUTINE sfbrk (f, fl, ijs, ijl, ig)
!-----------------------------------------------------------------------
!     WEIMIN LUO, POL, MAY 1996, COMPUTATION OF WAVE BREAKING
!**   PURPOSE
!     -------
!     COMPUTE DISSIPATION DUE TO DEPTH-INDUCED WAVE BREAKING
!**   INTERFACE.
!     ----------
!       *CALL* *SFBRK (F, FL, IJS, IJL, IG)*
!          *F*   - SPECTRUM.
!          *FL*  - DIAGONAL MATRIX OF FUNCTIONAL DERIVATIVE
!          *IJS* - INDEX OF FIRST GRIDPOINT
!          *IJL* - INDEX OF LAST GRIDPOINT
!          *IG*  - BLOCK NUMBER
!**   METHOD.
!     -------
!       SEE REFERENCES.
!**   REFERENCES.
!     -----------
!     BATTJES & JANSSEN (1978)
! ----------------------------------------------------------------------
USE params ; USE shallow ; USE meanpa ; USE source
IMPLICIT NONE

REAL   , INTENT(IN) :: f(0:niblo,nang,nfre)
REAL   , INTENT(OUT):: fl(0:niblo,nang,nfre)
INTEGER, INTENT(IN) :: ijs, ijl, ig
INCLUDE'globals.h'
REAL,PARAMETER   :: gamd = 0.8, alpha = 1.0
REAL,ALLOCATABLE :: sbr(:)
REAL    :: hmax, hrms, qb, wm, detot
INTEGER :: ij

ALLOCATE(sbr(ijs:ijl))

DO ij = ijs, ijl
!  compute Hmax
   hmax    = gamd * depth(ij, ig)
!  compute Hrms
   hrms    = SQRT (8. * emean(ij) )
   wm      = SQRT (g * akmean(ij) * TANH (akmean(ij) * depth(ij,ig) ) )
!   compute total dissipation rate according to Battjes-Janssen
   CALL cmpqb (hrms, hmax, qb)
   qb      = MIN (1., qb)
   detot   = - alpha * qb * wm * hmax * hmax / (8. * pi)
   sbr(ij) = detot / emean(ij)
ENDDO
do m = 1, nfre
   do k = 1, nang
      do ij = ijs, ijl
         sl(ij, k, m) = sl(ij, k, m) + sbr(ij) * f(ij, k, m)
         fl(ij, k, m) = fl(ij, k, m) + sbr(ij)
      ENDDO
   ENDDO
ENDDO
DEALLOCATE(sbr)

RETURN
END SUBROUTINE sfbrk
#endif
