SUBROUTINE sepwisw (fl3, fl1, ijs, ijl, ig)  
! ----------------------------------------------------------------------
!**** *SEPWISW* - COMPUTES THE SWELL ENERGY, THE MEAN SWELL DIRECTION,
!****             THE MEAN SWELL FREQUENCY AND THE MEAN WINDSEA DIR.
!     P.LIONELLO     FEBRUARY 87
!     L.ZAMBRESKY    NOVEMBER 87   GKSS/ECMWF   OPTIMIZED SUB.
!*    PURPOSE.
!     --------
!       TO SEPARATE THE SWELL FROM THE WIND INTERACTING SEE
!**   INTERFACE.
!     ----------
!       *CALL* *SEPWISW (FL3, FL1, IJS, IJL, IG)*
!          *FL3* - BLOCK OF SPECTRA
!          *FL1* - SWELL FLAG ARRAY
!                  = 1 IF COMPONENT IS SWELL
!                  = 0 IF COMPONENT IS SEA
!          *IJS* - INDEX OF FIRST GRIDPOINT
!          *IJL* - INDEX OF LAST GRIDPOINT
!          *IG * - BLOCK NUMBER
!     METHOD.
!     -------
!       THE WAVES WHICH DO NOT INTERACT WITH THE WIND ARE
!       CONSIDERED SWELL.
!     EXTERNALS.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use fredir
use meanpa
use swell
use wind
implicit none

REAL   , INTENT(IN) :: fl3(0:niblo,nang,nfre)
REAL   , INTENT(OUT):: fl1(0:niblo,nang,nfre)
INTEGER, INTENT(IN) :: ijs, ijl, ig
REAL,PARAMETER :: FRIC = 28.
REAL    :: CIS(NIBLO), SIS(NIBLO), CIWS(NIBLO), SIWS(NIBLO)
REAL    :: SF3SW(NIBLO), SF3WIS(NIBLO)
REAL    :: CM, DF, FD, CIK, SIK, F3SW, F3WIS, CHECKTA
INTEGER :: K, M, IJ
! ----------------------------------------------------------------------
!*    1. THE SWELL DISTRIBUTION IS COMPUTED.
!        -----------------------------------
! 1000 CONTINUE  
DO M = 1, NFRE  
   DO K = 1, NANG  
      DO IJ = IJS, IJL  
         FL1 (IJ, K, M) = 0.  
      ENDDO
   ENDDO
ENDDO
DO K = 1, NANG  
   DO IJ = IJS, IJL  
      SIS (IJ) = 1.2 * USOLD (IJ, IG) * COS (TH (K) - THWOLD (IJ,IG))
   END DO  
   DO M = 1, NFRE  
      CM = FRIC / C (M)  
      DO IJ = IJS, IJL  
         CHECKTA = CM * SIS (IJ)  
         IF (CHECKTA.LT.1.) THEN  
            FL1 (IJ, K, M) = 1.  
         ENDIF  
      ENDDO 
   ENDDO  
END DO  
!*    2. COMPUTATION OF SWELL TOTAL ENERGY,MEAN FREQUENCY,MEAN DIRECTION
!*       AND OF WIND-SEA MEAN DIRECTION.
!        ---------------------------------------------------------------
! 2000 CONTINUE  
DO IJ = 1, NIBLO  
   ESWELL (IJ) = 0.  
   FSWELL (IJ) = 0.  
   SIS (IJ) = 0.  
   CIS (IJ) = 0.  
   CIWS (IJ) = 0.  
   SIWS (IJ) = 0.  
END DO  

DO K = 1, NANG  
   CIK = COSTH (K)  
   SIK = SINTH (K)  
   DO IJ = IJS, IJL  
      SF3SW (IJ) = 0.  
      SF3WIS (IJ) = 0.  
   END DO  
   DO M = 1, NFRE  
      DF = DFIM (M)  
      FD = DF / FR (M)  
      DO IJ = IJS, IJL  
         F3SW = FL3 (IJ, K, M) * FL1 (IJ, K, M)  
         F3WIS = FL3 (IJ, K, M) - F3SW  
         SF3SW (IJ) = SF3SW (IJ) + F3SW  
         SF3WIS (IJ) = SF3WIS (IJ) + F3WIS  
         ESWELL (IJ) = ESWELL (IJ) + DF * F3SW  
         FSWELL (IJ) = FSWELL (IJ) + FD * F3SW  
      END DO  
   END DO  
   DO IJ = IJS, IJL  
      SIS (IJ) = SIS (IJ) + SF3SW (IJ) * SIK  
      CIS (IJ) = CIS (IJ) + SF3SW (IJ) * CIK  
      SIWS (IJ) = SIWS (IJ) + SF3WIS (IJ) * SIK  
      CIWS (IJ) = CIWS (IJ) + SF3WIS (IJ) * CIK  
   END DO  
END DO  
DO IJ = IJS, IJL  
!        IF (CIWS(IJ).EQ.0.) CIWS(IJ) = 0.1E-90
   IF (CIWS (IJ) .EQ.0.) CIWS (IJ) = 0.1E-32  
!        IF (CIS(IJ).EQ.0.) CIS(IJ) = 0.1E-90
   IF (CIS (IJ) .EQ.0.) CIS (IJ) = 0.1E-32  
!        IF (FSWELL(IJ).EQ.0.) FSWELL(IJ) = 0.1E-90
   IF (FSWELL (IJ) .EQ.0.) FSWELL (IJ) = 0.1E-32  
   IF (USNEW (IJ) .EQ.0.) ESWELL (IJ) = EMEAN (IJ)  
END DO  
DO IJ = IJS, IJL  
   THWISEA (IJ) = ATAN2 (SIWS (IJ), CIWS (IJ) )  
   THSWELL (IJ) = ATAN2 (SIS (IJ), CIS (IJ) )  
   FSWELL (IJ) = ESWELL (IJ) / (FSWELL (IJ) )  
END DO  

RETURN  
END SUBROUTINE sepwisw
