SUBROUTINE semean (f3, ijs, ijl)
! ----------------------------------------------------------------------
!**** *SEMEAN* - COMPUTATION OF TOTAL ENERGY AT EACH GRID POINT.
!     S.D. HASSELMANN.
!     OPTIMIZED BY: L. ZAMBRESKY AND H. GUENTHER
!*    PURPOSE.
!     --------
!       TO COMPUTE TOTAL ENERGY AT EACH GRID POINT.
!**   INTERFACE.
!     ----------
!       *CALL* *SEMEAN(F3, IJS, IJL)*
!          *F3*  - SPECTRUM.
!          *IJS* - INDEX OF FIRST GRIDPOINT
!          *IJL* - INDEX OF LAST GRIDPOINT
!     METHOD.
!     -------
!       NONE.
!     EXTERNALS.
!     ----------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
USE params ; USE fredir ;USE meanpa
IMPLICIT NONE

REAL   , INTENT(IN):: f3(0:niblo,nang,nfre)
INTEGER, INTENT(IN):: ijs, ijl
REAL,ALLOCATABLE   :: temp(:)
REAL    :: delt25
INTEGER :: k, m, ij
! ----------------------------------------------------------------------
ALLOCATE(temp(ijs:ijl))
!*    1. INITIALISE ENERGY ARRAY.
!        ------------------------
DO ij = ijs, ijl
!        EMEAN(IJ) = 0.1E-90
   emean(ij) = 0.1e-32
ENDDO
! ----------------------------------------------------------------------
!*    2. INTEGRATE OVER FREQUENCIES AND DIRECTION.
!        -----------------------------------------
DO m = 1, nfre
   DO ij = ijs, ijl
      temp(ij) = 0.
   ENDDO
   DO  k = 1, nang
      DO ij = ijs, ijl
         temp(ij) = temp(ij) + f3(ij,k,m)
      ENDDO
   ENDDO
   DO ij = ijs, ijl
      emean(ij) = emean(ij) + dfim(m) * temp(ij)
   ENDDO
ENDDO
! ----------------------------------------------------------------------
!*    3. ADD TAIL ENERGY.
!        ----------------
delt25 = fr(nfre) / 4. * delth
DO ij = ijs, ijl
   emean(ij) = emean(ij) + delt25 * temp(ij)
ENDDO
DEALLOCATE(temp)

RETURN
END SUBROUTINE semean
