REAL FUNCTION sdot (n, sx, incx, sy, incy)  
!     forms the dot product of two vectors.
!     uses unrolled loops for increments equal to one.
!     jack dongarra, linpack, 3/11/78.
!     modified 12/3/93, array(1) declarations changed to array(*)
IMPLICIT NONE

INTEGER, INTENT(IN):: n, incx, incy
REAL   , INTENT(IN):: sx(*), sy(*)
real   :: stemp
integer:: i, ix, iy, m, mp1

stemp = 0.0e0
sdot = 0.0e0
if (n.le.0) return
if (incx.eq.1.and.incy.eq.1) goto 20
!        code for unequal increments or equal increments
!          not equal to 1
ix = 1
iy = 1
if (incx.lt.0) ix = ( - n + 1) * incx + 1
if (incy.lt.0) iy = ( - n + 1) * incy + 1
do 10 i = 1, n
   stemp = stemp + sx (ix) * sy (iy)
   ix = ix + incx
   iy = iy + incy
10 end do
sdot = stemp
return
!        code for both increments equal to 1
!        clean-up loop
20 m = mod (n, 5)
if (m.eq.0) goto 40
do 30 i = 1, m
   stemp = stemp + sx (i) * sy (i)
30 end do
if (n.lt.5) goto 60
   40 mp1 = m + 1
do 50 i = mp1, n, 5
   stemp = stemp + sx (i) * sy (i) + sx (i + 1) * sy (i + 1) &
    + sx (i + 2) * sy (i + 2) + sx (i + 3) * sy (i + 3) + sx (i + &
    4) * sy (i + 4)
50 end do
60 sdot = stemp

return
END FUNCTION sdot
