SUBROUTINE sbottom (f, fl, ijs, ijl, ig)
!SHALLOW
! ----------------------------------------------------------------------
!**** *SBOTTOM* - COMPUTATION OF BOTTOM FRICTION.
!     G.J.KOMEN AND Q.D.GAO
!     OPTIMIZED BY L.F. ZAMBRESKY
!*    PURPOSE.
!     --------
!       COMPUTATION OF BOTTOM FRICTION DISSIPATION
!**   INTERFACE.
!     ----------
!       *CALL* *SBOTTOM (F, FL, IJS, IJL, IG)*
!          *F*   - SPECTRUM.
!          *FL*  - DIAGONAL MATRIX OF FUNCTIONAL DERIVATIVE
!          *IJS* - INDEX OF FIRST GRIDPOINT
!          *IJL* - INDEX OF LAST GRIDPOINT
!          *IG*  - BLOCK NUMBER
!     METHOD.
!     -------
!       SEE REFERENCES.
!     REFERENCES.
!     -----------
!       HASSELMANN ET AL, D. HYDR. Z SUPPL A12(1973) (JONSWAP)
!       BOUWS AND KOMEN, JPO 13(1983)1653-1658
! ----------------------------------------------------------------------
USE params ; USE shallow ; USE source
IMPLICIT NONE

REAL, INTENT(IN)    :: f(0:niblo,nang,nfre)
REAL, INTENT(OUT)   :: fl(0:niblo,nang,nfre)
INTEGER, INTENT(IN) :: ijs, ijl, ig
INCLUDE'globals.h'
REAL,PARAMETER :: const = - 2.0 * 0.038 / g
REAL,ALLOCATABLE :: sbo(:)
INTEGER :: m, k, ij
REAL    :: arg

ALLOCATE(sbo(ijs:ijl))

DO m = 1, nfre
!    ARG-> ARG(IJS:IJL)
!    IMKL TO MULTIPLY WITH DEPTH AND TFAK
!    CHECK TO MIN ME TIS MOLIS UPOLOGISMENES TIMES
!    SINH GIA NA UPOLOGISEIS TELIKO ARG
   DO ij = ijs, ijl
      arg     = 2. * depth(ij,ig) * tfak(indep(ij),m)
      arg     = MIN(arg, 50.)
      sbo(ij) = const * tfak(indep(ij),m) / SINH (arg)
   ENDDO
   DO k = 1, nang
      DO ij = ijs, ijl
         sl(ij,k,m) = sl(ij,k,m) + sbo(ij) * f(ij,k,m)
         fl(ij,k,m) = fl(ij,k,m) + sbo(ij)
      ENDDO
   ENDDO
ENDDO
DEALLOCATE(sbo)

RETURN
END SUBROUTINE sbottom
