REAL FUNCTION sasum (n, sx, incx)
!     takes the sum of the absolute values.
!     uses unrolled loops for increment equal to one.
!     jack dongarra, linpack, 3/11/78.
!     modified 3/93 to return if incx .le. 0.
!     modified 12/3/93, array(1) declarations changed to array(*)
IMPLICIT NONE

INTEGER, INTENT(IN) :: n, incx
REAL, INTENT(IN)    :: sx(*)
REAL   :: stemp
INTEGER:: i, m, mp1, nincx

sasum = 0.0e0
stemp = 0.0e0
IF( n    .LE. 0 .OR. incx .LE. 0 ) RETURN
IF( incx .EQ. 1 ) goto 20

!        code for increment not equal to 1
nincx = n * incx
DO i = 1, nincx, incx
   stemp = stemp + ABS (sx (i) )
ENDDO
sasum = stemp
RETURN

!        code for increment equal to 1
!        clean-up loop
20 m = MOD (n, 6)
IF( m .EQ. 0 ) GOTO 40
DO i = 1, m
   stemp = stemp + ABS (sx (i) )
ENDDO
IF( n .LT. 6 ) GOTO 60
40 mp1 = m + 1
do i = mp1, n, 6
   stemp = stemp + ABS (sx(i) ) + ABS (sx(i + 1) ) + ABS (sx(i + 2) ) &
          +ABS (sx(i + 3) ) + ABS (sx(i + 4) ) + ABS (sx(i + 5) )
ENDDO
60 sasum = stemp

return
END FUNCTION sasum
