SUBROUTINE rotspec (nfre, nang, ml, kl, fl1, fl3, rthet)  
!----------------------------------------------------------------------
!**** *ROTSPEC* - ROUTINE TO ROTATE THE SPECTRUM.
!     EVA BAUER      MPI  HAMBURG    MAY 1990.
!     H. GUNTHER          GKSS/ECMWF JAN. 1991   MODIFIED FOR CYCLE_4
!*    PURPOSE.
!     -------
!       TO ROTATE THE SPECTRUM.
!**   INTERFACE.
!     ----------
!       *CALL* *ROTSPEC (NFRE, NANG, ML, KL, FL1, FL3, RTHET)*
!          *NFRE*  - FREQUENCY DIMENSION OF SPECTRA.
!          *NANG*  - DIRECTION DIMENSION OF SPECTRA.
!          *ML*    - NUMBER OF FREQUENCIES.
!          *KL*    - NUMBER OF DIRECTIONS.
!          *FL1*   - SPECTRUM TO BE ROTATED.
!          *FL3*   - ROTATED SPECTRUM.
!          *RTHET* - TURNING ANGLE IN RADIANS, CLOCKWISE.
!     METHOD.
!     -------
!       NONE.
!     EXTERNALS.
!     ---------
!       NONE.
!     REFERENCES.
!     -----------
!       NONE.
! -------------------------------------------------------------------
IMPLICIT NONE

INTEGER, INTENT(IN)    :: nfre, nang, ml, kl
REAL   , INTENT(IN)    :: fl1(nang,nfre)
REAL   , INTENT(OUT)   :: fl3(nang,nfre)
REAL   , INTENT(IN OUT):: rthet
INCLUDE'globals.h'
INTEGER :: k, m, kc, kc1, inc
REAL    :: fth, adif, bdif
! --------------------------------------------------------------------
fth  = MOD (rthet + zpi, zpi)
fth  = fth * REAL (kl) / zpi
inc  = IFIX (fth)
adif = fth - inc
bdif = 1. - adif

DO k = 1, kl
   kc = k - inc
   IF( kc  .LT. 1 )    kc  = kc + kl
   KC1 = KC - 1
   IF( kc1 .LT. 1 )    kc1 = kc1 + kl
   DO m = 1, ml
      fl3(k,m) = bdif * fl1(kc,m) + adif * fl1(kc1,m)
   ENDDO
ENDDO

RETURN
END SUBROUTINE rotspec
