SUBROUTINE readwnd (idtwir, uwnd, vwnd, nc, nr, us_eta, z0_eta)
! ----------------------------------------------------------------------
!**** *READWND* - PROGRAM TO GENERATE SWAMP WINDFIELDS.
!     HEINZ GUNTHER    ECMWF   OCTOBER 1989
!     P. KATSAFADOS    HUA/HCMR  JULY 2014 RECEIVE WINDS FROM THE ATMOS MODEL
!
!*    PURPOSE.
!     --------
!       TO GENERATE SWAMP WINDFIELDS.
!**   INTERFACE.
!     ----------
!       *CALL READWND (IDTWIR, UWND, VWND, NC, NR)*
!         *IDTWIR* - DATE/TIME OF THE DATA READ.
!         *UWND*  - HORIZONTAL WIND COMPONENTS.
!         *VWND*  - VERTICAL WIND COMPONENTS.
!         *NC*    - NUMBER OF COLUMNS IN INPUT WIND ARRAYS (DIMENSION).
!         *NR*    - NUMBER OF ROWS    IN INPUT WIND ARRAYS (DIMENSION).
!     METHOD.
!     -------
!       NONE.
!     EXTERNALS.
!     ----------
!       *INCDATE*   - INCREMENT DATE/TIME GROUP.
! ----------------------------------------------------------------------
use stat
use indir
use testo
use wndgrd
use couple_mpi
implicit none
CHARACTER :: idtfeed*12
CHARACTER, INTENT(OUT)   :: idtwir * 12
INTEGER*4  , INTENT(IN)    :: nc, nr  !cpk-i4 instead of -i8
REAL     , INTENT(IN OUT):: uwnd(nc,nr), vwnd(nc,nr)
REAL     , INTENT(IN OUT):: us_eta(nc,nr), z0_eta(nc,nr)
LOGICAL   :: FRSTIME
CHARACTER :: LINE * 150, inwindname * 150
INTEGER*4   :: I, J, IU01, IECF_LEN, IERRCODE, IOS
INTEGER   :: IREP
INTEGER   :: ii, jj
REAL      :: aminu, aminv, amaxu, amaxv
REAL      :: amins, aminz, amaxs, amaxz
INTEGER   :: ISTAT(MPI_STATUS_SIZE)

! ----------------------------------------------------------------------
DATA IU01 / 3 /
DATA IREP / 0 /
DATA FRSTIME / .TRUE. /

!NIKOS INCLUDE'windlatlon.h'  
RLATS = 29.0 
RLATN = 48.0
RLONL = -8.0 
RLONR = 42.0 
!*    0. OPEN CURRENT WIND FIELD
IF (FRSTIME) THEN  
   IDTWIR = IDATEA  
ELSE  
   CALL INCDATE (IDTWIR, IDELWI)  
ENDIF  
! ----------------------------------------------------------------------
!*    1. FOR FIRST CALL, DETERMINE DATES.
!        --------------------------------
IF (FRSTIME) THEN  

   ICODE = 3  
   IDTWIR = IDATEA  
   KCOL = NC  
   KROW = NR  
   IWPER = 0  
   ICOORD = 1  
   DLAM = (RLONR - RLONL) / REAL (KCOL - 1)  
   DPHI = (RLATN - RLATS) / REAL (KROW - 1)  
   FRSTIME = .FALSE.  
WRITE (IU06,*) '  '  
   WRITE (IU06,*) ' SUB. READWND: WIND FILE HEADER READ'  
   WRITE (IU06,*) ' WIND GRID SPECIFICATION ARE:'  
   WRITE (IU06,*) ' NUMBER OF COLUMNS IN GRID KCOL = ', KCOL  
WRITE(IU06,*) ' NUMBER OF ROWS    IN GRID KROL = ', KROW  
WRITE(IU06,*) ' SOUTHERN MOST LATITUDE   RLATS = ', RLATS  
WRITE(IU06,*) ' NORTHERN MOST LATITUDE   RLATN = ', RLATN  
WRITE(IU06,*) ' WESTERN MOST LONGITUDE   RLONL = ', RLONL  
WRITE(IU06,*) ' EASTERN MOST LONGITUDE   RLONR = ', RLONR  
WRITE(IU06,*) ' COORDINATE SYSTEM CODE  ICOORD = ', ICOORD  
WRITE(IU06,*) ' PERIODIC GRID INDICATOR  IWPER = ', IWPER  
WRITE(IU06,*) ' LATITUDE  STEP IS         DPHI = ', DPHI  
WRITE(IU06,*) ' LONGITUDE STEP IS         DLAM = ', DLAM  
!*    1.1 CHECK DIMENSIONS.
!         -----------------
   IF (KCOL * KROW.GT.NC * NR) THEN  
WRITE(IU06,*) ' *****************************************'  
WRITE(IU06,*) ' *                                       *'  
WRITE(IU06,*) ' *       FATAL ERROR IN SUB. READWND     *'  
WRITE(IU06,*) ' *       ===========================     *'  
WRITE(IU06,*) ' * DIMENSION OF WIND ARRAY IS TO SMALL   *'  
WRITE(IU06,*) ' * DIMENSION WIND ARRAY IS     NC*NR = ', NC * NR
WRITE(IU06,*) ' * DIMENSION REQUESTED IS KCOL*KROW = ', KCOL * KROW
WRITE(IU06,*) ' * CHANGE PARAMETER STATEMENT IN WAVMDL  *'  
WRITE(IU06,*) ' * VALUES HAVE TO BE:                    *'  
WRITE(IU06,*) ' *      NC = ', KCOL  
WRITE(IU06,*) ' *      NR = ', KROW  
WRITE(IU06,*) ' *                                       *'  
WRITE(IU06,*) ' *   PROGRAM ABORTS  PROGRAM ABORTS      *'  
WRITE(IU06,*) ' *                                       *'  
WRITE(IU06,*) ' *****************************************'  
      CALL ABORT  
   ENDIF  
   IF (KROW.LT.2.OR.KCOL.LT.2) THEN  
WRITE(IU06,*) ' *****************************************'  
WRITE(IU06,*) ' *                                       *'  
WRITE(IU06,*) ' *       FATAL ERROR IN SUB. READWND     *'  
WRITE(IU06,*) ' *       ===========================     *'  
WRITE(IU06,*) ' * DIMENSIONS OF WIND INPUT GRID ARE     *'  
WRITE(IU06,*) ' * LESS THAN 2.                          *'  
WRITE(IU06,*) ' * NUMBER OF COLUMNS   KCOL = ', KCOL  
WRITE(IU06,*) ' * NUMBER OF ROWS      KROW = ', KROW  
WRITE(IU06,*) ' * CHECK WIND INPUT AND MAKE SURE, THAT  *'  
WRITE(IU06,*) ' * PARAMETER STATEMENT IN WAVMDL IS OK   *'  
WRITE(IU06,*) ' *                                       *'  
WRITE(IU06,*) ' *   PROGRAM ABORTS  PROGRAM ABORTS      *'  
WRITE(IU06,*) ' *                                       *'  
WRITE(IU06,*) ' *****************************************'  
      CALL ABORT  
   ENDIF  
ENDIF  

! receive here the zonal and meridional wind at 10m
!CALL MPI_COMM_RANK(MPI_COMM_WORLD,myrank,ierr)
!if (myrank .eq. 1) then
 call mpi_recv(idat,3,MPI_INTEGER,atmos_proc_w,tag1,MPI_COMM_WORLD,status,ierr)
 call mpi_recv(ihrst,1,MPI_INTEGER,atmos_proc_w,tag2,MPI_COMM_WORLD,status,ierr)
 call mpi_recv(ihr,1,MPI_INTEGER,atmos_proc_w,tag3,MPI_COMM_WORLD,status,ierr)
 call mpi_recv(etantsd,1,MPI_INTEGER,atmos_proc_w,tag4,MPI_COMM_WORLD,status,ierr)
 call mpi_recv(waventsd,1,MPI_INTEGER,atmos_proc_w,tag5,MPI_COMM_WORLD,status,ierr)
! WRITE(IU06,'(5(i4,1x),2(i5.5,1x)') \
 WRITE(IU06,*) 'WAM READWND RECV DATE/TIME = ',IDTWIR
 WRITE(IU06,*) \
 'WAM READWND RECV IDAT,ihrst,ihr: ', IDAT(1),IDAT(2),IDAT(3),ihrst,ihr, \
 ' at eta/wam timestep: ',etantsd,waventsd
 call mpi_recv(uwnd,nc*nr,MPI_REAL,atmos_proc_w,tagu,MPI_COMM_WORLD,status,ierr)
 call mpi_recv(vwnd,nc*nr,MPI_REAL,atmos_proc_w,tagv,MPI_COMM_WORLD,status,ierr)
 aminu=100000.
 amaxu=-100000.
 aminv=100000.
 amaxv=-100000.
 do ii=1,nc
 do jj=1,nr
    if (uwnd(ii,jj).lt.aminu) aminu=uwnd(ii,jj)
    if (uwnd(ii,jj).gt.amaxu) amaxu=uwnd(ii,jj)
    if (vwnd(ii,jj).lt.aminv) aminv=vwnd(ii,jj)
    if (vwnd(ii,jj).gt.amaxv) amaxv=vwnd(ii,jj)
 enddo
 enddo
 write(IU06,*)'WAM READWND RECV u,v min-max ',aminu,amaxu, aminv,amaxv
 WRITE(IU06,*) 'WAM READWND RECV uwnd,vwnd(nc/2,nr/2) = ', \
                uwnd(nc/2,nr/2),vwnd(nc/2,nr/2)
 call mpi_recv(us_eta,nc*nr,MPI_REAL,atmos_proc_w,tagr,MPI_COMM_WORLD,status,ierr)
 call mpi_recv(z0_eta,nc*nr,MPI_REAL,atmos_proc_w,tag0,MPI_COMM_WORLD,status,ierr)
 amins=100000.
 amaxs=-100000.
 aminz=100000.
 amaxz=-100000.
 do ii=1,nc
 do jj=1,nr
    if (us_eta(ii,jj).lt.amins) amins=us_eta(ii,jj)
    if (us_eta(ii,jj).gt.amaxs) amaxs=us_eta(ii,jj)
    if (z0_eta(ii,jj).lt.aminz) aminz=z0_eta(ii,jj)
    if (z0_eta(ii,jj).gt.amaxz) amaxz=z0_eta(ii,jj)
 enddo
 enddo
 write(IU06,*)'WAM READWND RECV us_eta,z0_eta min-max ',amins,amaxs, aminz,amaxz
 WRITE(IU06,*) 'WAM READWND RECV us_eta,z0_eta(nc/2,nr/2) = ', \
                us_eta(nc/2,nr/2),z0_eta(nc/2,nr/2)
!end if
! CALL MPI_BARRIER(MPI_COMM_WORLD,ISTAT)

!
! ----------------------------------------------------------------------
!
!*    4. WRITE TEST OUTPUT.
!        ------------------
!
IF (ITEST.GE.3) THEN  
WRITE(IU06,*) 'SUB. READWND -  WIND FIELD FOR THE IDTWIR = ',IDTWIR
   WRITE (IU06, * ) '~~~ U Component From West to East ~~~'  
   DO 3250 J = NR, 1, - 1  
      WRITE ( * , * ) 'J=', J  
      WRITE (IU06, 66) (UWND (I, J), I = 1, NC)  
 3250    END DO  
   WRITE (IU06, * ) '~~~ V Component From South to North ~~~'  
   DO 3260 J = NR, 1, - 1  
      WRITE ( * , * ) 'J=', J  
      WRITE (IU06, 66) (VWND (I, J), I = 1, NC)  
 3260    END DO  
   66 FORMAT   (1X,20F5.1)  
ENDIF  

RETURN  
 3300 CONTINUE  
WRITE(IU06,*) ' *****************************************'  
WRITE(IU06,*) ' *                                       *'  
WRITE(IU06,*) ' *       FATAL ERROR IN SUB. READWND     *'  
WRITE(IU06,*) ' *       ===========================     *'  
WRITE(IU06,*) ' * READ ERROR OR EOF ON WIND FILE:       *'  
WRITE(IU06,*) ' * DATE OF WIND INPUT IS IDTWIR = ', IDTWIR  
WRITE(IU06,*) ' * PROGRAM TRIES TO READ STRING [ ', LINE, ' ] IOS=', IOS
WRITE(IU06,*) ' *                                       *'  
WRITE(IU06,*) ' *   PROGRAM ABORTS  PROGRAM ABORTS      *'  
WRITE(IU06,*) ' *                                       *'  
WRITE(IU06,*) ' *****************************************'  

CALL ABORT  
END SUBROUTINE readwnd
