SUBROUTINE readpre (iu07, irefra)  
! ----------------------------------------------------------------------
!**** *READPRE*  READ GRID OUTPUT FROM PREPROC.
!     H. GUNTHER      GKSS/ECMWF     MAY 1990
!*    PURPOSE.
!     --------
!       INPUT OF PREPROC GRID OUTPUT.
!**   INTERFACE.
!     ----------
!       *CALL* *READPRE (IU07, IREFRA)*
!          *IU07 *  - INPUT UNIT OF PREPROC GRID FILE.
!          *IREFRA *- REFRACTION OPTION.
!     METHOD.
!     -------
!       UNFORMATED READ FROM UNIT.
!     EXTERNALS.
!     ----------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use coupl
use current
use fredir
use gridpar
use indnl
use map
use cout
use shallow
use table
implicit none

INTEGER, INTENT(IN) :: iu07, irefra
! ----------------------------------------------------------------------
!*    1. READ COMMON FREDIR (FREQUENCY DIRECTION GRID).
!        ----------------------------------------------
1000 CONTINUE
READ (IU07) FR, DFIM, GOM, C, DELTH, DELTR, TH, COSTH, SINTH
!print*, FR, DFIM, GOM, C, DELTH, DELTR, TH, COSTH, SINTH
!*    2. READ COMMON GRIDPAR (GENERAL GRID ORGANISATION).
!        ------------------------------------------------
2000 CONTINUE
READ (IU07) DELPHI, DELLAM, SINPH, COSPH, IGL, IJS, IJL2, IJLS, IJL, IJLT
!print*, DELPHI, DELLAM, SINPH, COSPH, IGL, IJS, IJL2, IJLS, IJL, IJLT
!*    3. READ COMMON MAP (LONG. AND LAT. INDICES OF GRID POINTS).
!        --------------------------------------------------------
3000 CONTINUE
READ (IU07) IXLG, KXLT, NX, NY, IPER, AMOWEP, AMOSOP, AMOEAP, AMONOP, XDELLA, XDELLO
!*    4. READ COMMON INDNL (NON-LINEAR INTERACTION).
!       --------------------------------------------
4000 CONTINUE
READ (IU07) IKP, IKP1, IKM, IKM1, K1W, K2W, K11W, K21W, AF11, &
 FKLAP, FKLAP1, FKLAM, FKLAM1, ACL1, ACL2, CL11, CL21, DAL1, DAL2, FRH
!*    5. READ COMMON COUPLE.
!        -------------------
5000 CONTINUE
READ (IU07) BETAMAX, ZALP, ALPHA, XKAPPA, XNLEV
!*    6. READ COMMON TABLE (INDICES OF OUTPUT POINTS).
!        ---------------------------------------------
6000 CONTINUE  
READ (IU07) TAUT, DELTAUW, DELU, TAUHFT, DELUST, DELALP
!*    7. READ COMMON COUT (INDICES OF OUTPUT POINTS).
!        --------------------------------------------
7000 CONTINUE
READ (IU07) NGOUT, IGAR, IJAR
!*    8. READ COMMON SHALLO (DEPTH AND SHALLOW WATER TABLES).
!        ----------------------------------------------------
8000 CONTINUE
READ (IU07) DEPTH, DEPTHA, DEPTHD, TCGOND, TFAK, TSIHKD
!*    9. READ COMMON CURRENT.
!        --------------------
9000 CONTINUE
IF (IREFRA.EQ.2) THEN
   PRINT *, 'READING U,V CURRENTS'
   READ (IU07) U, V
END IF

RETURN
END SUBROUTINE readpre
