SUBROUTINE readbou (iu09, iu10, iu06)  
! ----------------------------------------------------------------------
!**** *READBOU* - READ COARSE AND FINE GRID BOUNDARY INFORMATION FILE.
!     R. PORTZ     MPI          JANUARY 1991
!*    PURPOSE.
!     --------
!       READ COMMON CBOUND AND FBOUND AS WRITTEN BY PREPROC.
!**   INTERFACE.
!     ----------
!       *CALL* *READBOU (IU09, IU10, IU06)*
!          *IU09*    - INPUT  UNIT OF COMMON CBOUND.
!          *IU10*    - INPUT  UNIT OF COMMON FBOUND.
!          *IU06*    - PRINTER OUTPUT UNIT.
!     METHOD.
!     -------
!       SEQUENCIAL UNFORMATED WRITE TO UNIT.
!     EXTERNALS.
!     ----------
!       *ABORT*     - TERMINATES PROCESSING.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use cbound
use fbound
implicit none

INTEGER, INTENT(IN) :: iu09, iu10, iu06
INTEGER*4 :: IIJARC (NMAXC), IIGARC (NMAXC)  !cpk-integer4 for the -i8 option
INTEGER*4 :: I, IO, NEST  !cpk-i4 instead of i8
REAL    :: BU1, BU2, BU3, BU4, BU5, BU6

! ----------------------------------------------------------------------
 1000 CONTINUE  
IF (IBOUNC.EQ.1) THEN  
!     READ COMMON BOUNC
   DO NEST = 1, NESTS  
      READ (IU09, ERR = 2000) NBOUNC (NEST)  
      READ (IU09, ERR = 2000) (IIGARC (I), I = 1, NBOUNC (NEST) ), &
       (IIJARC (I), I = 1, NBOUNC (NEST) )
      READ (IU09, ERR = 2000) BU1, BU2, BU3, BU4, BU5, BU6, &
       (BU1, I = 1, NBOUNC (NEST) ), (BU1, I = 1, NBOUNC (NEST) )
      DO I = 1, NBOUNC (NEST)  
         IGARC (I, NEST) = IIGARC (I)  
         IJARC (I, NEST) = IIJARC (I)  
      ENDDO  
!        CHECK THE DIMENSION
      IF (NMAXC.LT.NBOUNC (NEST) ) THEN  
         WRITE(IU06,*) '*********************************'  
         WRITE(IU06,*) 'NEST NUMBER:', NEST  
         WRITE(IU06,*) '*  FATAL ERROR IN SUB. READBOU  *'  
         WRITE(IU06,*) '*  ===========================  *'  
         WRITE(IU06,*) '*                               *'  
         WRITE(IU06,*) '*   NMAXC < NBOUNC              *'  
         WRITE(IU06,*) '*                               *'  
         WRITE(IU06,*) '*   NMAXC:', NMAXC, 'NBOUNC:', NBOUNC (NEST)  
         WRITE(IU06,*) '*                               *'  
         WRITE(IU06,*) '*********************************'  
         CALL ABORT  
      ENDIF  
   END DO  
ENDIF  

IF (IBOUNF.EQ.1) THEN  
!     READ COMMON BOUNF
   READ (IU10, ERR = 2000) NBOUNF  
   READ (IU10, ERR = 2000) (IGARF (I), I = 1, NBOUNF), (IJARF (I), &
    I = 1, NBOUNF), (IBFL (I), I = 1, NBOUNF), (IBFR (I), I = 1, &
    NBOUNF), (BFW (I), I = 1, NBOUNF)
!        CHECK THE DIMENSION
   WRITE (IU06, '(''1BOUNDARY INPUT POINTS FOR THIS GRID:'')')  
   DO IO = 1, NBOUNF  
      WRITE (IU06, '(4X,I5,4I8,F10.4)') IO, IGARF (IO) , IJARF ( &
       IO) , IBFL (IO) , IBFR (IO) , BFW (IO)
   END DO  
!
   IF (NMAXF.LT.NBOUNF) THEN  
      WRITE(IU06,*) '*********************************'  
      WRITE(IU06,*) '*  FATAL ERROR IN SUB. READBOU  *'  
      WRITE(IU06,*) '*  ===========================  *'  
      WRITE(IU06,*) '*                               *'  
      WRITE(IU06,*) '*   NMAXF < NBOUNF              *'  
      WRITE(IU06,*) '*                               *'  
      WRITE(IU06,*) '*   NMAXF: ', NMAXF, ' NBOUNF: ', NBOUNF  
      WRITE(IU06,*) '*                               *'  
      WRITE(IU06,*) '*********************************'  
      CALL ABORT  
   ENDIF  
ENDIF  
RETURN  
2000 CONTINUE  
WRITE(IU06,*) '****************************************'  
WRITE(IU06,*) '*                                      *'  
WRITE(IU06,*) '*    FATAL ERROR IN SUB. READBOU       *'  
WRITE(IU06,*) '*    ===========================       *'  
WRITE(IU06,*) '*                                      *'  
WRITE(IU06,*) '*        READ ERROR                    *'  
WRITE(IU06,*) '*                                      *'  
WRITE(IU06,*) '*        PROGRAM ABORTS                *'  
WRITE(IU06,*) '****************************************'  
CALL ABORT  
END SUBROUTINE readbou
