SUBROUTINE prspp (iunit, idate, xlong, xlat, name, waveht, wavedir, wavemfr,&
                  windspd, winddir, rough, wu10, fr, theta, spec, idd, idf)
! -----------------------------------------------------------------
!***  *PRSPP* -  PRINTS A SPECTRUM, THE WAVE HEIGHT , WAVE DIRECTION,
!*               USTAR AND WIND DIRECTION.
!         M. DE LAS HERAS  KNMI/PCM  FEBRUARY  1990
!*    PURPOSE.
!     --------
!        PRINT A WAVE MODEL SPECTRUM.
!**   INTERFACE.
!     ----------
!       *CALL* *PRSPP (IUNIT, IDATE, XLONG, XLAT, NAME,
!                      WAVEHT, WAVEDIR, WAVEMFR, WINDSPD, WINDDIR,
!                      FR, THETA, SPEC, IDD, IDF, NANG, NFRE)*
!         *IUNIT*   INTEGER    OUTPUT UNIT.
!         *IDATE*   CHAR*12    DATE OF SPECTRUM (YYMMDDHHMM).
!         *XLONG*   REAL       LONGITUDE OF SPECTRUM (DEGREE).
!         *XLAT*    REAL       LATITUDE OF SPECTRUM (DEGREE).
!         *NAME*    CHARACTER  SIDE NAME.
!         *WAVEHT*  REAL       SIGNIFICANT WAVE HEIGHT (METRES).
!         *WAVEDIR* REAL       MEAN WAVE DIRECTION (DEGREE).
!         *WAVEMFR* REAL       MEAN WAVE FREQUENCY (HERTZ).
!         *WINDSPD* REAL       FRICTION VELOCITY (METRES/SECOND).
!         *WINDDIR* REAL       WIND DIRECTION (DEGREES).
!         *FR*      REAL       FREQUENCY ARRAY IN HERTZ.
!         *THETA*   REAL       DIRECTION ARRAY IN RAD.
!         *SPEC*    REAL       SPECTRUM.
!         *IDD*     INTEGER    DIMENSION OF DIRECTION ARRAYS.
!         *IDF*     INTEGER    DIMENSION OF FREQUENCY ARRAYS.
!         *NANG*    INTEGER    NUMBER OF DIRECTIONS.
!         *NFRE*    INTEGER    NUMBER OF FREQUENCIES.
!     METHOD.
!     -------
!       NONE.
!     EXTERNALS.
!     ----------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ------------------------------------------------------------------
use params
implicit none

INTEGER  , INTENT(IN):: iunit, idd, idf
CHARACTER, INTENT(IN):: idate * 12, NAME * 20
REAL     , INTENT(IN):: rough, wu10, waveht, wavedir, wavemfr, windspd, winddir
REAL     , INTENT(IN):: xlong, xlat, fr(idf), theta(idd), spec(idd,idf)
INCLUDE'globals.h'
INTEGER,PARAMETER :: IPDIR = 12
REAL      :: ANG(NANG), ODSPEC(NFRE)
CHARACTER :: FORM1 * 50, FORM2 * 50, FORM3 * 50
!       *IPDIR*   INTEGER   NUMBER OF DIRECTIONS PRINTED PER LINE.
!       *ANG*     REAL      DIRECTIONS IN DEGREE.
!       *ODSPEC*  REAL      1-D SPECTRUM.  (M*M/HERTZ)
!       *FORM *   CHAR      VARIABLE FORMATS.
INTEGER  :: K, M, IP, IPE, LEN
REAL     :: DELTH
! ------------------------------------------------------------------
!*    1. INITIALISE DIRECTIONS.
!        ----------------------
DELTH = ZPI / REAL (NANG)  
DO K = 1, NANG  
   ANG (K) = THETA (K) * DEG  
END DO  
!*    2. COMPUTE 1-D SPECTRUM.
!        ---------------------
DO M = 1, NFRE  
   ODSPEC (M) = 0.0  
   DO K = 1, NANG  
      ODSPEC (M) = ODSPEC (M) + SPEC (K, M)  
   END DO  
   ODSPEC (M) = ODSPEC (M) * DELTH  
END DO  
!*    3. PRINT SPECTRUM.
!        ---------------
WRITE (IUNIT, 4100) IDATE, NAME, XLONG, XLAT  
 4100 FORMAT(1H1,2X,'WAVE AND WIND INFORMATION. DATE: ',A10, &
&       ' SIDE: ',A20,3X,'LONG.: ',F7.2,' LAT.: ',F6.2)
WRITE (IUNIT, 4200) WAVEHT, WAVEDIR, WAVEMFR, WINDSPD, WINDDIR  

 4200 FORMAT(3X,'HS = ',F6.2,'  THETA = ',F6.0,'  FMEAN = ',F6.4, &
&          '  USTAR = ',F 6.2,'  PHI = ',F6.0/)
WRITE (IUNIT, 4201) 'WAMDATE:', IDATE, XLONG, XLAT, WAVEHT, &
 WAVEDIR, WAVEMFR, WINDSPD, WINDDIR, ROUGH * 1.E4, WU10
!4201 FORMAT(A8,1x,A10,F7.2,F6.2,3X,F6.2,F6.0,1x,F6.4,F6.2,F6.0)

 4201 FORMAT(A8,1x,A10,F7.2,F6.2,1X,F6.2,F6.0,1x,F6.4,F6.2,F6.0 &
& ,1x,F7.4,1x,F6.2)
! ----------------------------------------------------------------------
IPE = 0  
IF (NANG.GT.IPDIR) THEN  
FORM1 = '(1X,''DIR (DEG)'',T11,12F8.1,''  DIR (DEG)'')'  
   WRITE (FORM1 (21:22) , '(I2)') IPDIR  
   FORM2 = '(1X,F7.4,2X,12F8.3,F9.4)'  
   WRITE (FORM2 (13:14) , '(I2)') IPDIR  
FORM3 = '(1X,''FREQ (HZ)'',T11, 96X,''  FREQ (HZ)'')'  
   WRITE (FORM3 (21:23) , '(I3)') IPDIR * 8  
   DO IP = 1, NANG - IPDIR, IPDIR  
      IPE = IP + IPDIR - 1  
      WRITE (IUNIT, FORM1) (ANG (K), K = IP, IPE)  
      WRITE (IUNIT, FORM3)  
      WRITE (IUNIT, FORM2) (FR (M), (SPEC (K, M), K = IP, IPE), &
       FR (M), M = 1, NFRE)
      WRITE (IUNIT, FORM1) (ANG (K), K = IP, IPE)  
      WRITE (IUNIT, '(1X)')  
   END DO  
ENDIF  
IP = IPE+1  
IPE = NANG  
LEN = IPE-IP + 1  
FORM1 = '(1X,''DIR (DEG)'',T11,12F8.1,''  DIR (DEG)'')'  
WRITE (FORM1 (21:22) , '(I2)') LEN  
FORM2 = '(1X,F7.4,2X,12F8.3,F9.4,F10.3)'  
WRITE (FORM2 (13:14) , '(I2)') LEN  
FORM3 = '(1X,''FREQ (HZ)'',T11, 96X,''  FREQ (HZ) 1-DSPEC'')'  
WRITE (FORM3 (21:23) , '(I3)') LEN * 8  
WRITE (IUNIT, FORM1) (ANG (K), K = IP, IPE)  
WRITE (IUNIT, FORM3)  
WRITE (IUNIT, FORM2) (FR (M), (SPEC (K, M), K = IP, IPE), FR (M), &
 ODSPEC (M), M = 1, NFRE)
WRITE (IUNIT, FORM1) (ANG (K), K = IP, IPE)  

RETURN  
END SUBROUTINE prspp
