SUBROUTINE prewind
! ----------------------------------------------------------------------
!**** *PREWIND* - PREPARES WIND DATA FOR WAVE MODEL.
!     P.GROENWOUD     DELFT HYDRAULICS LABORATORY  OKTOBER 1986
!     E. BAUER        MPI       FEB 1987   VERSION FOR CDC 205 HAMBURG.
!     S. HASSELMANN   MPI       MAY 1987   COMBINED CDC 205 AND CRAY
!     W. BRUEGGEMANN  MPI    AUGUST 1988   SIMPLIFIED PROGRAM.
!     L. ZAMBRESKY    ECMWF    JUNE 1988   MODIFIED EXTENSIVELY FOR
!                                          COUPLING TO SPECTRAL MODEL.
!     H. GUNTHER      ECMWF    JUNE 1990   MODIFIED FOR CYCLE_4.
!*    PURPOSE.
!     --------
!       EVALUATE WIND SPEED AND DIRECTION AT WAVE MODEL GRID POINTS.
!**   INTERFACE.
!     ----------
!       *CALL* *PREWIND (NC, NR)*
!          *NC*    FIRST  DIMENSION OF INPUT WIND FIELD.
!          *NR*    SECOND DIMENSION OF INPUT WIND FIELD.
!       *UNIT* *DESCRIPTION*
!          IU01    INPUT WIND DATA (SUB READWND).
!          IU06    PRINTER OUTPUT (SUB INITMDL).
!          IUVELO  OUTPUT OF BLOCKED WIND FIELDS. (SUB CREWFN).
!          IUSCR   SCRATCH UNITS FOR ALL BLOCKS (INTERMEDIATE STORAGE,
!                  INPUT/OUTPUT) (SUB INITMDL).
!     METHOD.
!     -------
!       INPUT WIND FIELDS WHICH CAN BE COMPONENTS OF
!                USTAR, U10, USTRESS
!       ARE TRANSFORMED TO FRICTION VELOCITIES.
!       THE INPUT FIELDS HAVE TO BE ON A LAT /LONG GRID.
!       SEE SUB READWND FOR FORMATS AND HEADER INFORMATION,
!       WHICH HAVE TO BE GIVEN TO THE PROGRAM.
!       A DOUBLE LINEAR INTERPOLATION IN SPACE IS PERFORMED
!       ONTO THE MODEL BLOCKS.
!       IF THE WIND OUTPUT TIMSTEP IS LESS THAN THE INPUT TIMESTEP
!       A LINEAR INTERPOLATION IN TIME IS PERFORMED.
!       THERE ARE TWO POSSIBILITIES WITH RESPECT TO THE WIND
!       OUTPUT FILES:
!           1. PROPAGATION TIMESTEP >= WIND INPUT STEP
!              ONE OUTPUT FILE CONTAINS IDELPRO/IDELWO WINDFIELDS
!              I.E. INFORMATION FOR ONE PROPAGATION TIMESTEP.
!              TIME FILE(I+1)= TIME FILE(I)+ IDELPRO
!           2. PROPAGATION TIMESTEP < INPUT WIND TIMESTEP
!              ONE OUTPUT FILE CONTAINS IDELWI/IDELWO WINDFIELDS
!              I.E. INFORMATION FOR ONE WIND INPUT TIMESTEP.
!              TIME FILE(I+1)= TIME FILE(I) + IDELWI
!     EXTERNALS.
!     ----------
!       *ABORT*     - TERMINATES PROCESSING.
!       *AIRSEA*    - SURFACE LAYER STRESS.
!       *CREWFN*    - CREATES A WIND FILE NAME.
!       *GETWND*    - PROCESSES ONE WIND FIELD.
!       *INCDAT*    - INCREMENTS DATE TIME GROUP.
!       *LOCINT*    - INTERPOLATES IN SPACE.
!       *NOTIM*     - STEERING SUB FOR INTERPOLATION IN SPACE ONLY.
!       *READWND*   - READS A WIND FIELD.
!       *TIMIN*     - STEERING SUB FOR INTERPOLATION IN SPACE AND TIME.
!       *WAMWND*    - BLOCKS A WIND FIELD AND CONVERTS TO USTAR.
!     REFERENCE.
!     -----------
!       NONE.
! ----------------------------------------------------------------------
USE wind1 ; USE params ; USE gridpar ; USE stat
USE testo ; USE units  ; USE wind    ; USE wndgrd
IMPLICIT NONE

CHARACTER (LEN=12) :: idtwie, idtwis
INTEGER :: idelwh
! ----------------------------------------------------------------------
!*    1. BEGIN AND END DATES OF WIND FIELDS TO BE PROCESSED.
!        ---------------------------------------------------
IF( ida .EQ. '000000000000' ) THEN
!        IF START FROM PRESET FIELDS DO FIRST FIELD IN ADDITION.
   idtwis = idatea
ELSE
   idtwis = idawifl
   idelwh = - MAX (idelpro, idelwi) + idelwo
   CALL incdate (idtwis, idelwh)
ENDIF
IF( idawifl .LT. idatee ) then
   idtwie = idawifl
ELSE
   idtwie = idatee
ENDIF
! ----------------------------------------------------------------------
!*    2. PROCESS WIND FIELDS.
!        --------------------
 2000 CONTINUE
IF( idelwo .GE. idelwi ) THEN
!*    2.1 NO TIME INTERPOLATION.
!         ----------------------
   IF( itest .GE. 2 ) THEN
      WRITE(iu06,*) '   SUB. PREWIND: WIND REQUEST'
      WRITE(iu06,*) '     NO TIME INTERPOLATION'
      WRITE(iu06,*) '     START OF PERIOD IS    IDTWIS = ', idtwis
      WRITE(iu06,*) '     END   OF PERIOD IS    IDTWIE = ', idtwie
      WRITE(iu06,*) '     WIND INPUT TIME STEP  IDELWI = ', idelwi
      WRITE(iu06,*) '     WIND OUTPUT TIME STEP IDELWO = ', idelwo
   ENDIF
   CALL notim (idtwis, idtwie)
ELSE
!*    2.2 TIME INTERPOLATION.
!         -------------------
   IF( itest .GE. 2 ) THEN
      WRITE(iu06,*) '   SUB. PREWIND: WIND REQUEST'
      WRITE(iu06,*) '     TIME INTERPOLATION'
      WRITE(iu06,*) '     START OF PERIOD IS    IDTWIS = ', idtwis
      WRITE(iu06,*) '     END   OF PERIOD IS    IDTWIE = ', idtwie
      WRITE(iu06,*) '     WIND INPUT TIME STEP  IDELWI = ', idelwi
      WRITE(iu06,*) '     WIND OUTPUT TIME STEP IDELWO = ', idelwo
   ENDIF
   CALL timin (idtwis, idtwie)
ENDIF

RETURN
END SUBROUTINE prewind
