MODULE couple_mpi
IMPLICIT NONE
include 'mpif.h'
SAVE
INTEGER*4 :: ierr,myrank, npes2, mype2,status(MPI_STATUS_SIZE)
INTEGER*4,PARAMETER :: tag1=111, tag2=112, tag3 = 113, tag4=114, tag5 = 115
INTEGER*4,PARAMETER :: tagu=123, tagv=1234, tagw=12345, tagi=123456, tagz=321
INTEGER*4,PARAMETER :: tagh=4321, tagd=1777, tagm=1779, taga=1801, tags=1803
INTEGER*4,PARAMETER :: tagr=1810, tag0=1815
INTEGER*4 :: ihrst,ihr,idat(3)
REAL :: etantsd, waventsd
! Define proc number used by wam ; Define processor number that atmos sends data
! atmos_proc_w : atmos proc that sends winds
! atmos_proc_c : atmos proc that receives charnock
!2x2 INTEGER,PARAMETER :: INPES=2, JNPES=2, NPES_MOD=INPES*JNPES
!2x2 INTEGER,PARAMETER :: wam_proc = 4 , atmos_proc_w = 4 , atmos_proc_c=2
!2x3 INTEGER,PARAMETER :: wam_proc = 6 , atmos_proc_w = INPES*JNPES , atmos_proc_c=4
INTEGER*4,PARAMETER :: INPES=4, JNPES=4, NPES_MOD=INPES*JNPES
INTEGER*4,PARAMETER :: wam_proc = 16 , atmos_proc_w = INPES*JNPES , atmos_proc_c=4
END MODULE couple_mpi

MODULE coupl
IMPLICIT NONE
SAVE
!*    *COMMON* *COUPL* - PARAMETERS FOR COUPLING.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *BETAMAX*   REAL      PARAMETER FOR WIND INPUT.
!      *ZALP*      REAL      SHIFTS GROWTH CURVE.
!      *ALPHA*     REAL      CHARNOCK CONSTANT.
!      *XKAPPA*    REAL      VON KARMAN CONSTANT.
REAL :: betamax, zalp, alpha, xkappa, xnlev
END MODULE coupl

MODULE flushfiles
IMPLICIT NONE
SAVE
CHARACTER (LEN=80) :: blsfile, lawfile
END MODULE flushfiles

MODULE idfout1
IMPLICIT NONE
SAVE
INTEGER :: srcount
END MODULE idfout1

MODULE idfout
IMPLICIT NONE
SAVE
CHARACTER (LEN=12) :: idtout
END MODULE idfout

MODULE indir
IMPLICIT NONE
SAVE
! Eldad 06-jan-97
CHARACTER (LEN=100) :: indirname
END MODULE indir

#ifndef _OPENMP
MODULE my_omp
CONTAINS

INTEGER FUNCTION omp_get_thread_num
IMPLICIT NONE
omp_get_thread_num=0
END FUNCTION omp_get_thread_num

INTEGER FUNCTION omp_get_max_threads
omp_get_max_threads=1
END FUNCTION omp_get_max_threads

END MODULE my_omp
#endif

MODULE stat
IMPLICIT NONE
SAVE
!*    *COMMON* *STATUS* - TIME STATUS OF INTEGRATION, WIND INPUT,
!                         OUTPUT OF RESULTS, AND MODEL OPTIONS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *IDATEA*    CHAR*12   START DATE OF RUN  (YYMMDDHHMM).
!      *IDATEE*    CHAR*12   END DATE OF RUN (YYMMDDHHMM).
!      *IDTPRO*    CHAR*12   END DATE OF PROPAGATION.
!      *IDELPRO*   INTEGER   TIMESTEP WAM PROPAGATION IN SECONDS.
!      *IDELT*     INTEGER   TIMESTEP SOURCE FUNCTION IN SECONDS.
!      *IDELWI*    INTEGER   INPUT WIND TIMESTEP PREWIND IN SECONDS.
!      *IDELWO*    INTEGER   OUTPUT WIND TIMESTEP IN SECONDS
!                            EQUAL TO INPUT WIND TIMESTEP INTO WAMODEL.
!      *IREST*     INTEGER   RESTART FILE SAVE OPTION.
!                            = 1  RESTART FILES ARE SAVED
!                            OTHERWISE RESTART FILES ARE NOT SAVED.
!      *IDELRES*   INTEGER   OUTPUT AND RESTART FILE DISPOSE TIMESTEP.
!      *IDTRES*    CHAR*12   NEXT DATE TO SAVE OUTPUT AND RESTART FILES.
!      *IDELINT*   INTEGER   INTEG. PARAMETER (TOTAL SEA)  OUTPUT
!                            TIMESTEP IN SECONDS.
!      *IDTINTT*   CHAR*12   NEXT DATE TO WRITE INTEG. PARA. (TOTAL)
!      *IDELINS*   INTEGER   INTEG. PARAMETER (SEA + SWELL) OUTPUT
!                            TIMESTEP IN SECONDS.
!      *IDTINTS*   CHAR*12   NEXT DATE TO WRITE INTEG PAR (SEA + SWELL).
!      *IDELSPT*   INTEGER   SPECTRA (TOTAL) OUTPUT TIMESTEP IN SECONDS.
!      *IDTSPT*    CHAR*12   NEXT DATE TO WRITE SPECTRA (TOTAL).
!      *IDELSPS*   INTEGER   SPECTRA (SEA + SWELL) OUTPUT
!                            TIMESTEP IN SECONDS.
!      *IDTSPS*    CHAR*12   NEXT DATE TO WRITE SPECTRA  (SEA + SWELL).
!      *ICASE*     INTEGER   PROPAGATION FLAG
!                            = 1  SPHERICAL COORDINATES
!                            OTHERWISE CARTESIAN COORDINATES.
!      *ISHALLO*   INTEGER   SHALLOW WATER MODEL FLAG
!                            = 1  DEEP WATER MODEL
!                            OTHERWISE  SHALLOW WATER MODEL.
!      *IREFRA*    INTEGER   REFRACTION OPTION..
!                            = 0  NO REFRACTION.
!                            = 1 DEPTH REFRACTION.
!                            = 2 DEPTH AND CURRENT REFRACTION.
!     A NEW VARIABLE IDTSOU (CHARACTER*12) IS ADDED IN `STATUS'
!     COMMON BLOCK.

CHARACTER (LEN=12) :: idatea, idatee, idtpro, idtres, idtintt,        &
                      idtints, idtspt, idtsps, idtsou
INTEGER ::            idelpro, idelt, idelwi, idelwo, irest, idelres, &
                      idelint, idelins, idelspt, idelsps, icase,      &
                      ishallo, irefra
END MODULE stat

MODULE table
IMPLICIT NONE
SAVE
!*    *COMMON* *TABLE* - TABLE FOR TOTAL STRESS AND HIGH FREQ STRESS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *ITAUMAX*   INTEGER   TABLE DIMENSION.
!      *JUMAX*     INTEGER   TABLE DIMENSION.
!      *IUSTAR*    INTEGER   TABLE DIMENSION.
!      *IALPHA*    INTEGER   TABLE DIMENSION.
!      *TAUT*      REAL      STRESS TABLE.
!      *DELTAUW*   REAL      WAVE STRESS INCREMENT.
!      *DELU*      REAL      WIND INCREMENT.
!      *TAUHFT*    REAL      HIGH FREQUENCY STRESS TABLE.
!      *DELUST*    REAL      USTAR INCREMENT.
!      *DELALP*    REAL      ALPHA INCREMENT.
INTEGER,PARAMETER :: itaumax = 100, jumax = 100, iustar = 100, ialpha = 100
REAL              :: taut(0:itaumax,0:jumax),deltauw,delu
REAL              :: tauhft(0:iustar,0:ialpha),delust,delalp
END MODULE table

MODULE testo
IMPLICIT NONE
SAVE
!*    *COMMON* *TESTO* - PRINTER OUTPUT UNIT AND TEST FLAGS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *IU06*      INTEGER   UNIT FOR PRINTER OUTPUT.
!      *ITEST*     INTEGER   TEST OUTPUT LEVEL:
!                             .LE. 0  NO OUTPUT
!                             .GE. I  OUTPUT TO SUB. LEVEL I
!      *ITESTB*    INTEGER   MAX BLOCK NUMBER FOR OUTPUT IN BLOCK LOOPS
INTEGER*4 :: iu06, itest, itestb
END MODULE testo

MODULE text
IMPLICIT NONE
SAVE
!*    *COMMON* *TEXT* - FILE NAME INFORMATION.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *USERID*    CHARACTER USERID FOR FILE NAMES.
!      *RUNID*     CHARACTER RUN IDENTIFIER FOR FILE NAMES.
!      *PATH*      CHARACTER PATH NAME FOR FILES.
CHARACTER :: userid * 3, runid * 3, path * 60
END MODULE text

MODULE params
IMPLICIT NONE
SAVE
!*    *PARAMETER*  FOR ARRAY DIMENSIONS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *NANG*      INTEGER   NUMBER OF ANGLES.
!      *NFRE*      INTEGER   NUMBER OF FREQUENCIES.
!      *NGX*       INTEGER   NUMBER OF LONGITUDES IN GRID.
!      *NGY*       INTEGER   NUMBER OF LATITUDES IN GRID.
!      *NBLO*      INTEGER   NUMBER OF BLOCKS.
!      *NIBLO*     INTEGER   NUMBER OF POINTS IN BLOCK.
!      *NOVER*     INTEGER   MAXIMUM NUUMBER POINTS IN FIRST LATITUDE
!                            OF BLOCKS.
!      *MOUTP*     INTEGER   MAXIMUM NUMBER OF OUTPUT POINTS.
!      *MOUTT*     INTEGER   MAXIMUM NUMBER OF OUTPUT TIMES.
!
!      *NMAXC*     INTEGER   NUMBER OF BOUNDARY OUTPUT POINTS, IF
!                            THIS IS A COARSE GRID; ELSE = 1.
!      *NMAXF*     INTEGER   NUMBER OF BOUNDARY POINTS, IF THIS IS
!                            A FINE GRID RUN; ELSE = 1.
!      *NBINP*     INTEGER   NUMBER OF BOUNDARY INPUT POINTS FROM A
!                            PREVIOUS COARSE GRID RUN, IF THIS IS A
!                            A FINE GRID RUN; ELSE = 1.
!      *NIBL1*     INTEGER   = NIBLO IF MULTI BLOCK VERSION.
!                            =     1 IF ONE BLOCK VERSION.
!      *NIBLD*     INTEGER   = NIBLO IF DEPTH OR CURRENT REFRACTION.
!                            = 1     ELSE.
!      *NBLD*      INTEGER   = NIBO  IF DEPTH OR CURRENT REFRACTION.
!                            = 1     ELSE.
!      *NIBLC*     INTEGER   = NIBLO IF CURRENT REFRACTION.
!                            = 1     ELSE.
!      *NBLC*      INTEGER   = NIBO  IF CURRENT REFRACTION.
!                            = 1     ELSE.
INTEGER*4, PARAMETER :: ngx = 1001, ngy = 381
INTEGER, PARAMETER :: nang = 24, nfre = 30,                        &
!INTEGER, PARAMETER :: nang = 20, nfre = 20,                        &
                      nblo = 1, niblo = 135044, nover = 1,         &
                      moutp = 1, moutt = 100
INTEGER, PARAMETER :: nmaxc = 313, nmaxf = 1, nbinp = 1
INTEGER, PARAMETER :: nibl1 = niblo, nibld = niblo, nbld = nblo,  &
                      niblc = niblo, nblc = nblo
! Specify number of nests that this run is supporting
INTEGER, PARAMETER :: nests = 1
! Variables for multithreaded execution
INTEGER             :: nprocs
INTEGER,ALLOCATABLE :: itask(:,:)
END MODULE params

MODULE wind1
IMPLICIT NONE
SAVE
!*    *PARAMETER*  FOR WIND INPUT ARRAY DIMENSIONS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *NC*        INTEGER   COLUMNES IN WIND INPUT GRID (DIMENSION)
!      *NR*        INTEGER   ROWS     IN WIND INPUT GRID (DIMENSION).
INTEGER*4, PARAMETER :: nc = 1001, nr = 381
END MODULE wind1

MODULE wndgrd
IMPLICIT NONE
SAVE
!*    *COMMON* *WNDGRD* -  INPUT WIND GRID SPECIFICATIONS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *DLAM*      REAL      STEPSIZE BETWEEN LONGITUDES IN DEG.
!      *DPHI*      REAL      STEPSIZE BETWEEN LATITUDES  IN DEG.
!      *RLATS*     REAL      LATITUDE  AT (., 1) = SOUTHERN LATITUDE.
!      *RLATN*     REAL      LATITUDE  AT (.,NR) = NORTHERN LATITUDE.
!      *RLONL*     REAL      LONGITUDE AT ( 1,.) = WEST MOST LONGITUDE.
!      *RLONR*     REAL      LONGITUDE AT (NC,.) = EAST MOST LONGITUDE.
!      *KCOL*      INTEGER   NUMBER OF COLUMNES IN WIND INPUT (USED).
!      *KROW*      INTEGER   NUMBER OF ROWS     IN WIND INPUT (USED).
!      *ICODE*     INTEGER   WIND CODE 1 = USTAR;  2 = USTRESS; 3 = U10
!      *IWPER*     INTEGER   INDICATOR PERIODICAL GRID.
!                            0= NON-PERIODICAL;   1= PERIODICAL.
!      *ICOORD*    INTEGER   CODE FOR COORDINATE SYSTEM USED
!                            1= RECTANGULAR,EQUIDISTANT LON/LAT GRID.
!                            2= .......NOT IMPLEMENTED.
REAL    :: dlam, dphi, rlats, rlatn, rlonl, rlonr
INTEGER :: kcol, krow, iwper, icode, icoord
END MODULE wndgrd
