SUBROUTINE outspp (fl3, fl1, ig, iu25, iu26)  
! ----------------------------------------------------------------------
!**** *OUTSPP* -  OUTPUT OF SPECTRA , WAVE HEIGHT , WAVE DIRECTION,
!****             USTAR AND WIND DIRECTION AT GIVEN OUTPUT POINTS.
!      S.D.HASSELMANN.
!      P.JANSSEN       KNMI         FEBRUARY 1986
!      P. LIONELLO                  FEBRUARY 1987
!                  OUTPUT OF SWELL 2-D DISTRIBUTION , SWELL WAVE HEIGHT
!                  MEAN SWELL FREQUENCY , MEAN SWELL DIRECTION ,WIND-SE
!                  WAVE HEIGTH AND WIND SEA WAVE DIRECTION.
!      L. ZAMBRESKY   GKSS/ECMWF    JULY 89
!                 VARIANCE ENERGY SUMMED OVER FREQUENCY AND DIRECTION.
!      H. GUNTHER     ECMWF         OCTOBER 1990
!                 EXTENDED HEADER AND OUTPUT OF 1D SPECTRA IN PRINT.
!**   INTERFACE.
!     ----------
!        *CALL  OUTSPP (FL3, FL1, IG, IU25, IU26)*
!           *FL3*    -   BLOCK OF SPECTRA.
!           *FL1*    -   SWELL SPECTRUM.
!           *IG*     -   BLOCK NUMBER.
!           *IU25*   -   OUTPUT UNIT FOR SPECTRA.
!           *IU26*   -   OUTPUT UNIT FOR SEA AND SWELL SPECTRA.
!     EXTERNALS.
!     ----------
!       *PRSPP*     - PRINT A SPECTRUM.
!       *PRSPPS*    - PRINT A SWELL SPECTRUM.
!     METHOD.
!     -------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use fredir
use map
use meanpa
use cout
use swell
use stat
use testo
use wind
implicit none

REAL   , INTENT(IN):: fl3(0:niblo,nang,nfre), fl1(0:niblo,nang,nfre)
INTEGER, INTENT(IN):: ig, iu25, iu26
INCLUDE'globals.h'
REAL, PARAMETER :: CO = 1.1
!     PARAMETER (TH0 = 0., CO = 1.1)
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!        *TH0*     REAL      FIRST DIRECTION IN DEGREES.
!        *CO*      REAL      FREQUENCY RATIO.
CHARACTER:: NAME * 20
REAL     :: SPEC (NANG, NFRE)
INTEGER  :: K, M, IJ, NGOU
REAL     :: TH0, XLON, XLAT, XANG, XFRE, EWSEA, FWSEA
! ----------------------------------------------------------------------
TH0 = TH (1)  
!*    1. LOOP OVER OUTPUT POINTS.
!        ------------------------
DO 1001 NGOU = 1, NGOUT  
   IF (IG.EQ.IGAR (NGOU) ) THEN  
      IJ = IJAR (NGOU)  
      XLON = AMOWEP + REAL (IXLG (IJ, IG) - 1) * XDELLO  
      XLAT = AMOSOP + REAL (KXLT (IJ, IG) - 1) * XDELLA  
!*    1.1 TOTAL SPECTRUM.
!         ---------------
      IF (IDTSPT.EQ.IDTPRO) THEN  
!*    1.1.1 FILE OUTPUT TO IU25.
!           --------------------
!#ifndef out_spectra
         IF (FFLAG (13) ) THEN  
            XANG = REAL (NANG)  
            XFRE = REAL (NFRE)  
            WRITE (IU25) XLON, XLAT, IDTPRO, XANG, XFRE, TH0, FR(1), CO
            WRITE (IU25) 4. * SQRT (EMEAN (IJ) )  
            WRITE (IU25) DEG * THQ (IJ)  
            WRITE (IU25) FMEAN (IJ)  
            WRITE (IU25) USNEW (IJ)  
            WRITE (IU25) DEG * THWNEW (IJ)  
            WRITE (IU25) ((FL3(IJ,K,M),K=1, NANG), M=1,NFRE)
         ENDIF  
!#endif
!*    1.1.2 PRINT SPECTRUM.
!           ---------------
         IF (PFLAG (13) ) THEN  
            DO 1121 M = 1, NFRE  
               DO 1121 K = 1, NANG  
                  SPEC (K, M) = FL3 (IJ, K, M)  
 1121             CONTINUE  
            WRITE (NAME, '(''BL= '',I3,'' POINT= '',I4)') IG, IJ  
!                 CALL PRSPP (IU06, IDTPRO, XLON, XLAT, NAME,
!    1                   4.*SQRT(EMEAN(IJ)), DEG*THQ(IJ),
!    2                   FMEAN(IJ), USNEW(IJ), DEG*THWNEW(IJ),
!    3                   FR, TH, SPEC, NANG, NFRE)
            CALL PRSPP (IU06, IDTPRO, XLON, XLAT, NAME, 4. * SQRT &
             (EMEAN (IJ) ), DEG * THQ (IJ), FMEAN (IJ), USNEW (IJ), &
             DEG * THWNEW (IJ), Z0NEW (IJ), U10NEW (IJ), FR, TH, &
             SPEC, NANG, NFRE)
         ENDIF  
      ENDIF  
!PL****
!*    1.2 OUTPUT SWELL INFORMATION.
!         -------------------------
      IF (IDTSPS.EQ.IDTPRO) THEN  
         EWSEA = EMEAN (IJ) - ESWELL (IJ)  
         FWSEA = EWSEA / (EMEAN(IJ) / FMEAN(IJ) - ESWELL(IJ) / FSWELL(IJ))
         EWSEA = 4. * SQRT (EWSEA)  
         DO 1201 M = 1, NFRE  
            DO 1201 K = 1, NANG  
               SPEC (K, M) = FL1 (IJ, K, M) * FL3 (IJ, K, M)  
 1201          CONTINUE  
!*    1.2.1 FILE OUTPUT TO IU26.
!           --------------------
!#ifndef out_spectra
         IF (FFLAG (14) ) THEN  
            XANG = REAL (NANG)  
            XFRE = REAL (NFRE)  
            WRITE (IU26) XLON, XLAT, IDTPRO, XANG, XFRE, TH0, FR(1), CO
            WRITE (IU26) EWSEA, 4. * SQRT (ESWELL (IJ) )  
            WRITE (IU26) DEG * THWISEA (IJ), DEG * THSWELL (IJ)  
            WRITE (IU26) FWSEA, FSWELL (IJ)  
            WRITE (IU26) ((SPEC(K,M),K=1,NANG),M=1,NFRE)
         ENDIF  
!#endif
!*    1.2.2 PRINT OUTPUT TO IU26.
!           ---------------------
         IF (PFLAG (14) ) THEN  
            WRITE (NAME, '(''BL= '',I3,'' POINT= '',I4)') IG, IJ  
            CALL PRSPPS (IU06, IDTPRO, XLON, XLAT, NAME, EWSEA, &
             DEG * THWISEA (IJ), FWSEA, 4. * SQRT (ESWELL (IJ) ), &
             DEG * THSWELL (IJ), FSWELL (IJ), FR, TH, SPEC, NANG, &
             NFRE)
         ENDIF  
      ENDIF  
   ENDIF  
 1001 END DO  

RETURN  
END SUBROUTINE outspp
