#ifdef out_spectra
SUBROUTINE outspec (fl3, fl1, ig, iu25, ijs, ijl)  
! ----------------------------------------------------------------------
!**** *OUTSPP* -  OUTPUT OF SPECTRA , WAVE HEIGHT , WAVE DIRECTION,
!****             USTAR AND WIND DIRECTION AT GIVEN OUTPUT POINTS.
!      S.D.HASSELMANN.
!      P.JANSSEN       KNMI         FEBRUARY 1986
!      P. LIONELLO                  FEBRUARY 1987
!                  OUTPUT OF SWELL 2-D DISTRIBUTION , SWELL WAVE HEIGHT
!                  MEAN SWELL FREQUENCY , MEAN SWELL DIRECTION ,WIND-SE
!                  WAVE HEIGTH AND WIND SEA WAVE DIRECTION.
!      L. ZAMBRESKY   GKSS/ECMWF    JULY 89
!                 VARIANCE ENERGY SUMMED OVER FREQUENCY AND DIRECTION.
!      H. GUNTHER     ECMWF         OCTOBER 1990
!                 EXTENDED HEADER AND OUTPUT OF 1D SPECTRA IN PRINT.
!**   INTERFACE.
!     ----------
!        *CALL  OUTSPP (FL3, FL1, IG, IU25, IU26)*
!           *FL3*    -   BLOCK OF SPECTRA.
!           *FL1*    -   SWELL SPECTRUM.
!           *IG*     -   BLOCK NUMBER.
!           *IU25*   -   OUTPUT UNIT FOR SPECTRA.
!           *IU26*   -   OUTPUT UNIT FOR SEA AND SWELL SPECTRA.
!     EXTERNALS.
!     ----------
!       *PRSPP*     - PRINT A SPECTRUM.
!       *PRSPPS*    - PRINT A SWELL SPECTRUM.
!     METHOD.
!     -------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use fredir
use map
use meanpa
use swell
use testo
use wind
implicit none

REAL   , INTENT(IN):: fl3(0:niblo,nang,nfre), fl1(0:niblo,nang,nfre)
INTEGER, INTENT(IN):: ig, iu25, ijs, ijl
INCLUDE'globals.h'
REAL :: UNISPE (NFRE)
PARAMETER (CO = 1.1)
!     PARAMETER (TH0 = 0., CO = 1.1)
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!        *TH0*     REAL      FIRST DIRECTION IN DEGREES.
!        *CO*      REAL      FREQUENCY RATIO.
CHARACTER:: NAME * 20
REAL     :: SPEC (NANG, NFRE), ANG (NANG), UNISPE(NFRE)
REAL     :: TH0, XLON, XLAT
INTEGER  :: K, M, IJ
! ----------------------------------------------------------------------
TH0 = TH (1)  
DO K = 1, NANG  
   ANG (K) = TH (K) * DEG  
END DO  
!*    1. LOOP OVER OUTPUT POINTS.
!        ------------------------
IF (FFLAG (13) ) THEN  
   WRITE (IU25, * ) IJS, IJL, IG  
   WRITE (IU25, * ) IXLG, KXLT  
   WRITE (IU25, * ) (FR (M), M = 1, NFRE)  
   DO IJ = IJS, IJL  
      XLON = AMOWEP + REAL (IXLG (IJ, IG) - 1) * XDELLO  
      XLAT = AMOSOP + REAL (KXLT (IJ, IG) - 1) * XDELLA  
!*    1.1 TOTAL SPECTRUM.
!         ---------------
!  FIND UNIDIRECTIONAL SPECTRA
      DO M = 1, NFRE  
         UNISPE (M) = 0.0  
         DO K = 1, NANG  
            UNISPE (M) = UNISPE (M) + FL3 (IJ, K, M)  
         ENDDO  
      ENDDO  
!*    1.1.1 FILE OUTPUT TO IU25.
!           --------------------
! ---- LON,LAT,
!  SIGNIFICANT WAVE HEIGHT,
!  WAVE DIRECTION,
!  MEAN FREQ
!  WIND DIRECTION
!  WIND SPEED AT 10m
!  SIGNIFICANT WAVE HEIGHT DUE TO SWELL ONLY
!  MEAN SWELL DIRECTION
!  MEAN SWELL FREQUENCY
      WRITE (IU25, * ) (UNISPE (M), M = 1, NFRE)  
      WRITE (IU25, * ) XLON, XLAT, 4. * SQRT (EMEAN (IJ) ), &
       DEG * THQ (IJ), FMEAN (IJ), DEG * THWNEW (IJ), U10NEW (IJ), &
       4. * SQRT (ESWELL (IJ) ), DEG * THSWELL (IJ), FSWELL (IJ)
!                 WRITE(IU25) ((FL3(IJ,K,M),K=1,NANG),M=1,NFRE)
   END DO  
ENDIF  
!PL****

RETURN  
END SUBROUTINE outspec
#endif
