SUBROUTINE outpp (idate, iuout, titl, const, array, amowep, amosop, amoeap, amonop)
! ---------------------------------------------------------------
!**** *OUTPP* - FORMATED OUTPUT OF AN ARRAY.
!     H. GUNTHER       ECMWF    NOVEMBER 1989
!*    PURPOSE.
!     --------
!       FORMATED OUTPUT OF AN ARRAY.
!**   INTERFACE.
!     ---------
!       *CALL* *OUTPP (IDATE, IUOUT, ID1, ID2, NGX, NGY, TITL, CONST,
!                      ARRAY, AMOWEP, AMOSOP, AMOEAP, AMONOP)*
!          *IDATE*    INTEGER   DATE (YYMMDDHHMM).
!          *IUOUT*    INTEGER   OUTPUT UNIT.
!          *ID1*      INTEGER   FIRST DIMENSION.
!          *ID2*      INTEGER   SECOND DIMENSION.
!          *NGX*      INTEGER   FIRST DIMENSION  USED.
!          *NGY*      INTEGER   SECOND DIMENSION USED.
!          *TITL*     CHARACTER HEADER TO BE PRINTED.
!          *CONST*    REAL      SCALING FACTOR.
!          *ARRAY*    REAL      ARRAY TO BE PRINTED.
!          *AMOWEP*   REAL      MOST WESTERN LONGITUDE (DEGREE).
!          *AMOSOP*   REAL      MOST SOUTHERN LATITUDE (DEGREE).
!          *AMOEAP*   REAL      MOST EASTERN LONGITUDE (DEGREE).
!          *AMONOP*   REAL      MOST NORTHERN LATITUDE (DEGREE).
!     METHOD.
!     -------
!       A TWO DIMENSIONAL ARRAY IS PRINTED WITH A MAXIMUM OF
!       30 COLUMNS PER PAGE.
!     EXTERNALS.
!     ----------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
implicit none

CHARACTER, INTENT(IN):: idate * 12, titl * 100
INTEGER  , INTENT(IN):: iuout
REAL     , INTENT(IN):: array(ngx,ngy), amowep, amosop, amoeap, amonop, const
INTEGER:: IARRAY(NGX,NGY), ILON(NGX)
REAL   :: YLAT(NGY)
REAL   :: DLAMA, DPHIA
INTEGER:: I, J, NPTS, NPAGE, ISTART, IEND, NP
! ----------------------------------------------------------------------
!*    1. INITIALIZATION
!     -----------------
DLAMA = (AMOEAP - AMOWEP) / FLOAT (NGX - 1)  
DO I = 1, NGX  
   ILON (I) = NINT (AMOWEP + (I - 1) * DLAMA)  
END DO  
DPHIA = (AMOSOP - AMONOP) / FLOAT (NGY - 1)  
DO J = 1, NGY  
   YLAT (J) = AMONOP + (J - 1) * DPHIA  
END DO  

NPTS = 30  

NPAGE = (NGX + NPTS - 1) / NPTS  
DO J = 1, NGY  
   DO I = 1, NGX  
      IARRAY (I, J) = NINT (CONST * ARRAY (I, J) )  
   ENDDO
ENDDO

ISTART = - NPTS + 1  
IEND = ISTART + NPTS - 1  

DO NP = 1, NPAGE  
   WRITE (IUOUT, 300) IDATE, TITL, NP  
   ISTART = ISTART + NPTS  
   IEND = MIN (IEND+NPTS, NGX)  
   WRITE (IUOUT, 302) (I, I = ISTART, IEND)  
   WRITE (IUOUT, 303) (ILON (I), I = ISTART, IEND)  
   WRITE (IUOUT, 304)  
   DO J = 1, NGY  
      WRITE (IUOUT, 305) J, YLAT (J), (IARRAY (I, J), I = ISTART, IEND)
   END DO  
END DO  
  300 FORMAT(1H1,6X,A10,2X,A100,5X,'PAGE ',I2,/)  
  302 FORMAT(7X,'I=',30I4)  
  303 FORMAT(5X,'LON=',30I4)  
  304 FORMAT('   J LAT',/)  
  305 FORMAT(1X,I2,F5.1,1X,30I4)  

RETURN  
END SUBROUTINE outpp
