SUBROUTINE outint (iu06, iu20, iu21)  
! ----------------------------------------------------------------------
!**** *OUTINT* - OUTPUT OF INTEGRATED FIELDS IS WRITTEN.
!     H. GUNTHER          ECMWF            JUNE 1990
!*    PURPOSE.
!     --------
!       OUTPUT OF WAVE AND WIND FIELDS IN GRIDDED FORMAT
!       TO DISK AND PRINTER.
!**   INTERFACE.
!     ----------
!       *CALL* *OUTINT (IU06, IU20, IU21)
!          *IU06*   - PRINTER OUTPUT UNIT.
!          *IU20*   - OUTPUT UNIT OF PARAMETERS OF TOTAL SPECTRUM.
!          *IU21    - OUTPUT UNIT OF SEA AND SWELL PARAMETER.
!     EXTERNALS.
!     ----------
!       *OUTPP*     - PRINTER OUTPUT OF AN ARRAY.
!     METHOD.
!     -------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use cout
use intpar
use stokesblock
use intspar
use map
use stat
implicit none

INTEGER, INTENT(IN) :: iu06, iu20, iu21
INCLUDE'globals.h'
CHARACTER :: TITL * 100
INTEGER   :: I, J
REAL      :: DNGX, DNGY
! ----------------------------------------------------------------------
!*    1. OUTPUT OF INTEGRATED PARAMETERS OF TOTAL SEE.
!        ---------------------------------------------
DNGX = FLOAT (NGX)  
DNGY = FLOAT (NGY)  
IF (IDTINTT.EQ.IDTPRO) THEN  
!*    1.1 CONVERT TO WAVE HEIGHT AND DEGREES.
!         -----------------------------------
   DO J = 1, NGY  
      DO I = 1, NGX  
         WHGTTG (I, J) = 4.0 * SQRT (WHGTTG (I, J) )  
         WDIRTG (I, J) = DEG * WDIRTG (I, J)  
         UDIRG (I, J) = DEG * UDIRG (I, J)  
      ENDDO
   ENDDO
!*    1.2 WRITE PARAMETERS OF TOTAL SEA AND WIND TO FILE.
!         -----------------------------------------------
   IF (FFLAG20) THEN  
      WRITE (IU20) IDTPRO, DNGX, DNGY, AMOWEP, AMOSOP, AMOEAP, AMONOP
      WRITE (IU20) (FFLAG (J), J = 1, 8)  
      IF (FFLAG (1) ) WRITE (IU20) WHGTTG  
      IF (FFLAG (2) ) WRITE (IU20) WDIRTG  
      IF (FFLAG (3) ) WRITE (IU20) WMNFTG  
      IF (FFLAG (4) ) WRITE (IU20) USTARG  
      IF (FFLAG (5) ) WRITE (IU20) UDIRG  
      IF (FFLAG (6) ) WRITE (IU20) WPKFTG  
      IF (FFLAG (7) ) WRITE (IU20) CDG  
      IF (FFLAG (8) ) WRITE (IU20) TAUWG  
! FINALLY WRITE U_STOKES AND V_STOKES
      WRITE (IU20) USTOKES  
      WRITE (IU20) VSTOKES  
      WRITE (IU20) ROUGH
      WRITE (IU20) WDISS_GRIDDED
      WRITE (IU20) TAUWG_X
      WRITE (IU20) TAUWG_Y
      WRITE (IU20) BETAG
   ENDIF  
!*    1.3 PRINT PARAMETERS OF TOTAL SEA AND WIND.
!         ---------------------------------------
   IF (PFLAG (1) ) THEN  
      TITL = ' SIGNIFICANT WAVE HEIGHT ( 0.1 METRES )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 10., WHGTTG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (2) ) THEN  
      TITL = ' MEAN WAVE DIRECTION ( DEGREE FROM NORTH TO )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 1., WDIRTG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (3) ) THEN  
      TITL = ' MEAN WAVE FREQUENCY ( 0.01 HERTZ )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 100., WMNFTG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (4) ) THEN  
      TITL = ' FRICTION VELOCITY ( 0.01 METRES/SECOND )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 100., USTARG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (5) ) THEN  
      TITL = ' FRICTION DIRECTION ( DEGREE FROM NORTH TO )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 1., UDIRG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (6) ) THEN  
      TITL = ' PEAK WAVE FREQUENCY ( 0.01 HERTZ )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 100., WPKFTG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (7) ) THEN  
      TITL = ' DRAG COEFFICIENT (IN  0.1 *PROMILLE )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 10000., CDG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (8) ) THEN  
      TITL = ' NORMALISED WAVE STRESS (IN % )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 100., TAUWG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
ENDIF  
! ----------------------------------------------------------------------
!*    2. OUTPUT OF INTEGRATED PARAMETERS OF SEA AND SWELL.
!        -------------------------------------------------
IF (IDTINTS.EQ.IDTPRO) THEN  
!*    2.1 CONVERT TO WAVE HEIGHT AND DEGREES.
!         -----------------------------------
   DO J = 1, NGY  
      DO I = 1, NGX  
         WHGTSG (I, J) = 4.0 * SQRT (WHGTSG (I, J) )  
         WDIRSG (I, J) = DEG * WDIRSG (I, J)  
         WDIRWG (I, J) = DEG * WDIRWG (I, J)  
      ENDDO
   ENDDO
!*    2.2 WRITE PARAMETERS OF SWELL AND WIND DIRECTION TO FILE.
!         -----------------------------------------------------
   IF (FFLAG21) THEN  
      WRITE (IU21) IDTPRO, DNGX, DNGY, AMOWEP, AMOSOP, AMOEAP, AMONOP
      WRITE (IU21) (FFLAG (J), J = 9, 12)  
      IF (FFLAG (9) ) WRITE (IU21) WHGTSG  
      IF (FFLAG (10) ) WRITE (IU21) WDIRSG  
      IF (FFLAG (11) ) WRITE (IU21) WDIRWG  
      IF (FFLAG (12) ) WRITE (IU21) WMNFSG  
   ENDIF  
!*    2.3 PRINT PARAMETERS OF SWELL AND WIND WAVE DIRECTION.
!         --------------------------------------------------
   IF (PFLAG (9) ) THEN  
      TITL = ' SWELL WAVE HEIGHT ( 0.1 METRES )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 10., WHGTSG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (10) ) THEN  
      TITL = ' MEAN SWELL DIRECTION ( DEGREE FROM NORTH TO )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 1., WDIRSG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (11) ) THEN  
      TITL = ' MEAN SEA DIRECTION ( DEGREE FROM NORTH TO )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 1., WDIRWG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  
   IF (PFLAG (12) ) THEN  
      TITL = ' MEAN SWELL FREQUENCY ( 0.01 HERTZ )'  
      CALL OUTPP (IDTPRO, IU06, TITL, 100., WMNFSG, AMOWEP, AMOSOP, AMOEAP, AMONOP)
   ENDIF  

ENDIF  
RETURN  
END SUBROUTINE outint
