SUBROUTINE outgrid (fl3, ijs, ijl, ig)
! ----------------------------------------------------------------------
!**** *OUTGRID* - OUTPUT OF WAVE ENERGY,MEAN ANGLE, MEAN FREQUENCY
!****             FRICTION VELOCITY AND WIND DIRECTION IN GRIDDED
!****             FORMAT.
!     P.JANSSEN      KNMI
!     P.LIONELLO  FEB. 87
!                 OUTPUT OF SWELL ENERGY ,MEAN SWELL DIRECTION ,
!                 MEAN SWELL FREQUENCY AND MEAN WIND-SEA WAVE
!                 DIRECTION AT ALL ACTIVE GRID POINTS
!     H.GUNTHER   GKSS/ECMWF     NOVEMBER 1989
!                 OUTPUT FORMAT IS NOW GRIDDED FIELDS.
!*    PURPOSE.
!     --------
!       OUTPUT OF WAVE AND WIND FIELDS INTO COMMON BLOCK.
!**   INTERFACE.
!     ----------
!       *CALL* *OUTGRID (FL3, IJS, IJL, IG)*
!         *FL3*    - BLOCK OF SPECTRA.
!         *IJS*    - INDEX OF FIRST GRIDPOINT.
!         *IJL*    - INDEX OF LAST GRIDPOINT.
!         *IG*     - BLOCK NUMBER.
!     EXTERNALS.
!     ----------
!       *MAKEGRID*  - GENERATES GRIDDED FIELDS.
!       *PEAKFR*    - COMPUTATION OF PEAK FREQUENCY.
!     METHOD.
!     -------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use intpar
use stokesblock
use intspar
use meanpa
use stat
use swell
use wind
implicit none

REAL, PARAMETER :: G = 9.806

REAL   , INTENT(IN OUT):: fl3(0:niblo,nang,nfre)
INTEGER, INTENT(IN)    :: ijs, ijl, ig
REAL    :: peakf(niblo), cd(niblo), wvstr(niblo)
REAL    :: ust(niblo), vst(niblo)
REAL    :: beta(niblo)
REAL    :: tau
INTEGER :: ij
! ----------------------------------------------------------------------
!*    1. INTEGRATED PARAMETERS OF TOTAL SEE.
!        -----------------------------------
IF( idtintt .EQ. idtpro ) THEN
!*    1.1 COMPUTE PEAK FREQUENCY.
!         -----------------------
   CALL peakfr (fl3, ijs, ijl, peakf)
!*    1.2 COMPUTE NORMALISED WAVESTRESS AND DRAG.
!         ---------------------------------------
   DO ij = ijs, ijl
      tau       = usnew(ij) **2 + 0.0001
      wvstr(ij) = tauw(ij, ig) / tau
      cd(ij)    = tau / (u10new(ij) **2 + 0.01)
      beta(ij)    = G*Z0NEW(IJ)/ (usnew(ij) **2 + 0.0001)
! KORRRES CHECK
!     if (cd(ij).gt.2.e-3) then
!      print *,'KORRES CD:', CD(IJ),USNEW(IJ),u10new(ij),tau*wvstr(ij)
!      print *,'KORRES CD:', IJ,CD(IJ),tau,tauw(ij,1),u10new(ij)
!     end if
   ENDDO
!     1.22 COMPUTE STOKES DRIFT VELOCITIES
   CALL stokes_drift (fl3, ijs, ijl, ust, vst)
!*    1.3 STORE PARAMETERS FOR ACTUAL BLOCK IN GRID ARRAYS.
!         -------------------------------------------------
   CALL makegrid (emean, whgttg, ijs, ijl, ig)
   CALL makegrid (thq, wdirtg, ijs, ijl, ig)
   CALL makegrid (peakf, wpkftg, ijs, ijl, ig)
   CALL makegrid (fmean, wmnftg, ijs, ijl, ig)
   CALL makegrid (thwnew, udirg, ijs, ijl, ig)
   CALL makegrid (usnew, ustarg, ijs, ijl, ig)
   CALL makegrid (cd, cdg, ijs, ijl, ig)
   CALL makegrid (beta, betag, ijs, ijl, ig)
   CALL makegrid (wvstr, tauwg, ijs, ijl, ig)
   CALL makegrid (ust, ustokes, ijs, ijl, ig)
   CALL makegrid (vst, vstokes, ijs, ijl, ig)
   CALL makegrid (wdiss, wdiss_gridded, ijs, ijl, ig)
   CALL makegrid (z0new, rough, ijs, ijl, ig)
   CALL makegrid (tauw_x, tauwg_x, ijs, ijl, ig)
   CALL makegrid (tauw_y, tauwg_y, ijs, ijl, ig)
   CALL makegrid (tauwhf_x, tauwghf_x, ijs, ijl, ig)
   CALL makegrid (tauwhf_y, tauwghf_y, ijs, ijl, ig)
ENDIF
! ----------------------------------------------------------------------
!*    2. INTEGRATED PARAMETERS OF SWELL.
!        -------------------------------
IF( idtints .EQ. idtpro ) THEN
!*    2.1 STORE PARAMETERS FOR ACTUAL BLOCK IN GRID ARRAYS.
!         -------------------------------------------------
   CALL makegrid (eswell, whgtsg, ijs, ijl, ig)
   CALL makegrid (thswell, wdirsg, ijs, ijl, ig)
   CALL makegrid (thwisea, wdirwg, ijs, ijl, ig)
   CALL makegrid (fswell, wmnfsg, ijs, ijl, ig)

ENDIF
RETURN
END SUBROUTINE outgrid
