SUBROUTINE outbs (fl3, fl, ijs, ijl, ig, iu25, iu26)  
! ----------------------------------------------------------------------
!**** *OUTBS* - MODEL OUTPUT FROM BLOCK TO FILE, PRINTER AND COMMON.
!     H. GUNTHER         GKSS/ECMWF         JUNE 1990
!*    PURPOSE.
!     --------
!       CONTROL OUTPUT OF WAVE AND WIND FIELDS.
!**   INTERFACE.
!     ----------
!       *CALL* *OUTBS (FL3, FL, IJS, IJL, IG, IU25, IU26)*
!          *FL3*    - SPECTRUM.
!          *FL*     - WORKING ARRAY FOR SWELL OUTPUT.
!          *IJS*    - INDEX OF FIRST GRIDPOINT
!          *IJL*    - INDEX OF LAST GRIDPOINT
!          *IG*     - BLOCK NUMBER
!          *IU25*   - OUTPUT UNIT FOR SPECTRA.
!          *IU26*   - OUTPUT UNIT FOR SEA AND SWELL SPECTRA.
!     EXTERNALS.
!     ----------
!       *FEMEAN*    - COMPUTATION OF MEAN FREQUENCY AT EACH GRID POINT.
!       *OUTGRID*   - SAVE BLOCKED PARAMETERS INTO GRID ARRAYS.
!       *OUTSPP*    - OUTPUT OF SPECTRA AT SELECTED POINTS.
!       *SEMEAN*    - COMPUTATION OF TOTAL ENERGY AT EACH GRID POINT.
!       *SEPWISW*   - SEPARATION OF WINDSEA AND SWELL.
!       *STHQ*      - COMPUTATION OF MEAN WAVE DIRECTION AT EACH
!                     GRID POINT.
!     METHOD.
!     -------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
USE params  
USE stat
USE testo
IMPLICIT NONE

REAL   , INTENT(IN OUT) :: fl3(0:niblo,nang,nfre), fl(0:niblo,nang,nfre)
INTEGER, INTENT(IN)     :: ijs, ijl, ig, iu25, iu26
! ----------------------------------------------------------------------
!*    1. COMPUTE MEAN PARAMETERS.
!        ------------------------
CALL SEMEAN (FL3, IJS, IJL)
CALL FEMEAN (FL3, IJS, IJL)
CALL STHQ (FL3, IJS, IJL)
IF (ITEST.GE.3) THEN
   IF (ITESTB.GE.IG) THEN
      WRITE (IU06,  * ) '      SUB. OUTBS: INTEGRATED', ' PARAMETERS COM&
&PUTED FOR OUTPUT'
   ENDIF
ENDIF

!*    2. WINDSEA SWELL SEPARATION.
!        -------------------------
IF (IDTINTS.EQ.IDTPRO.OR.IDTSPS.EQ.IDTPRO) THEN
   CALL SEPWISW (FL3, FL, IJS, IJL, IG)
   IF (ITEST.GE.3) THEN
      IF (ITESTB.GE.IG) THEN
         WRITE (IU06,  * ) '      SUB. OUTBS: SWELL /SEA', ' SEPARATION DONE'
      ENDIF
   ENDIF
ENDIF
!*    3. OUTPUT OF SPECTRA AT SELECTED GRID POINTS.
!        ------------------------------------------
#ifdef out_spectra
IF (IDTSPT.EQ.IDTPRO) THEN
   CALL OUTSPEC (FL3, FL, IG, IU25, IJS, IJL)
ENDIF
#endif
IF (IDTSPT.EQ.IDTPRO.OR.IDTSPS.EQ.IDTPRO) THEN
   CALL OUTSPP (FL3, FL, IG, IU25, IU26)
   IF (ITEST.GE.3) THEN
      IF (ITESTB.GE.IG) THEN
WRITE (IU06,  * ) '      SUB. OUTBS: OUTPUT OF SPECTRA', ' AT SELE&
&CTED POINTS DONE'
      ENDIF
   ENDIF
ENDIF
!*    4. OUTPUT OF INTEGRATED PARAMETERS.
!        --------------------------------
IF (IDTINTT.EQ.IDTPRO.OR.IDTINTS.EQ.IDTPRO) THEN
   CALL OUTGRID (FL3, IJS, IJL, IG)
   IF (ITEST.GE.3) THEN
      IF (ITESTB.GE.IG) THEN
WRITE (IU06,  * ) '      SUB. OUTBS: OUTPUT OF ', 'INTEGRATED PARA &
&METERS DONE'
      ENDIF
   ENDIF
ENDIF

RETURN
END SUBROUTINE outbs
