SUBROUTINE outbc (fl3, ijs, ijl, ig, iubc, nest)  
! ----------------------------------------------------------------------
!**** *OUTBC* - OUTPUT OF THE COARSE GRID BOUNDARY VALUES.
!     R. PORTZ     MPI          JANUARY 1991
!*    PURPOSE.
!     --------
!        WRITE THE BOUNDARY VALUE OUTPUT FILE.
!**   INTERFACE.
!     ----------
!       *CALL* *OUTBC (FL3, IJS, IJL, IG, IU19)*
!          *FL3*     - BLOCK OF SPECTRA.
!          *IJS*     - INDEX OF FIRST GRIDPOINT.
!          *IJL*     - INDEX OF LAST GRIDPOINT.
!          *IG*      - BLOCK NUMBER.
!          *IU19*    - OUTPUT UNIT OF BOUNDARY VALUES.
!     METHOD.
!     -------
!       SEQUENCIAL UNFORMATED WRITE TO UNIT.
!     EXTERNALS.
!     ----------
!       *FEMEAN*    - COMPUTATION OF MEAN FREQUENCY AT EACH GRID POINT.
!       *SEMEAN*    - COMPUTATION OF TOTAL ENERGY AT EACH GRID POINT.
!       *STHQ*      - COMPUTATION OF MEAN WAVE DIRECTION AT EACH
!                     GRID POINT.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use cbound
use fredir
use map
use meanpa
use stat
use testo
use wind
implicit none

REAL   , INTENT(IN):: fl3(0:niblo,nang,nfre)
INTEGER, INTENT(IN):: ijs, ijl, ig, iubc, nest
REAL    :: XLAT, XLON, XIG, XIJ
INTEGER :: IJ, NGOU, K, M
! ----------------------------------------------------------------------
!*    1. COMPUTE MEAN PARAMETERS.
!        ------------------------
1000 CONTINUE
CALL SEMEAN (FL3, IJS, IJL)
CALL FEMEAN (FL3, IJS, IJL)
CALL STHQ (FL3, IJS, IJL)
IF (ITEST.GE.3) THEN
   IF (ITESTB.GE.IG) THEN
      WRITE (IU06,  * ) '      SUB. OUTBC: INTEGRATED', ' PARAMETERS COM&
&PUTED FOR BOUNDARY POINTS OUTPUT'
   ENDIF
ENDIF
!*    2. LOOP OVER BOUNDARY POINTS.
!        --------------------------
! 2000 CONTINUE
DO NGOU = 1, NBOUNC (NEST)
   IF (IG.LT.IGARC (NGOU, NEST) ) GOTO 2002
   IF (IG.EQ.IGARC (NGOU, NEST) ) THEN
      IJ = IJARC (NGOU, NEST)
      XLON = AMOWEP + REAL (IXLG (IJ, IG) - 1) * XDELLO
      XLAT = AMOSOP + REAL (KXLT (IJ, IG) - 1) * XDELLA
!*    2.1 WRITE INFORMATION TO FILE IU19.
!         -------------------------------
      XIJ = REAL (IJ)
      XIG = REAL (IG)
      WRITE (IUBC) XLON, XLAT, IDTPRO, EMEAN (IJ), THQ (IJ), &
       FMEAN (IJ), USNEW (IJ), THWNEW (IJ)
      WRITE (IUBC) ( (FL3 (IJ, K, M), K = 1, NANG), M = 1, NFRE)
   ENDIF
END DO
2002 CONTINUE

RETURN
END SUBROUTINE outbc
