SUBROUTINE openfil (iu06, iunit, idate, fileid, stat, userid,runid, path, ifail)
! -------------------------------------------------------------------
!**** *OPENFIL* - OPENS A FILE ( UNICOS VERSION ).
!     RENATE PORTZ     MPI HAMBURG   JULY 1990
!     HEINZ GUNTHER    GKSS/ECMWF    MARCH 1991  MODIFIED FOR CYCLE_4.
!*    PURPOSE.
!     --------
!       OPENS A FILE WITH VARIABLE FILE NAME.
!**   INTERFACE.
!     ----------
!       *CALL* *OPENFIL (IU06, IUNIT, IDATE, FILEID, STAT,
!                        USERID, RUNID, PATH, IFAIL)
!         *IU06*    -   PRINTER OUTPUT UNIT.
!         *IUNIT*   -   LOGCIAL UNIT FILE IS ASSIGNED TO.
!         *IDATE*   -   DATE IN FILE NAME.
!         *FILEID*  -   FILE IDENTIFIER.
!         *STAT*    -   FILE STATUS 'OLD' OR 'NEW'.
!         *USERID*  -   USER IDENTIFIER.
!         *RUNID*   -   RUN IDENTIFIER.
!         *PATH*    -   PATH NAME (WITHOUT FILE NAME).
!         *IFAIL*   -   ERROR FLAG = 0 FILE OPENED
!                                    = 1 FILE NOT OPENED.
!     EXTERNALS.
!     ----------
!       *ABORT*     - TERMINATES PROCESSING.
!       *DIFDATE*   - COMPUTE TIME DIFFERENCES.
!       *IECF_LEN*  - LENGTH OF CHARACTER STRING.
!     METHOD.
!     -------
!       THE METHOD USED IN THIS SUB DEPENDS UPON THE COMPUTER
!       ENVIROMENT. IN ITS PRESENT FORM THE ROUTINE IS ADOPTED TO
!       THE UNICOS CRAY SYSTEM.
!       THE FILE NAME IS BUILD FORM THE 3 CHARACTER FILEID FOLLOWED
!       BY YYMMDDHHMM0 WHERE YYMMDDHHMM IS THE DATE OF THE LAST
!       OUTPUT IN THIS FILE.
!       THESE NUMBERS ARE CONSTRUCTED FROM IDATE.
!       THE FULL PATH NAME IS PATH/FILE NAME
!     REFERENCES.
!     -----------
!       NONE.
! ----------------------------------------------------------------------
implicit none

INTEGER , INTENT(IN) :: iu06, iunit
CHARACTER, INTENT(IN):: idate * 12, fileid * 3, stat * 3, userid * 3, runid * 3, path * 60
INTEGER , INTENT(OUT):: ifail
CHARACTER :: FILENA * 16, IU * 8, FNAME * 128
!        *FILENA*  CHARACTER   GENERATED FILE NAME.
!        *IU*      CHARACTER   UNIT ALIAS FILE NAME.
!        *FNAME*   CHARACTER   FULL PATH NAME.
INTEGER :: ILEN, IECF_LEN, LNAME
! ----------------------------------------------------------------------
!*    1. BUILD FILE NAME.
!        ----------------
 1000 CONTINUE  
FILENA = FILEID  
!      ILEN  = IECF_LEN(IDATE)
FILENA (4:16) = IDATE  
! ----------------------------------------------------------------------
!*    2. CONSTRUCTED FULL PATH.
!        ----------------------
 2000 CONTINUE  
ILEN = IECF_LEN (PATH)  
LNAME = IECF_LEN (FILENA)  
FNAME = ' '  
FNAME = PATH (1:ILEN) //'/'//FILENA (1:LNAME)  
!      FNAME = PATH(1:ILEN)//'\'//FILENA(1:LNAME)
!*    3. OPEN FILE AND RETURN.
!        ---------------------
 3000 CONTINUE  
ILEN = IECF_LEN (FNAME)  
!      write(6,*) 'from open_fil ',FNAME
!      OPEN (UNIT=IUNIT, FILE=FNAME, STATUS=STAT, FORM='UNFORMATTED',
#ifdef out_spectra
IF (IUNIT.EQ.25) THEN  
   OPEN (UNIT = IUNIT, FILE = FNAME, FORM = 'FORMATTED', ERR = 4000)
   GOTO 600  
ENDIF  
#endif
OPEN (UNIT = IUNIT, FILE = FNAME, FORM = 'UNFORMATTED', ERR = 4000)
  600 CONTINUE  
WRITE (IU06,  * ) ' FILE [ ', FNAME (1:ILEN) , ' ] OPENED', ' AND &
&ASSIGNED TO UNIT ', IUNIT
IFAIL = 0  
RETURN  
!*    4. ERROR MESSAGE.
!        --------------
 4000 CONTINUE  
IFAIL = 1  
WRITE(IU06,*) ' +++++++++++++++++++++++++++++++++++'  
WRITE(IU06,*) ' +                                 +'  
WRITE(IU06,*) ' +    WARNING ERROR SUB. OPENFIL   +'  
WRITE(IU06,*) ' +    ==========================   +'  
WRITE(IU06,*) ' +                                 +'  
WRITE(IU06,*) ' + COULD NOT OPEN FILE             +'  
WRITE(IU06,*) ' + FULL PATH NAME IS : ', FNAME (1:ILEN)  
WRITE(IU06,*) ' +                                 +'  
WRITE(IU06,*) ' +++++++++++++++++++++++++++++++++++'  

RETURN  
END SUBROUTINE openfil
