! UNIV. OF ATHENS - OCEAN GROUP - G.KORRES 07/03/2001
!***********************************************************************
SUBROUTINE op_files (iu05, iu06, iu07, iu08, iu09, iu10, iu11, &
                     iu12, iu13, iu14, iu15, iu70)
! ----------------------------------------------------------------------
!**** TAKE NAMES AND OPEN OF INPUT & OUTPUT FILES
!     -------
!       *IU05*   - USER INPUT UNIT.
!       *IU06*   - PRINTER OUTPUT.
!       *IU07*   - LOGICAL UNIT FOR INPUT OF GRID ORGANISATION
!                  AND COMPUTED CONSTANTS OUTPUTED BY PREPROC
!                  SEE SUB READPRE   (/coarse/gridcatu)
#ifdef linux
USE flushfiles
#endif
USE indir
IMPLICIT NONE
INTEGER, INTENT(IN) :: iu05, iu06, iu07, iu08, iu09
INTEGER, INTENT(IN) :: iu10, iu11, iu12, iu13, iu14, iu15, iu70

CHARACTER :: line * 80
!     *** IU05 ***
CHARACTER :: userinp * 80
!     *** IU07 ***
CHARACTER :: gridorg * 80
!     *** IU08 ***
CHARACTER :: common_ubuf * 80
!     *** IU09 ***
CHARACTER :: coarse_grid_unf * 80
!     *** IU10 ***
CHARACTER :: fine_grid_unf * 80
!     *** IU12 ***
CHARACTER :: blspanal * 80
!     *** IU15 ***
CHARACTER :: lawianal * 80
!     *** IU14 ***
CHARACTER :: slatanal * 80
!NIKOS*** IU70 *** take arguments from cl
CHARACTER :: inputfiles * 80
INTEGER   :: numargs, iargc
INTEGER   :: i, iecf_len, ierrcode
! ----------------------------------------------------------------------
WRITE(iu06, '(''***   PROGRAM CHIEF   ***'')')
!     ------------------------------------------------
WRITE(iu06, '(/,''OLD USER INPUT FILE NAME ?:'')')
!NIKOS ADDED FROM HERE
numargs = iargc ()
IF( 1 .NE. numargs ) THEN
   WRITE(iu06,*) ' ******************************************'
   WRITE(iu06,*) ' * Wrong argument count (!= 1).           *'
   WRITE(iu06,*) ' * Please run again                       *'
   WRITE(iu06,*) ' * Specify input file as run time argument*'
   WRITE(iu06,*) ' ******************************************'
   CALL ABORT
endif
CALL getarg (1, inputfiles)
OPEN(iu70, FILE = inputfiles, STATUS = 'OLD', IOSTAT = ierrcode)
IF( ierrcode .GT. 0 ) THEN
   WRITE(iu06,*) ' *****************************************'
   WRITE(iu06,*) ' *                                       *'
   WRITE(iu06,*) ' *      FATAL  ERROR IN SUB. OP_FILES    *'
   WRITE(iu06,*) ' *      ===========================      *'
   WRITE(iu06,*) ' *                                       *'
   WRITE(iu06,*) ' * CAN NOT OPEN:  ', inputfiles
   WRITE(iu06,*) ' * PROGRAM WILL BE ABORTED               *'
   WRITE(iu06,*) ' *****************************************'
   CALL ABORT
ENDIF
!NIKOS UNTIL HERE TO OPEN FILE CONTAINING cli OPTIONS
!*    1 READ INPUT AND PRINT.
1000 CONTINUE
READ( iu70 , '(A80)') line
IF( line (1:1) .EQ.'C') GOTO 1000
READ( line, '(A80)') userinp
WRITE( iu06, '(''FILE NAME (IU05):  '',A)') userinp

!*    1.1 OPEN USER INPUT FILE
OPEN( iu05, FILE = userinp, STATUS = 'OLD', FORM = 'FORMATTED', IOSTAT = ierrcode)
IF( ierrcode .GT. 0) THEN
   WRITE(iu06,*) ' *********************************************'
   WRITE(iu06,*) ' *                                           *'
   WRITE(iu06,*) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
   WRITE(iu06,*) ' *      ===========================          *'
   WRITE(iu06,*) ' *                                           *'
   WRITE(iu06,*) ' * CAN NOT OPEN:  ', userinp
   WRITE(iu06,*) ' * PROGRAM WILL BE ABORTED                   *'
   WRITE(iu06,*) ' *********************************************'
   CALL ABORT
ENDIF

! ----------------------------------------------------------------------

WRITE(IU06, '(/,''GRID ORG & COMPUTED CONSTANTS FILE NAME ?:'')')
!
!*    2 READ INPUT AND PRINT.
!
 2000 CONTINUE
READ (IU70, '(A80)') LINE
IF (LINE (1:1) .EQ.'C') GOTO 2000
READ (LINE, '(A80)') GRIDORG
WRITE (IU06, '(''FILE NAME (IU07):  '',A)') GRIDORG
!
!*    2.1 OPEN GRID ORGANISATION AND COMPUTED CONSTANTS FILE
!
OPEN (IU07, FILE = GRIDORG, STATUS = 'OLD', FORM = 'UNFORMATTED', &
 IOSTAT = IERRCODE)
IF (IERRCODE.GT.0) THEN
WRITE (IU06,  * ) ' *********************************************'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
WRITE (IU06,  * ) ' *      ===========================          *'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' * CAN NOT OPEN:  ', GRIDORG
WRITE (IU06,  * ) ' * PROGRAM WILL BE ABORTED                   *'
WRITE (IU06,  * ) ' *********************************************'
   CALL ABORT
ENDIF
!
! ----------------------------------------------------------------------
!
!
WRITE (IU06, '(/,''Common UBUF FILE NAME ?:'')')
!
!*    3 READ INPUT AND PRINT.
!
 3000 CONTINUE
READ (IU70, '(A80)') LINE
IF (LINE (1:1) .EQ.'C') GOTO 3000
READ (LINE, '(A80)') COMMON_UBUF
WRITE (IU06, '(''FILE NAME (IU08):  '',A)') COMMON_UBUF
!
!*    3.1 OPEN FILE  Common UBUF
!
OPEN (IU08, FILE = COMMON_UBUF, STATUS = 'OLD', FORM = &
 'UNFORMATTED', IOSTAT = IERRCODE)
IF (IERRCODE.GT.0) THEN
WRITE (IU06,  * ) ' *********************************************'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
WRITE (IU06,  * ) ' *      ===========================          *'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' * CAN NOT OPEN:  ', COMMON_UBUF
WRITE (IU06,  * ) ' * PROGRAM WILL BE ABORTED                   *'
WRITE (IU06,  * ) ' *********************************************'
   CALL ABORT
ENDIF
!
! ----------------------------------------------------------------------
!
#ifdef fineonly

GOTO 4100
#endif
!
WRITE (IU06, '(/,''Coarse grid &
&  points (if a coarse grid run) file name?:'')')
!
!*    4 READ INPUT AND PRINT.
!
 4000 CONTINUE
READ (IU70, '(A80)') LINE
IF (LINE (1:1) .EQ.'C') GOTO 4000
READ (LINE, '(A80)') COARSE_GRID_UNF
WRITE (IU06, '(''FILE NAME (IU09):  '',A)') COARSE_GRID_UNF
!
!*    4.1 OPEN FILE Coarse grid points (if a coarse grid run)
!
OPEN (IU09, FILE = COARSE_GRID_UNF, STATUS = 'OLD', FORM = &
 'UNFORMATTED', IOSTAT = IERRCODE)
IF (IERRCODE.GT.0) THEN
WRITE (IU06,  * ) ' *********************************************'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
WRITE (IU06,  * ) ' *      ===========================          *'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' * CAN NOT OPEN:  ', COARSE_GRID_UNF
WRITE (IU06,  * ) ' * PROGRAM WILL BE ABORTED                   *'
WRITE (IU06,  * ) ' *********************************************'
   CALL ABORT
ENDIF
!
! ----------------------------------------------------------------------
!

 4100 CONTINUE
#ifdef coarseonly

GOTO 5100
#endif
WRITE (IU06, '(/,''Fine grid &
&   points (if a fine grid run) file name?:'')')
!
!*    5 READ INPUT AND PRINT.
!
 5000 CONTINUE
READ ( IU70 , '(A80)') LINE
IF (LINE (1:1) .EQ.'C') GOTO 5000
READ (LINE, '(A80)') FINE_GRID_UNF
WRITE (IU06, '(''FILE NAME (IU10):  '',A)') FINE_GRID_UNF
!
!*    5.1 OPEN FILE Fine grid points (if a fine grid run)
!
OPEN (IU10, FILE = FINE_GRID_UNF, STATUS = 'OLD', FORM = &
 'UNFORMATTED', IOSTAT = IERRCODE)
IF (IERRCODE.GT.0) THEN
WRITE (IU06,  * ) ' *********************************************'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
WRITE (IU06,  * ) ' *      ===========================          *'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' * CAN NOT OPEN:  ', FINE_GRID_UNF
WRITE (IU06,  * ) ' * PROGRAM WILL BE ABORTED                   *'
WRITE (IU06,  * ) ' *********************************************'
   CALL ABORT
ENDIF
!
!-----------------------------------------------------------------------
!
!
 5100 CONTINUE
!
WRITE (IU06, '(/,''BLSPANAL file name?:'')')
!
!*    6 READ INPUT AND PRINT.
!
 6000 CONTINUE
READ ( IU70 , '(A80)') LINE
IF (LINE (1:1) .EQ.'C') GOTO 6000
READ (LINE, '(A80)') BLSPANAL
WRITE (IU06, '(''FILE NAME (IU12):  '',A)') BLSPANAL
!
!*    6.1 OPEN FILE BLSPANAL
!
#ifdef linux

BLSFILE = BLSPANAL
#endif
OPEN (IU12, FILE = BLSPANAL, STATUS = 'OLD', FORM = 'UNFORMATTED', &
 IOSTAT = IERRCODE)
IF (IERRCODE.GT.0) THEN
WRITE (IU06,  * ) ' *********************************************'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
WRITE (IU06,  * ) ' *      ===========================          *'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' * CAN NOT OPEN:  ', BLSPANAL
WRITE (IU06,  * ) ' * PROGRAM WILL BE ABORTED                   *'
WRITE (IU06,  * ) ' *********************************************'
   CALL ABORT
ENDIF
!
!-----------------------------------------------------------------------
!
!
!*    6.2 MAKE INPUT AND PRINT.
!
I = IECF_LEN (BLSPANAL)
BLSPANAL (I + 1:I + 5) = '.OUT'
WRITE (IU06, '(''INTERCHANGED FILE NAME (IU11): '',A)') BLSPANAL
!
!*    6.3 OPEN FILE BLSPANAL  (OUT)
!
!     Eldad
!      OPEN(IU11,FILE=BLSPANAL,STATUS='NEW',
!     +     FORM='UNFORMATTED',IOSTAT=IERRCODE)
OPEN (IU11, FILE = BLSPANAL, STATUS = 'UNKNOWN', FORM = &
 'UNFORMATTED', IOSTAT = IERRCODE)
IF (IERRCODE.GT.0) THEN
WRITE (IU06,  * ) ' *********************************************'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
WRITE (IU06,  * ) ' *      ===========================          *'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' * CAN NOT OPEN:  ', BLSPANAL
WRITE (IU06,  * ) ' * PROGRAM WILL BE ABORTED                   *'
WRITE (IU06,  * ) ' *********************************************'
   CALL ABORT
ENDIF
!
!-----------------------------------------------------------------------
WRITE (IU06, '(/,''LAWIANAL file name?:'')')
!*    7 READ INPUT AND PRINT.
 7000 CONTINUE
READ ( IU70 , '(A80)') LINE
IF (LINE (1:1) .EQ.'C') GOTO 7000
READ (LINE, '(A80)') LAWIANAL
WRITE (IU06, '(''FILE NAME (IU15):  '',A)') LAWIANAL
!
!*    7.1 OPEN FILE LAWIANAL
#ifdef linux
LAWFILE = LAWIANAL
#endif
!
OPEN (IU15, FILE = LAWIANAL, STATUS = 'OLD', FORM = 'UNFORMATTED', &
 IOSTAT = IERRCODE)
IF (IERRCODE.GT.0) THEN
WRITE (IU06,  * ) ' *********************************************'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
WRITE (IU06,  * ) ' *      ===========================          *'
WRITE (IU06,  * ) ' *                                           *'
WRITE (IU06,  * ) ' * CAN NOT OPEN:  ', LAWIANAL
WRITE (IU06,  * ) ' * PROGRAM WILL BE ABORTED                   *'
WRITE (IU06,  * ) ' *********************************************'
   CALL ABORT
ENDIF
!
!-----------------------------------------------------------------------
!
!
WRITE (IU06, '(/,''SLATANAL file name?:'')')
!
!*    8 READ INPUT AND PRINT.
!
 8000 CONTINUE
READ ( IU70 , '(A80)') LINE
IF (LINE (1:1) .EQ.'C') GOTO 8000
READ (LINE, '(A80)') SLATANAL
WRITE(IU06, '(''FILE NAME (IU14):  '',A)') SLATANAL
!
!*    8.1 OPEN FILE SLATANAL
!
OPEN (IU14, FILE = SLATANAL, STATUS = 'OLD', FORM = 'UNFORMATTED', &
 IOSTAT = IERRCODE)
IF (IERRCODE.GT.0) THEN
WRITE(IU06,  * ) ' *********************************************'
WRITE(IU06,  * ) ' *                                           *'
WRITE(IU06,  * ) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
WRITE(IU06,  * ) ' *      ===========================          *'
WRITE(IU06,  * ) ' *                                           *'
WRITE(IU06,  * ) ' * CAN NOT OPEN:  ', SLATANAL
WRITE(IU06,  * ) ' * PROGRAM WILL BE ABORTED                   *'
WRITE(IU06,  * ) ' *********************************************'
   CALL ABORT
ENDIF
!
!
!*    8.2 MAKE INPUT AND PRINT.
!
I = IECF_LEN (SLATANAL)
SLATANAL (I + 1:I + 5) = '.OUT'
WRITE(IU06, '(''INTERCHANGED FILE NAME (IU13) : '',A)') SLATANAL
!
!*    8.3 OPEN FILE SLATANAL  (OUT)
!
!     Eldad
!      OPEN(IU13,FILE=SLATANAL,STATUS='NEW',
!     +     FORM='UNFORMATTED',IOSTAT=IERRCODE)
OPEN (IU13, FILE = SLATANAL, STATUS = 'UNKNOWN', FORM = &
 'UNFORMATTED', IOSTAT = IERRCODE)
IF (IERRCODE.GT.0) THEN
WRITE(IU06,  * ) ' *********************************************'
WRITE(IU06,  * ) ' *                                           *'
WRITE(IU06,  * ) ' *      FATAL  ERROR IN SUB. OP_FILES        *'
WRITE(IU06,  * ) ' *      ===========================          *'
WRITE(IU06,  * ) ' *                                           *'
WRITE(IU06,  * ) ' * CAN NOT OPEN:  ', SLATANAL
WRITE(IU06,  * ) ' * PROGRAM WILL BE ABORTED                   *'
WRITE(IU06,  * ) ' *********************************************'
   CALL ABORT
ENDIF
! ----------------------------------------------------------------------
!*    9 READ NAME OF DIRECTORY WITH WIND FIELDS.
! Eldad 07-jan-97
 9000 CONTINUE
READ (IU70, '(A80)') LINE
IF (LINE (1:1) .EQ.'C') GOTO 9000
READ (LINE, '(A100)') INDIRNAME
WRITE(IU06, '(''Take Wind files from directory:  '',A)') INDIRNAME

RETURN
END SUBROUTINE op_files
