SUBROUTINE notim (idtwis, idtwie)
! ----------------------------------------------------------------------
!**** *NOTIM* - STEERING MODULE IF NO TIME INTERPOLATION WANTED.
!*    PURPOSE.
!     --------
!       NOTIM NO TIME INTERPOLATION: PROCESS WINDFIELDS.
!**   INTERFACE.
!     ----------
!       *CALL* *NOTIM (IDTWIS, IDTWIE, NC, NR)*
!          *IDTWIS* - DATE OF FIRST WIND FIELD.
!          *IDTWIE* - DATE OF LAST FIRST WIND FIELD.
!          *NC*     - FIRST DIMENSION OF INPUT WIND FIELD.
!          *NR*     - SECOND DIMENSION OF INPUT WIND FIELD.
!     METHOD.
!     -------
!       NO TIME INTERPOLATION:
!       WINDFIELDS ARE PROCESSED EVERY IDELWI SECONDS (U,V),
!       THE WINDS INTERPOLATED IN SPACE ONLY (US,DS)
!     EXTERNALS.
!     ----------
!       *ABORT*     - TERMINATES PROCESSING.
!       *AIRSEA*    - TOTAL STRESS IN SURFACE LAYER.
!       *CREWFN*    - ASSIGN A FILE NAME.
!       *GETWND*    - READ A WINDFIELD (UWND,VWND) AND COMPUTE WIND
!                     FOR ALL BLOCKS (US,DS).
!       *INCDATE*   - INCREMENT DATE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
USE wind1 ; USE params ; USE gridpar ; USE stat ; USE testo ; USE units ; USE wind
#ifndef _OPENMP
USE my_omp
#endif
IMPLICIT NONE

CHARACTER (LEN=12), INTENT(IN) :: idtwis, idtwie
REAL :: uwnd(nc,nr), vwnd(nc,nr)
REAL :: us_eta(nc,nr), z0_eta(nc,nr)
REAL :: us(niblo,nblo), ds(niblo,nblo)
!        *UWND*    REAL   INPUT WIND FIELD ARRAY (U COMPONENT).
!        *VWND*    REAL   INPUT WIND FIELD ARRAY (V COMPONENT).
!        *US*      REAL   OUTPUT WIND FIELD ARRAY (FRICTION VELOCITY).
!        *DS*      REAL   OUTPUT WIND FIELD ARRAY (DIRECTION).
CHARACTER (LEN=12) :: idtwih
INTEGER :: iareas, iunit, mstep, idt, igg, ios, ig, it1, it2, mp, mm, i, m
#ifdef _OPENMP
INTEGER           :: omp_get_thread_num
#endif
! ----------------------------------------------------------------------
!*    1. INITIALISE WIND REQUEST DATE AND PROCESS FIRST WINDFIELD
!*       IF COLD START.
!        --------------------------------------------------------
idtwih = idtwis
IF( ida .EQ. '000000000000' ) THEN
   ida = idtwis
   CALL getwnd (u10old, thwold, ida, uwnd, vwnd, nc, nr, us_eta, z0_eta)
!$OMP PARALLEL
   CALL airsea(u10old(1,1), tauw(1,1), usold(1,1), z0old(1,1),   &
               itask(1, omp_get_thread_num()+1),                 &
               itask(2, omp_get_thread_num()+1)                 )
!$OMP END PARALLEL
   IF( itest .GE. 3 ) THEN
      WRITE(iu06, '(''       SUB. NOTIM: FIRST WIND FIELD '', &
&            ''SAVED IN COMMON WIND'')')
   ENDIF
   IF( ida .EQ. idtwie ) RETURN
   CALL incdate(idtwih, idelwo)
ENDIF
! ----------------------------------------------------------------------
!*    2. CREATE WIND FILE NAME FROM END DATE.
!        ------------------------------------
CALL crewfn(iuvelo, idtwie)
IF( itest .GE. 3 ) THEN
   WRITE(iu06,*) '       SUB. NOTIM: NEW WIND FILE '
   WRITE(iu06,*) '       UNIT IS IUVELO = ',iuvelo,' WIND FILE DATE IS IDTWIE = ',idtwie
ENDIF
REWIND(UNIT = iuvelo)
mp = 0
! ----------------------------------------------------------------------
!*    3. LOOP OVER OUTPUT WIND TIMES.
!        ----------------------------
3000 CONTINUE
!*    3.1 READ ONE WIND FIELD AND TRANSFORM TO BLOCKS.
!         --------------------------------------------
CALL getwnd(us, ds, idtwih, uwnd, vwnd, nc, nr, us_eta, z0_eta)
mp = mp + 1
!*    3.2 SAVE BLOCKED WIND FIELD.
!         ------------------------
IF( idelpro .GT. idelwo ) THEN
!*        MORE THAN ONE FIELD PER PROPAGATION TIME STEP.
!*        SAVE ON SCRATCH UNITS:
   DO ig = 1, igl
      iunit = iuscr(ig)
      WRITE(iunit, ERR=6100, IOSTAT=ios) idtwih, ig, (us(i,ig), i = 1, niblo),&
                                         (ds(i, ig), i = 1, niblo)
   ENDDO
   IF( itest .GE. 3 ) THEN
      WRITE(iu06,*) '       SUB. NOTIM: NEW WIND FILES AT ', 'IDTWIH = ', &
                    idtwih, ' WRITTEN TO SCRATCH UNIT'
      WRITE(iu06, '(1H+,A8)') iunit
   ENDIF
!*        UPDATE WIND FIELD REQUEST TIME.
   CALL incdate(idtwih, idelwo)
!*        IF TIME LEFT BRANCH BACK TO 3.0 FOR NEXT FIELD.
   IF( idtwih .LE. idtwie) GOTO 3000
ELSE
!*        WIND FIELD IS CONSTANT FOR ONE PROPAGATION TIME STEP:
!*        WRITE TO OUTPUT.
!         -----------------------------------------------------
   DO ig = 1, igl
      WRITE(iuvelo, ERR=6400, IOSTAT=ios) idtwih, ig, (us(i,ig), i=1, niblo),&
                                          (ds(i, ig), i = 1, niblo)
   ENDDO
!*        UPDATE WIND FIELD REQUEST TIME.
!         -------------------------------
   CALL incdate(idtwih, idelwo)
!*        IF TIME LEFT BRANCH BACK TO 3.0 FOR NEXT FIELD.
   IF( idtwih .LE. IDTWIE )    GOTO 3000
   IF( itest .GE. 3 ) THEN
      WRITE(iu06,*) '       SUB. NOTIM: NEW WIND FILE GENERATED '
   ENDIF
   CLOSE(UNIT = iuvelo, STATUS = 'KEEP')
   RETURN
ENDIF
! ----------------------------------------------------------------------
!*    4. RE-ARRANGE THE BLOCKS.
!        ----------------------
DO ig = 1, igl
   REWIND(UNIT = IUSCR(IG) )
ENDDO
mstep = idelpro / idelwo
DO m = 1, mp, mstep
   DO ig = 1, igl
      iunit = iuscr(ig)
      DO mm = 1, mstep
         READ( iunit, ERR=6200, IOSTAT=ios) idt, igg, (us(i,ig), i=1, niblo),&
                                            (ds(i, ig), i = 1, niblo)
         WRITE(iuvelo, ERR=6300, IOSTAT=ios) idt, igg, (us(i,ig), i=1,niblo),&
                                            (ds(i, ig), i = 1, niblo)
      ENDDO
   ENDDO
END DO
REWIND(UNIT = IUVELO)
DO ig = 1, igl
   CLOSE( UNIT = iuscr(ig) , STATUS = 'DELETE' )
END DO
CLOSE( UNIT = iuvelo, STATUS = 'KEEP' )
IF( itest .GE. 3 ) THEN
   WRITE(iu06,*) '       SUB. NOTIM: NEW WIND FILE ',&
                 'GENERATED AS COPY FROM  SCRATCH UNITS'
ENDIF
RETURN
! ----------------------------------------------------------------------
!*    6. ERROR MESSAGES
6100 CONTINUE
WRITE(iu06,*) ' '
WRITE(iu06,*) ' ********************************************'
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' *       FATAL ERROR IN SUB. NOTIM:         *'
WRITE(iu06,*) ' *       ==========================         *'
WRITE(iu06,*) ' * ERROR WHEN WRITTING ON SCRATCH UNIT      *'
WRITE(iu06,*) ' * FOR BLOCK NUMBER          IG = ', ig
WRITE(iu06,*) ' * NUMBER OF WIND FIELD IS   MP = ', mp
WRITE(iu06,*) ' * DATE OF WIND FIELD IS IDTWIH = ', idtwih
WRITE(iu06,*) ' * MESSAGE IS               IOS = ', ios
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' * PROGRAM ABORTS    PROGRAM ABORTS         *'
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' ********************************************'
CALL ABORT
6200 CONTINUE
WRITE(iu06,*) ' '
WRITE(iu06,*) ' ********************************************'
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' *       FATAL ERROR IN SUB. NOTIM:         *'
WRITE(iu06,*) ' *       ==========================         *'
WRITE(iu06,*) ' * ERROR WHEN READING FROM SCRATCH UNIT     *'
WRITE(iu06,*) ' * FOR BLOCK NUMBER       IG = ', ig
WRITE(iu06,*) ' * DATE OF WIND FIELD IS IDT = ', idt
WRITE(iu06,*) ' * MESSAGE IS            IOS = ', ios
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' * PROGRAM ABORTS    PROGRAM ABORTS         *'
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' ********************************************'
CALL ABORT
6300 CONTINUE
WRITE(iu06,*) ' '
WRITE(iu06,*) ' ********************************************'
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' *       FATAL ERROR IN SUB. NOTIM:         *'
WRITE(iu06,*) ' *       ==========================         *'
WRITE(iu06,*) ' * ERROR WHEN WRITTING ON WIND OUTPUT FILE  *'
WRITE(iu06,*) ' * AFTER READING FROM SCRATCH UNIT          *'
WRITE(iu06,*) ' * FOR BLOCK NUMBER       IG = ', ig
WRITE(iu06,*) ' * DATE OF WIND FIELD IS IDT = ', idt
WRITE(iu06,*) ' * MESSAGE IS            IOS = ', ios
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' * PROGRAM ABORTS    PROGRAM ABORTS         *'
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' ********************************************'
CALL ABORT
6400 CONTINUE
WRITE(iu06,*) ' '
WRITE(iu06,*) ' ********************************************'
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' *       FATAL ERROR IN SUB. NOTIM:         *'
WRITE(iu06,*) ' *       ==========================         *'
WRITE(iu06,*) ' * ERROR WHEN WRITTING ON WIND OUTPUT FILE  *'
WRITE(iu06,*) ' * SCRATCH UNITS ARE NOT USED               *'
WRITE(iu06,*) ' * FOR BLOCK NUMBER          IG = ', ig
WRITE(iu06,*) ' * DATE OF WIND FIELD IS IDTWIH = ', idtwih
WRITE(iu06,*) ' * MESSAGE IS               IOS = ', ios
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' * PROGRAM ABORTS    PROGRAM ABORTS         *'
WRITE(iu06,*) ' *                                          *'
WRITE(iu06,*) ' ********************************************'
CALL ABORT

END SUBROUTINE notim
